/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.generated.server.ODMRPkg_DataGroup;
import oracle.dmt.dataminer.generated.server.OdmrObjectIds;
import oracle.dmt.dataminer.generated.server.OdmrTableColumn;
import oracle.dmt.dataminer.generated.server.OdmrTableColumns;
import oracle.dmt.dataminer.generated.server.OdmrTableMap;
import oracle.dmt.dataminer.generated.server.OdmrTableMaps;
import oracle.dmt.dataminer.repository.ColumnMapping;
import oracle.dmt.dataminer.repository.LoadableRepositoryObject;
import oracle.dmt.dataminer.repository.TableMapping;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.utils.SQLHelper;

public class NamedQueryMapping
extends LoadableRepositoryObject {
    private static final Logger theLogger = Logger.getLogger(NamedQueryMapping.class.getName());
    public static final String OBJ_ACTIVITY = "AT";
    public static final String OBJ_ACTIVITY_NODE = "ATN";
    public static final String OBJ_ACTIVITY_NODE_RESULT = "ATNR";
    public static final String LOAD_ALL_DETAILS = "ALL";
    public static final String LOAD_ONLY_TABLE_MAPS = "TABLE";
    private String _parentObjectType;
    private Character _parentActivityNodeType;
    private String _loadType = "ALL";
    List<TableMapping> _tableMappings = null;
    List<BigDecimal> _requiredColumns = new ArrayList<BigDecimal>();

    public NamedQueryMapping(char c, BigDecimal bigDecimal) {
        this(null, OBJ_ACTIVITY, bigDecimal, Character.valueOf(c));
    }

    public NamedQueryMapping(BigDecimal bigDecimal) {
        this((BigDecimal)null, OBJ_ACTIVITY_NODE, bigDecimal, (Character)null);
    }

    public NamedQueryMapping(BigDecimal bigDecimal, String string, BigDecimal bigDecimal2, Character c) {
        super(bigDecimal, bigDecimal2);
        this._parentObjectType = string;
        this._parentActivityNodeType = c;
    }

    public OdmrTableMaps getOdmrTableMaps() throws Exception {
        OdmrTableMaps odmrTableMaps = new OdmrTableMaps();
        OdmrTableMap[] odmrTableMapArray = new OdmrTableMap[this._tableMappings.size()];
        int n = 0;
        for (TableMapping tableMapping : this._tableMappings) {
            odmrTableMapArray[n++] = tableMapping.getOdmrTableMap();
        }
        odmrTableMaps.setArray(odmrTableMapArray);
        return odmrTableMaps;
    }

    public List<TableMapping> get_tableMappings() {
        return this._tableMappings;
    }

    public void setLoadType(String string) {
        this._loadType = string;
    }

    public List<BigDecimal> getRequiredColumns() {
        return this._requiredColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(ConnectionManager connectionManager) throws Exception {
        Connection connection = connectionManager.getConnection();
        try {
            Object object;
            String string = null;
            String string2 = null;
            if (OBJ_ACTIVITY.equals(this._parentObjectType)) {
                string = "ODMR_USER_AT_DG_TABLE_MAPS";
                string2 = "ODMR_USER_AT_DG_TAB_COL_MAPS";
            } else if (OBJ_ACTIVITY_NODE.equals(this._parentObjectType)) {
                string = "ODMR_USER_ATN_DG_TABLE_MAPS";
                string2 = "ODMR_USER_ATN_DG_TAB_COL_MAPS";
            } else if (OBJ_ACTIVITY_NODE_RESULT.equals(this._parentObjectType)) {
                string = "ODMR_USER_ATNR_DG_TABLE_MAPS";
                string2 = "ODMR_USER_ATNR_DG_TAB_COL_MAPS";
            } else assert (false);
            String string3 = null;
            ODMRPkg_DataGroup oDMRPkg_DataGroup = new ODMRPkg_DataGroup(connection);
            this._tableMappings = new ArrayList<TableMapping>();
            if (this.getId() == null) {
                object = new SQLHelper();
                try {
                    if (OBJ_ACTIVITY.equals(this._parentObjectType)) {
                        string3 = "SELECT DG_TAB_MAP_ID FROM ODMR_USER_AT_DG_TAB_MAPS WHERE AT_ID=? and NODE_TYPE=?";
                        ((SQLHelper)object).pstmt = connection.prepareStatement(string3);
                        ((SQLHelper)object).pstmt.setBigDecimal(1, this.getParentId());
                        ((SQLHelper)object).pstmt.setString(2, this._parentActivityNodeType.toString());
                        ((SQLHelper)object).rs = ((SQLHelper)object).pstmt.executeQuery();
                        if (((SQLHelper)object).rs.next()) {
                            this._id = ((SQLHelper)object).rs.getBigDecimal(1);
                        }
                    } else if (OBJ_ACTIVITY_NODE.equals(this._parentObjectType)) {
                        string3 = "SELECT DG_TAB_MAP_ID FROM ODMR_USER_ATN_DG_TAB_MAPS WHERE AT_NODE_ID=?";
                        ((SQLHelper)object).pstmt = connection.prepareStatement(string3);
                        ((SQLHelper)object).pstmt.setBigDecimal(1, this.getParentId());
                        ((SQLHelper)object).rs = ((SQLHelper)object).pstmt.executeQuery();
                        if (((SQLHelper)object).rs.next()) {
                            this._id = ((SQLHelper)object).rs.getBigDecimal(1);
                        }
                    } else if (OBJ_ACTIVITY_NODE_RESULT.equals(this._parentObjectType)) {
                        string3 = "SELECT DG_TAB_MAP_ID FROM ODMR_USER_ATNR_DG_TAB_MAPS WHERE AT_NODE_RESULTS_ID=? and ATNR_RESULT_TYPE=?";
                        ((SQLHelper)object).pstmt = connection.prepareStatement(string3);
                        ((SQLHelper)object).pstmt.setBigDecimal(1, this.getParentId());
                        ((SQLHelper)object).pstmt.setString(2, this._parentActivityNodeType.toString());
                        ((SQLHelper)object).rs = ((SQLHelper)object).pstmt.executeQuery();
                        if (((SQLHelper)object).rs.next()) {
                            this._id = ((SQLHelper)object).rs.getBigDecimal(1);
                        }
                        this._loadType = LOAD_ONLY_TABLE_MAPS;
                    } else assert (false);
                }
                finally {
                    ((SQLHelper)object).close();
                }
            }
            if (OBJ_ACTIVITY_NODE_RESULT.equals(this._parentObjectType)) {
                this.loadOnlyTableMaps(connection, string);
            } else {
                object = null;
                try (SQLHelper sQLHelper = new SQLHelper();){
                    if (OBJ_ACTIVITY.equals(this._parentObjectType)) {
                        string3 = "SELECT DG_TAB_ID FROM ODMR_USER_ACTIVITIES WHERE ACTIVITY_ID=?";
                        sQLHelper.pstmt = connection.prepareStatement(string3);
                        sQLHelper.pstmt.setBigDecimal(1, this.getParentId());
                        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                        sQLHelper.rs.next();
                        object = sQLHelper.rs.getBigDecimal(1);
                    } else if (OBJ_ACTIVITY_NODE.equals(this._parentObjectType)) {
                        string3 = "SELECT DG_TAB_ID FROM ODMR_USER_AT_NODE WHERE AT_NODE_ID=?";
                        sQLHelper.pstmt = connection.prepareStatement(string3);
                        sQLHelper.pstmt.setBigDecimal(1, this.getParentId());
                        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                        sQLHelper.rs.next();
                        object = sQLHelper.rs.getBigDecimal(1);
                    }
                }
                OdmrObjectIds[] odmrObjectIdsArray = new OdmrObjectIds[1];
                OdmrTableColumns[] odmrTableColumnsArray = new OdmrTableColumns[1];
                OdmrTableColumn[] odmrTableColumnArray = null;
                oDMRPkg_DataGroup.getLtabPhysicalTables((BigDecimal)object, odmrObjectIdsArray, odmrTableColumnsArray);
                BigDecimal[] bigDecimalArray = null;
                int n = 0;
                if (odmrObjectIdsArray[0] != null) {
                    bigDecimalArray = odmrObjectIdsArray[0].getArray();
                    n = bigDecimalArray.length;
                }
                if ((odmrTableColumnArray = odmrTableColumnsArray[0].getArray()) != null && odmrTableColumnArray.length > 0) {
                    this._requiredColumns = new ArrayList<BigDecimal>();
                    for (OdmrTableColumn object22 : odmrTableColumnArray) {
                        this._requiredColumns.add(object22.getColumnId());
                    }
                }
                OdmrTableColumn[] odmrTableColumnArray2 = new StringBuffer();
                for (int i = 0; i < bigDecimalArray.length; ++i) {
                    odmrTableColumnArray2.append(bigDecimalArray[i]);
                    if (i == bigDecimalArray.length - 1) {
                        odmrTableColumnArray2.append(") ");
                        continue;
                    }
                    odmrTableColumnArray2.append(", ");
                }
                if (this.getId() == null) {
                    if (n > 0) {
                        if (this._loadType.equals(LOAD_ALL_DETAILS)) {
                            try {
                                string3 = "SELECT TABLE_ID, SCHEMA_NAME, TABLE_NAME, COLUMN_ID, COLUMN_NAME,   COLUMN_DATA_TYPE, COLUMN_TYPE, COLUMN_ALIAS_NAME FROM ODMR_USER_DG_TAB_COLS WHERE TABLE_ID IN (";
                                string3 = string3 + odmrTableColumnArray2.toString();
                                string3 = string3 + " ORDER BY TABLE_ID ASC, COLUMN_NAME ASC";
                                sQLHelper.pstmt = connection.prepareStatement(string3);
                                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                                BigDecimal object3 = null;
                                TableMapping tableMapping = null;
                                while (sQLHelper.rs.next()) {
                                    BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("TABLE_ID");
                                    if (object3 == null || !object3.equals(bigDecimal)) {
                                        object3 = bigDecimal;
                                        tableMapping = new TableMapping(object3, sQLHelper.rs.getString("SCHEMA_NAME"), sQLHelper.rs.getString("TABLE_NAME"));
                                        this._tableMappings.add(tableMapping);
                                    }
                                    String string4 = sQLHelper.rs.getString("COLUMN_DATA_TYPE");
                                    String string5 = sQLHelper.rs.getString("COLUMN_NAME");
                                    tableMapping.addColumnMapping(new ColumnMapping(sQLHelper.rs.getBigDecimal("COLUMN_ID"), null, string5, string4, sQLHelper.rs.getString("COLUMN_TYPE"), sQLHelper.rs.getString("COLUMN_ALIAS_NAME")));
                                }
                            }
                            finally {
                                sQLHelper.close();
                            }
                        } else if (this._loadType.equals(LOAD_ONLY_TABLE_MAPS)) {
                            try {
                                string3 = "SELECT TABLE_ID, SCHEMA_NAME, TABLE_NAME FROM ODMR_USER_DG_TABLES WHERE TABLE_ID IN (";
                                string3 = string3 + odmrTableColumnArray2.toString();
                                string3 = string3 + " ORDER BY TABLE_ID ASC";
                                sQLHelper.pstmt = connection.prepareStatement(string3);
                                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                                BigDecimal bigDecimal = null;
                                int n2 = -1;
                                Object var17_28 = null;
                                while (sQLHelper.rs.next()) {
                                    BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal("TABLE_ID");
                                    if (bigDecimal != null && bigDecimal.equals(bigDecimal2)) continue;
                                    ++n2;
                                    TableMapping tableMapping = new TableMapping(bigDecimal2, sQLHelper.rs.getString("SCHEMA_NAME"), sQLHelper.rs.getString("TABLE_NAME"));
                                    this._tableMappings.add(tableMapping);
                                }
                            }
                            finally {
                                sQLHelper.close();
                            }
                        } else assert (false);
                    }
                } else if (this._loadType.equals(LOAD_ALL_DETAILS)) {
                    try {
                        string3 = " WITH map_cols as (SELECT DG_TABLE_ID, DG_SCHEMA_NAME, DG_TABLE_NAME, DG_TAB_COL_ID, DG_TAB_COLUMN_NAME, DG_TAB_COLUMN_DATA_TYPE, DG_TAB_COLUMN_TYPE, DG_TAB_COLUMN_ALIAS_NAME, MAP_COLUMN_NAME, MAP_TABLE_NAME, MAP_SCHEMA_NAME FROM " + string2 + " WHERE DG_TAB_MAP_ID=?), " + "unmap_cols as ( " + "SELECT TABLE_ID AS DG_TABLE_ID, SCHEMA_NAME AS DG_SCHEMA_NAME, TABLE_NAME AS DG_TABLE_NAME,  " + "COLUMN_ID AS DG_TAB_COL_ID, COLUMN_NAME AS DG_TAB_COLUMN_NAME,  " + "COLUMN_DATA_TYPE AS DG_TAB_COLUMN_DATA_TYPE, COLUMN_TYPE DG_TAB_COLUMN_TYPE, COLUMN_ALIAS_NAME DG_TAB_COLUMN_ALIAS_NAME,  " + "NULL AS MAP_COLUMN_NAME,  " + "NULL AS MAP_TABLE_NAME,  " + "NULL AS MAP_SCHEMA_NAME " + "FROM ODMR_USER_DG_TAB_COLS WHERE TABLE_ID IN (" + odmrTableColumnArray2 + " AND (TABLE_ID NOT IN (SELECT DG_TABLE_ID FROM map_cols) OR (COLUMN_ID NOT IN (SELECT DG_TAB_COL_ID from map_cols)))), " + "all_cols as (select * from map_cols UNION ALL select * from unmap_cols) " + "select * from all_cols ORDER BY DG_TABLE_ID ASC, MAP_TABLE_NAME ASC, DG_TAB_COLUMN_NAME ASC";
                        sQLHelper.pstmt = connection.prepareStatement(string3);
                        sQLHelper.pstmt.setBigDecimal(1, this.getId());
                        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                        BigDecimal object4 = null;
                        TableMapping tableMapping = null;
                        while (sQLHelper.rs.next()) {
                            BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("DG_TABLE_ID");
                            if (object4 == null || !object4.equals(bigDecimal)) {
                                object4 = bigDecimal;
                                tableMapping = new TableMapping(bigDecimal, this.getId(), sQLHelper.rs.getString("DG_SCHEMA_NAME"), sQLHelper.rs.getString("DG_TABLE_NAME"), sQLHelper.rs.getString("MAP_SCHEMA_NAME"), sQLHelper.rs.getString("MAP_TABLE_NAME"));
                                tableMapping.loadDataTypeColsMap(connectionManager);
                                this._tableMappings.add(tableMapping);
                            }
                            tableMapping.addColumnMapping(new ColumnMapping(sQLHelper.rs.getBigDecimal("DG_TAB_COL_ID"), sQLHelper.rs.getString("MAP_COLUMN_NAME"), sQLHelper.rs.getString("DG_TAB_COLUMN_NAME"), sQLHelper.rs.getString("DG_TAB_COLUMN_DATA_TYPE"), sQLHelper.rs.getString("DG_TAB_COLUMN_TYPE"), sQLHelper.rs.getString("DG_TAB_COLUMN_ALIAS_NAME")));
                        }
                    }
                    finally {
                        sQLHelper.close();
                    }
                } else if (this._loadType.equals(LOAD_ONLY_TABLE_MAPS)) {
                    this.loadOnlyTableMaps(connection, string);
                }
            }
            this.setLoaded(true);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            SQLHelper.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOnlyTableMaps(Connection connection, String string) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = null;
        try {
            string2 = "SELECT DG_TABLE_ID, DG_SCHEMA_NAME, DG_TABLE_NAME, MAP_SCHEMA_NAME, MAP_TABLE_NAME FROM " + string + " WHERE DG_TAB_MAP_ID=?";
            string2 = string2 + " ORDER BY DG_TABLE_ID ASC";
            statement = connection.prepareStatement(string2);
            statement.setBigDecimal(1, this.getId());
            resultSet = statement.executeQuery();
            BigDecimal bigDecimal = null;
            TableMapping tableMapping = null;
            while (resultSet.next()) {
                BigDecimal bigDecimal2 = resultSet.getBigDecimal("DG_TABLE_ID");
                if (bigDecimal != null && bigDecimal.equals(bigDecimal2)) continue;
                tableMapping = new TableMapping(bigDecimal2, this.getId(), resultSet.getString("DG_SCHEMA_NAME"), resultSet.getString("DG_TABLE_NAME"), resultSet.getString("MAP_SCHEMA_NAME"), resultSet.getString("MAP_TABLE_NAME"));
                this._tableMappings.add(tableMapping);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
    }

    @Override
    public void refresh(ConnectionManager connectionManager) throws Exception {
        this.load(connectionManager);
    }

    public void save(Connection connection) throws Exception {
        ODMRPkg_DataGroup oDMRPkg_DataGroup = new ODMRPkg_DataGroup(connection);
        if (this._parentObjectType.equals(OBJ_ACTIVITY)) {
            oDMRPkg_DataGroup.createDgTableMaps(this.getParentId(), this._parentActivityNodeType.toString(), null, this.getOdmrTableMaps());
        } else if (this._parentObjectType.equals(OBJ_ACTIVITY_NODE)) {
            oDMRPkg_DataGroup.createDgTableMaps(null, null, this.getParentId(), this.getOdmrTableMaps());
        } else assert (false);
    }

    @Override
    public void unload() {
        this.setLoaded(false);
    }
}

