/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.partition;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.partition.PartitionColumn;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.dmt.dataminer.partition.Rule;
import oracle.dmt.dataminer.partition.ValueSelectorPanel;
import oracle.ide.Context;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ghost.GhostPointingPalette;
import oracle.javatools.ui.ghost.UIConstants;

public class ValueCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JPanel panel = new JPanel();
    private JTextField textField = new JTextField();
    private JButton button = new JButton();
    private JTable table;

    public ValueCellEditor(final Context context, final String string) {
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(this.textField);
        this.panel.add(this.button);
        this.panel.setBackground(this.textField.getBackground());
        this.panel.setBorder(this.textField.getBorder());
        this.textField.setBorder(null);
        this.button.setIcon(OracleIcons.getIcon((String)"search.png"));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ValueCellEditor.this.table.getEditingRow();
                TableModel tableModel = ValueCellEditor.this.table.getModel();
                String string2 = tableModel.getValueAt(n, 0).toString();
                GhostPointingPalette ghostPointingPalette = new GhostPointingPalette();
                ValueSelectorPanel valueSelectorPanel = new ValueSelectorPanel(context, string2, string, ValueCellEditor.this);
                ghostPointingPalette.setTitle(PartitionsLrb.get("PARTITION_DETAILS_TITLE"));
                int n2 = ((ValueCellEditor)ValueCellEditor.this).textField.getSize().height - 2;
                ghostPointingPalette.setPointing((JComponent)ValueCellEditor.this.textField, new Point(2, n2));
                ghostPointingPalette.setLook(UIConstants.Look.LIGHT);
                ghostPointingPalette.setHideOnLoseFocus(true);
                ghostPointingPalette.add((Component)valueSelectorPanel);
                ghostPointingPalette.setCloseVisible(false);
                ghostPointingPalette.setReceivesFocus(true);
                ghostPointingPalette.pack();
                ghostPointingPalette.show(true, true);
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (this.table == null) {
            this.table = jTable;
        }
        Object object2 = jTable.getValueAt(n, 1);
        assert (object2 instanceof Rule.OPERATORS);
        final Rule.OPERATORS oPERATORS = (Rule.OPERATORS)((Object)object2);
        this.button.setVisible(oPERATORS == Rule.OPERATORS.IS);
        object2 = jTable.getValueAt(n, 0);
        assert (object2 instanceof PartitionColumn);
        final PartitionColumn partitionColumn = (PartitionColumn)object2;
        this.textField.setText(object.toString());
        this.textField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent jComponent) {
                if (oPERATORS.isNumberOperator()) {
                    if (partitionColumn.getDataType().contains("CHAR")) {
                        return true;
                    }
                    boolean bl = Pattern.matches("\\d*(\\.\\d+)?", ValueCellEditor.this.textField.getText());
                    return bl;
                }
                return true;
            }

            @Override
            public boolean shouldYieldFocus(JComponent jComponent) {
                boolean bl = this.verify(jComponent);
                if (!bl) {
                    JOptionPane.showMessageDialog(null, PartitionsLrb.get("FILTER_VALIDATION_NUMBER"));
                }
                return bl;
            }
        });
        return this.panel;
    }

    @Override
    public boolean stopCellEditing() {
        if (!this.textField.getInputVerifier().shouldYieldFocus(this.textField)) {
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return this.textField.getText();
    }

    public void setText(String string) {
        this.textField.setText(string);
        this.stopCellEditing();
    }
}

