/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.partition;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.partition.PartitionColumn;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.dmt.dataminer.partition.Rule;
import oracle.dmt.dataminer.partition.ValueCellEditor;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.partitions.Sorting;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class RulesPartitionFilterSortingPanel
extends JPanel
implements DataminerGUIPanel {
    private static final Logger LOGGER = Logger.getLogger(RulesPartitionFilterSortingPanel.class.getName());
    private static final String[] SORT_COLUMNS_CLASSIFICATION = new String[]{CommonLrb.get("COMMON_MODEL"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_ID"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE"), TestViewerLrb.get("OVERALL_ACCURACY_COL"), TestViewerLrb.get("AVG_ACCURACY_COL"), TestViewerLrb.get("BUILD_ROWS"), TestViewerLrb.get("TEST_ROWS")};
    private static final String[] SORT_COLUMNS_REGRESSION = new String[]{CommonLrb.get("COMMON_MODEL"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_ID"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE"), TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"), TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"), TestViewerLrb.get("MEAN_PREDICTED_VALUE"), TestViewerLrb.get("MEAN_ACTUAL_VALUE"), TestViewerLrb.get("BUILD_ROWS"), TestViewerLrb.get("TEST_ROWS")};
    private Context context;
    private String modelsSQL;
    private boolean hasError;
    private boolean hasFiltering;
    private boolean showSorting;
    private boolean isClassification;
    private PartitionFilterTableModel model;
    private Sorting sortingOrder;
    private String sortColumn;
    private DataMinerTablePanel dataMinerTablePanel1;
    private JRadioButton jAscSortBtn;
    private JPanel jContainterPanel;
    private JRadioButton jDescSortBtn;
    private JLabel jErrorLabel;
    private JSpinner jFetchSize;
    private JLabel jFetchSizeLabel;
    private JLabel jFilterInfoLabel;
    private JPanel jFilterPanel;
    private JPanel jFilterTitlePanel;
    private JLabel jFilteringTitleLabel;
    private JPanel jInfoPanel;
    private JRadioButton jMatchAllRadio;
    private JRadioButton jMatchAnyRadio;
    private ButtonGroup jMatchGroup;
    private JButton jQueryBtn;
    private JPanel jSetupPanel;
    private JButton jShowBtn;
    private JLabel jSortByLabel;
    private JComboBox<String> jSortColumnCombo;
    private ButtonGroup jSortGroup;
    private ButtonGroup jSortOrderGroup;
    private JPanel jSortingPanel;
    private JLabel jSortingTitleLabel;
    private JPanel jSortingTitlePanel;

    public RulesPartitionFilterSortingPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public RulesPartitionFilterSortingPanel(Context context, String[] stringArray) {
        this(context, stringArray, false, false);
    }

    public RulesPartitionFilterSortingPanel(Context context, String[] stringArray, boolean bl, boolean bl2) {
        this.hasError = false;
        this.hasFiltering = false;
        this.context = context;
        this.sortingOrder = Sorting.DESC;
        this.sortColumn = bl2 ? SORT_COLUMNS_CLASSIFICATION[0] : SORT_COLUMNS_REGRESSION[0];
        this.showSorting = bl;
        this.isClassification = bl2;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append("'");
            stringBuilder.append(string);
            stringBuilder.append("',");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        this.modelsSQL = stringBuilder.toString();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jMatchGroup = new ButtonGroup();
        this.jSortGroup = new ButtonGroup();
        this.jSortOrderGroup = new ButtonGroup();
        this.jSetupPanel = new JPanel();
        this.jFetchSizeLabel = new JLabel();
        this.jFetchSize = new JSpinner();
        this.jQueryBtn = new JButton();
        this.jShowBtn = new JButton();
        this.jContainterPanel = new JPanel();
        this.jInfoPanel = new JPanel();
        this.jFilterInfoLabel = new JLabel();
        this.jFilterTitlePanel = new JPanel();
        this.jFilteringTitleLabel = new JLabel();
        this.jFilterPanel = new JPanel();
        this.jMatchAllRadio = new JRadioButton();
        this.jMatchAnyRadio = new JRadioButton();
        this.dataMinerTablePanel1 = new DataMinerTablePanel();
        this.jErrorLabel = new JLabel();
        this.jSortingTitlePanel = new JPanel();
        this.jSortingTitleLabel = new JLabel();
        this.jSortingPanel = new JPanel();
        this.jSortColumnCombo = new JComboBox();
        this.jDescSortBtn = new JRadioButton();
        this.jAscSortBtn = new JRadioButton();
        this.jSortByLabel = new JLabel();
        this.setLayout(new BoxLayout(this, 1));
        this.jFetchSizeLabel.setText("Fetch Size:");
        this.jQueryBtn.setText("Query");
        this.jShowBtn.setText("Less");
        this.jShowBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesPartitionFilterSortingPanel.this.jShowBtnActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jSetupPanel);
        this.jSetupPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jFetchSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jFetchSize, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 624, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jShowBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jQueryBtn, -1, 100, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFetchSizeLabel).addComponent(this.jFetchSize, -2, -1, -2).addComponent(this.jQueryBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jShowBtn).addGap(5, 5, 5)));
        this.add(this.jSetupPanel);
        this.jContainterPanel.setLayout(new BoxLayout(this.jContainterPanel, 3));
        this.jFilterInfoLabel.setText("Active Filter");
        GroupLayout groupLayout2 = new GroupLayout(this.jInfoPanel);
        this.jInfoPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jFilterInfoLabel).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jFilterInfoLabel).addGap(5, 5, 5)));
        this.jContainterPanel.add(this.jInfoPanel);
        this.jFilteringTitleLabel.setText("Filtering");
        GroupLayout groupLayout3 = new GroupLayout(this.jFilterTitlePanel);
        this.jFilterTitlePanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jFilteringTitleLabel, -1, 847, Short.MAX_VALUE).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jFilteringTitleLabel).addGap(5, 5, 5)));
        this.jContainterPanel.add(this.jFilterTitlePanel);
        this.jMatchGroup.add(this.jMatchAllRadio);
        this.jMatchAllRadio.setSelected(true);
        this.jMatchAllRadio.setText("Match ALL of the following");
        this.jMatchGroup.add(this.jMatchAnyRadio);
        this.jMatchAnyRadio.setText("Match ANY of the following");
        this.jErrorLabel.setForeground(new Color(255, 51, 0));
        this.jErrorLabel.setText("A Rule is Incomplete");
        GroupLayout groupLayout4 = new GroupLayout(this.jFilterPanel);
        this.jFilterPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel1, -1, -1, Short.MAX_VALUE).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.jMatchAllRadio).addGap(18, 18, 18).addComponent(this.jMatchAnyRadio)).addComponent(this.jErrorLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMatchAllRadio).addComponent(this.jMatchAnyRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dataMinerTablePanel1, -1, 111, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jErrorLabel).addGap(5, 5, 5)));
        this.jContainterPanel.add(this.jFilterPanel);
        this.jSortingTitleLabel.setText("Sorting");
        GroupLayout groupLayout5 = new GroupLayout(this.jSortingTitlePanel);
        this.jSortingTitlePanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.jSortingTitleLabel, -1, 847, Short.MAX_VALUE).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jSortingTitleLabel).addGap(5, 5, 5)));
        this.jContainterPanel.add(this.jSortingTitlePanel);
        this.jSortColumnCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesPartitionFilterSortingPanel.this.jSortColumnComboActionPerformed(actionEvent);
            }
        });
        this.jSortOrderGroup.add(this.jDescSortBtn);
        this.jDescSortBtn.setSelected(true);
        this.jDescSortBtn.setText("Descending");
        this.jDescSortBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesPartitionFilterSortingPanel.this.jDescSortBtnActionPerformed(actionEvent);
            }
        });
        this.jSortOrderGroup.add(this.jAscSortBtn);
        this.jAscSortBtn.setText("Ascending");
        this.jAscSortBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesPartitionFilterSortingPanel.this.jAscSortBtnActionPerformed(actionEvent);
            }
        });
        this.jSortByLabel.setText("Sort By");
        GroupLayout groupLayout6 = new GroupLayout(this.jSortingPanel);
        this.jSortingPanel.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addComponent(this.jSortByLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSortColumnCombo, -2, 200, -2).addGap(18, 18, 18).addComponent(this.jDescSortBtn).addGap(18, 18, 18).addComponent(this.jAscSortBtn).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSortColumnCombo, -2, -1, -2).addComponent(this.jDescSortBtn).addComponent(this.jAscSortBtn).addComponent(this.jSortByLabel)).addGap(5, 5, 5)));
        this.jContainterPanel.add(this.jSortingPanel);
        this.add(this.jContainterPanel);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jErrorLabel, null, (String)"");
        ResourceUtils.resButton((AbstractButton)this.jMatchAllRadio, (String)PartitionsLrb.get("FILTER_MATCH_ALL"));
        ResourceUtils.resButton((AbstractButton)this.jMatchAnyRadio, (String)PartitionsLrb.get("FILTER_MATCH_ANY"));
        ResourceUtils.resLabel((JLabel)this.jFilterInfoLabel, null, (String)PartitionsLrb.get("FILTER_NONE"));
        ResourceUtils.resButton((AbstractButton)this.jQueryBtn, (String)CommonLrb.get("COMMON_QUERY"));
        ResourceUtils.resButton((AbstractButton)this.jShowBtn, (String)CommonLrb.get("COMMON_MORE"));
        ResourceUtils.resLabel((JLabel)this.jFetchSizeLabel, (Component)this.jFetchSize, (String)PartitionsLrb.get("FILTER_FETCH_SIZE"));
        ResourceUtils.resButton((AbstractButton)this.jAscSortBtn, (String)CommonLrb.get("COMMON_ASCENDING"));
        ResourceUtils.resButton((AbstractButton)this.jDescSortBtn, (String)CommonLrb.get("COMMON_DESCENDING"));
        ResourceUtils.resLabel((JLabel)this.jFilteringTitleLabel, null, (String)PartitionsLrb.get("FILTER_TITLE"));
        ResourceUtils.resLabel((JLabel)this.jSortingTitleLabel, null, (String)PartitionsLrb.get("SORTING_TITLE"));
        ResourceUtils.resLabel((JLabel)this.jSortByLabel, null, (String)CommonLrb.get("COMMON_SORT_BY"));
        this.jQueryBtn.setIcon(OracleIcons.getIcon((String)"run.png"));
    }

    @Override
    public void initUI() {
        Object object;
        String string = this.showSorting ? PartitionsLrb.get("FILTER_SORTING_TITLE") : PartitionsLrb.get("FILTER_TITLE");
        this.jContainterPanel.setBorder(BorderFactory.createTitledBorder(string));
        this.jFilterTitlePanel.setVisible(this.showSorting);
        this.jSortingTitlePanel.setVisible(this.showSorting);
        if (this.showSorting) {
            object = this.isClassification ? SORT_COLUMNS_CLASSIFICATION : SORT_COLUMNS_REGRESSION;
            this.jSortColumnCombo.setModel(new DefaultComboBoxModel<String>((E[])object));
        }
        this.jFetchSize.setValue(100);
        this.model = new PartitionFilterTableModel();
        this.model.addTableModelListener(new PartitionFilterTableModelListener());
        this.dataMinerTablePanel1.setup((TableModel)((Object)this.model), PartitionsLrb.get("FILTER_TITLE"), -1);
        this.dataMinerTablePanel1.removeSearchField();
        this.dataMinerTablePanel1.getTable().setRowSorter(null);
        object = this.dataMinerTablePanel1.getTable();
        ((JTable)object).setAutoResizeMode(4);
        ButtonsCellEditorRenderer buttonsCellEditorRenderer = new ButtonsCellEditorRenderer(new AddRuleActionListener(), new RemoveRuleActionListener());
        TableColumnModel tableColumnModel = this.dataMinerTablePanel1.getTable().getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new OperatorCellEditor());
        TableColumn tableColumn2 = tableColumnModel.getColumn(2);
        tableColumn2.setCellEditor(new ValueCellEditor(this.context, this.modelsSQL));
        TableColumn tableColumn3 = tableColumnModel.getColumn(3);
        tableColumn3.setCellRenderer(buttonsCellEditorRenderer);
        tableColumn3.setCellEditor(buttonsCellEditorRenderer);
        tableColumn3.setPreferredWidth(80);
        tableColumn3.setMaxWidth(80);
        this.setFilterVisible(false);
        new LoadFilterInfo().execute();
    }

    private void jShowBtnActionPerformed(ActionEvent actionEvent) {
        if (CommonLrb.get("COMMON_MORE").equals(this.jShowBtn.getText())) {
            this.setFilterVisible(true);
            this.jShowBtn.setText(CommonLrb.get("COMMON_LESS"));
        } else {
            this.setFilterVisible(false);
            this.jShowBtn.setText(CommonLrb.get("COMMON_MORE"));
        }
        this.jContainterPanel.invalidate();
    }

    private void jDescSortBtnActionPerformed(ActionEvent actionEvent) {
        this.sortingOrder = Sorting.DESC;
    }

    private void jAscSortBtnActionPerformed(ActionEvent actionEvent) {
        this.sortingOrder = Sorting.ASC;
    }

    private void jSortColumnComboActionPerformed(ActionEvent actionEvent) {
        this.sortColumn = this.jSortColumnCombo.getSelectedItem().toString();
    }

    public void setFilterVisible(boolean bl) {
        this.jInfoPanel.setVisible(!bl);
        this.jSortingTitlePanel.setVisible(bl && this.showSorting);
        this.jFilterTitlePanel.setVisible(bl && this.showSorting);
        this.jFilterPanel.setVisible(bl);
        this.jSortingPanel.setVisible(this.showSorting && bl);
        if (this.hasError) {
            ResourceUtils.resLabel((JLabel)this.jFilterInfoLabel, null, (String)PartitionsLrb.get("FILTER_COLAPSED_ERROR"));
            this.jFilterInfoLabel.setIcon(DataMinerIcons.get(Icons.ERROR_STATUS));
        } else if (!this.hasFiltering) {
            ResourceUtils.resLabel((JLabel)this.jFilterInfoLabel, null, (String)PartitionsLrb.get("FILTER_NONE"));
            this.jFilterInfoLabel.setIcon(null);
        } else if (this.hasFiltering) {
            String string = this.showSorting ? PartitionsLrb.get("FILTER_SORTING_COLAPSED_ACTIVE") : PartitionsLrb.get("FILTER_COLAPSED_ACTIVE");
            ResourceUtils.resLabel((JLabel)this.jFilterInfoLabel, null, (String)string);
            this.jFilterInfoLabel.setIcon(OracleIcons.getIcon((String)"filter.png"));
        }
        this.invalidate();
    }

    public List<Rule> getFilterRules() {
        List<Rule> list = this.model.getSrcData();
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<Rule> arrayList = new ArrayList<Rule>(list);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (!rule.isEmpty()) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public boolean matchAll() {
        return this.jMatchAllRadio.isSelected();
    }

    public int getFetchSize() {
        return (Integer)this.jFetchSize.getValue();
    }

    public Sorting getSortOrder() {
        return this.sortingOrder;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public JButton getQueryButton() {
        return this.jQueryBtn;
    }

    public void checkRules() {
        List list = this.model.getSrcData();
        boolean bl = true;
        if (list.isEmpty()) {
            this.hasFiltering = false;
        } else {
            int n = 0;
            for (Rule rule : list) {
                if (rule.isEmpty()) {
                    ++n;
                    continue;
                }
                if (rule.isComplete()) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.hasFiltering = n != list.size();
                this.hasError = false;
            } else {
                this.hasError = true;
            }
        }
        this.jErrorLabel.setText(bl ? "" : PartitionsLrb.get("FILTER_ERROR"));
        this.jQueryBtn.setEnabled(bl);
    }

    private static class OperatorCellEditor
    extends DefaultCellEditor {
        private static final DefaultComboBoxModel<Rule.OPERATORS> NUMBER_MODEL = new DefaultComboBoxModel();
        private static final DefaultComboBoxModel<Rule.OPERATORS> STRING_MODEL;

        private OperatorCellEditor() {
            super(new JComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            assert (component instanceof JComboBox);
            JComboBox jComboBox = (JComboBox)component;
            Object object2 = jTable.getValueAt(n, 0);
            assert (object2 instanceof PartitionColumn);
            PartitionColumn partitionColumn = (PartitionColumn)object2;
            if (partitionColumn.getDataType().startsWith("CHAR")) {
                jComboBox.setModel(STRING_MODEL);
            } else {
                jComboBox.setModel(NUMBER_MODEL);
            }
            return component;
        }

        static {
            NUMBER_MODEL.addElement(Rule.OPERATORS.IS);
            NUMBER_MODEL.addElement(Rule.OPERATORS.GREATER_THAN);
            NUMBER_MODEL.addElement(Rule.OPERATORS.LESS_THAN);
            STRING_MODEL = new DefaultComboBoxModel();
            STRING_MODEL.addElement(Rule.OPERATORS.IS);
            STRING_MODEL.addElement(Rule.OPERATORS.IS_NOT);
            STRING_MODEL.addElement(Rule.OPERATORS.CONTAINS);
            STRING_MODEL.addElement(Rule.OPERATORS.NOT_CONTAINS);
            STRING_MODEL.addElement(Rule.OPERATORS.STARTS);
            STRING_MODEL.addElement(Rule.OPERATORS.NOT_START);
            STRING_MODEL.addElement(Rule.OPERATORS.ENDS);
            STRING_MODEL.addElement(Rule.OPERATORS.NOT_END);
        }
    }

    private static class ButtonsCellEditorRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener {
        private final JPanel editPanel;
        private final JPanel renderPanel;
        private final JButton renderAddButton;
        private final JButton renderRemButton;
        private final JButton editAddButton;
        private final JButton editRemButton;
        private final ActionListener actionAdd;
        private final ActionListener actionRem;

        public ButtonsCellEditorRenderer(ActionListener actionListener, ActionListener actionListener2) {
            this.actionAdd = actionListener;
            this.actionRem = actionListener2;
            this.renderPanel = new JPanel();
            this.renderPanel.setLayout(new BoxLayout(this.renderPanel, 0));
            this.renderAddButton = new JButton("+");
            this.renderRemButton = new JButton("-");
            this.renderPanel.add(this.renderRemButton);
            this.renderPanel.add(this.renderAddButton);
            this.editPanel = new JPanel();
            this.editPanel.setLayout(new BoxLayout(this.editPanel, 0));
            this.editAddButton = new JButton("+");
            this.editRemButton = new JButton("-");
            this.editPanel.add(this.editRemButton);
            this.editPanel.add(this.editAddButton);
            this.editAddButton.addActionListener(actionListener);
            this.editRemButton.addActionListener(actionListener2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.renderPanel;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.editPanel;
        }

        @Override
        public Object getCellEditorValue() {
            return "";
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.fireEditingStopped();
            ActionEvent actionEvent2 = new ActionEvent(this, 1001, actionEvent.getActionCommand());
            if ("+".equals(actionEvent.getActionCommand())) {
                this.actionAdd.actionPerformed(actionEvent2);
            } else {
                this.actionRem.actionPerformed(actionEvent2);
            }
        }
    }

    private static class PartitionFilterTableModel
    extends ODMrTableModel<Rule> {
        private static final int PARTITION_KEY = 0;
        private static final int OPERATOR = 1;
        private static final int VALUE = 2;
        private static final int ACTION = 3;

        private PartitionFilterTableModel() {
            super(new String[]{PartitionsLrb.get("FILTER_COL_PARTITION_KEY"), PartitionsLrb.get("FILTER_COL_OPERATOR"), PartitionsLrb.get("FILTER_COL_VALUE"), PartitionsLrb.get("FILTER_COL_ACTION")}, new ArrayList());
            this.getSrcData().add(Rule.createEmptyRule());
        }

        public Object getValueAt(int n, int n2) {
            Rule rule = (Rule)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    return rule.getPartitionKey();
                }
                case 1: {
                    return rule.getOperator();
                }
                case 2: {
                    return rule.getValue();
                }
                case 3: {
                    return "";
                }
            }
            throw new IllegalArgumentException("Invalid column index");
        }

        public void setValueAt(Object object, int n, int n2) {
            Rule rule = (Rule)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    rule.setPartitionKey((PartitionColumn)object);
                    break;
                }
                case 1: {
                    assert (object instanceof Rule.OPERATORS);
                    rule.setOperator((Rule.OPERATORS)((Object)object));
                    break;
                }
                case 2: {
                    rule.setValue(object.toString());
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid column index");
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        public boolean isCellEditable(int n, int n2) {
            switch (n2) {
                case 0: 
                case 3: {
                    return true;
                }
                case 1: 
                case 2: {
                    Rule rule = (Rule)this.srcData.get(n);
                    return rule.getPartitionKey() != null;
                }
            }
            return false;
        }
    }

    private class RemoveRuleActionListener
    implements ActionListener {
        private RemoveRuleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataMinerTable dataMinerTable = RulesPartitionFilterSortingPanel.this.dataMinerTablePanel1.getTable();
            int n = ((JTable)((Object)dataMinerTable)).getEditingRow();
            if (n == -1) {
                n = ((JTable)((Object)dataMinerTable)).getSelectedRow();
            }
            if (n == -1) {
                return;
            }
            RulesPartitionFilterSortingPanel.this.model.removeRow(n);
            if (RulesPartitionFilterSortingPanel.this.model.getRowCount() == 0) {
                RulesPartitionFilterSortingPanel.this.model.addRow(Rule.createEmptyRule());
            }
        }
    }

    private class AddRuleActionListener
    implements ActionListener {
        private AddRuleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataMinerTable dataMinerTable = RulesPartitionFilterSortingPanel.this.dataMinerTablePanel1.getTable();
            int n = ((JTable)((Object)dataMinerTable)).getEditingRow();
            if (n == -1) {
                n = ((JTable)((Object)dataMinerTable)).getSelectedRow();
            }
            if (n == -1) {
                RulesPartitionFilterSortingPanel.this.model.getSrcData().add(Rule.createEmptyRule());
            } else {
                RulesPartitionFilterSortingPanel.this.model.getSrcData().add(n + 1, Rule.createEmptyRule());
            }
            RulesPartitionFilterSortingPanel.this.model.fireTableDataChanged();
        }
    }

    private class PartitionFilterTableModelListener
    implements TableModelListener {
        private PartitionFilterTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 0) {
                int n = tableModelEvent.getFirstRow();
                DataMinerTable dataMinerTable = RulesPartitionFilterSortingPanel.this.dataMinerTablePanel1.getTable();
                PartitionColumn partitionColumn = (PartitionColumn)((JTable)((Object)dataMinerTable)).getValueAt(n, 0);
                if (partitionColumn == null) {
                    return;
                }
                Rule.OPERATORS oPERATORS = (Rule.OPERATORS)((Object)((JTable)((Object)dataMinerTable)).getValueAt(n, 1));
                if (partitionColumn.getDataType().startsWith("VARCHAR")) {
                    if (!oPERATORS.isStringOperator()) {
                        ((JTable)((Object)dataMinerTable)).setValueAt((Object)Rule.OPERATORS.EMPTY, n, 1);
                    }
                } else if (!oPERATORS.isNumberOperator()) {
                    ((JTable)((Object)dataMinerTable)).setValueAt((Object)Rule.OPERATORS.EMPTY, n, 1);
                }
            }
            if (tableModelEvent.getType() == 0 || tableModelEvent.getType() == -1 || tableModelEvent.getType() == 1) {
                RulesPartitionFilterSortingPanel.this.checkRules();
            }
        }
    }

    private class LoadFilterInfo
    extends ODMrSwingWorker<List<PartitionColumn>, Void> {
        private static final String QUERY = "SELECT DISTINCT mp.column_name, ma.data_type\nFROM all_mining_model_partitions mp, all_mining_model_attributes ma\nWHERE mp.model_name IN ({MODEL})\nAND   mp.model_name  = ma.model_name\nAND   mp.column_name = ma.attribute_name";

        private LoadFilterInfo() {
            super(RulesPartitionFilterSortingPanel.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<PartitionColumn> doInBackground() throws Exception {
            SQLHelper sQLHelper = new SQLHelper();
            String string = QUERY.replace("{MODEL}", RulesPartitionFilterSortingPanel.this.modelsSQL);
            ArrayList<PartitionColumn> arrayList = new ArrayList<PartitionColumn>();
            try {
                sQLHelper.conn = ConnectionFolder.getConnection(RulesPartitionFilterSortingPanel.this.context);
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    PartitionColumn partitionColumn = new PartitionColumn(sQLHelper.rs.getString(1), sQLHelper.rs.getString(2), null);
                    arrayList.add(partitionColumn);
                }
            }
            finally {
                sQLHelper.close();
            }
            return arrayList;
        }

        @Override
        protected void onSuccess(List<PartitionColumn> list) throws Exception {
            JComboBox<PartitionColumn> jComboBox = new JComboBox<PartitionColumn>();
            TableColumnModel tableColumnModel = RulesPartitionFilterSortingPanel.this.dataMinerTablePanel1.getTable().getColumnModel();
            jComboBox.setModel(new DefaultComboBoxModel<PartitionColumn>(list.toArray(new PartitionColumn[list.size()])));
            tableColumnModel.getColumn(0).setCellEditor(new DefaultCellEditor(jComboBox));
        }
    }
}

