/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.awt.EventQueue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataMinerNode;
import oracle.dmt.dataminer.repository.WorkflowProject;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.javatools.icons.OracleIcons;

public class ProjectFolder
extends BaseTreeNode {
    private static final Logger theLogger = Logger.getLogger(ProjectFolder.class.getName());
    private static Icon s_icon;
    private BigDecimal _id;

    public ProjectFolder() {
        this.getAttributes().set(ElementAttributes.NAVIGABLE);
    }

    @Override
    public boolean isDeleteable() {
        return true;
    }

    public Icon getIcon() {
        if (s_icon == null) {
            s_icon = OracleIcons.getIcon((String)"project.png");
        }
        return s_icon;
    }

    public void setId(BigDecimal bigDecimal) {
        this._id = bigDecimal;
    }

    public BigDecimal getId() {
        return this._id;
    }

    public static WorkflowProject getWorkflowProject(Context context) {
        WorkflowProject workflowProject = null;
        ProjectFolder projectFolder = ProjectFolder.getProjectFolder(context);
        if (projectFolder != null) {
            workflowProject = (WorkflowProject)projectFolder.getRepositoryData();
        }
        return workflowProject;
    }

    public static ProjectFolder getProjectFolder(Context context) {
        ProjectFolder projectFolder = null;
        Node node = context.getNode();
        DataMinerNode dataMinerNode = (DataMinerNode)node;
        if (node == null) {
            return null;
        }
        if (node instanceof Connections) {
            return null;
        }
        if (node instanceof ConnectionFolder) {
            return null;
        }
        if (node instanceof ProjectFolder) {
            projectFolder = (ProjectFolder)node;
        } else {
            Element element = dataMinerNode.getParent().getAncestor(ProjectFolder.class);
            if (element != null && element instanceof ProjectFolder) {
                projectFolder = (ProjectFolder)element;
            }
        }
        return projectFolder;
    }

    public static void delete(ConnectionManager connectionManager, Element[] elementArray) throws Exception {
        ArrayList<ProjectFolder> arrayList = new ArrayList<ProjectFolder>();
        BigDecimal[] bigDecimalArray = new BigDecimal[elementArray.length];
        for (int i = 0; i < elementArray.length; ++i) {
            ProjectFolder projectFolder = (ProjectFolder)elementArray[i];
            bigDecimalArray[i] = ((WorkflowProject)projectFolder.getRepositoryData()).getId();
            arrayList.add(projectFolder);
        }
        WorkflowProject.delete(connectionManager, bigDecimalArray);
        if (arrayList.size() > 0) {
            ConnectionFolder connectionFolder = (ConnectionFolder)((ProjectFolder)arrayList.get(0)).getParent().getData();
            for (ProjectFolder projectFolder : arrayList) {
                ProjectFolder.closeChildrendAndRemove(projectFolder, connectionFolder);
            }
            connectionFolder.markDirty(false);
        }
    }

    private static void closeChildrendAndRemove(final ProjectFolder projectFolder, final ConnectionFolder connectionFolder) {
        try {
            if (!EventQueue.isDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        projectFolder.closeChildren();
                        connectionFolder.remove((Element)projectFolder, true);
                    }
                });
            } else {
                projectFolder.closeChildren();
                connectionFolder.remove((Element)projectFolder, true);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }
}

