/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.DeleteObjectsWorker;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.RenameNodePanel;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.RepositoryObject;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.utils.DataMinerConnections;
import oracle.dmt.dataminer.utils.FileHelper;
import oracle.dmt.dataminer.wizard.project.CreateProjectDialog;
import oracle.dmt.dataminer.wizard.workflow.CreateWorkflowDialog;
import oracle.dmt.dataminer.workflow.workflowImport.WorkflowImportPreferenceSettings;
import oracle.dmt.dataminer.workflow.workflowImport.WorkflowPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnections;

final class NavigatorController
implements Controller {
    private static final String NEW_CONNECTION_ID = "dataminer.NewConnection";
    public static final int NEW_CONNECTION_CMD_ID = Ide.findOrCreateCmdID((String)"dataminer.NewConnection");
    private static final String NEW_WORKFLOW_ID = "dataminer.NewWorkflow";
    public static final int NEW_WORKFLOW_CMD_ID = Ide.findOrCreateCmdID((String)"dataminer.NewWorkflow");
    private static final String PROJECT_PROPERTIES_ID = "dataminer.ProjectProperties";
    public static final int PROJECT_PROPERTIES_CMD_ID = Ide.findOrCreateCmdID((String)"dataminer.ProjectProperties");
    private static final String NEW_PROJECT_ID = "dataminer.NewProject";
    public static final int NEW_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"dataminer.NewProject");
    private static final String DELETE_NODE_ID = "dataminer.DeleteNodes";
    public static final int DELETE_NODE_CMD_ID = Ide.findOrCreateCmdID((String)"dataminer.DeleteNodes");
    private static final String DELETE_CONN_ID = "dataminer.DeleteConnection";
    public static final int DELETE_CONN_CMD_ID = Ide.findOrCreateCmdID((String)"dataminer.DeleteConnection");
    private static final String CONN_PROPERTIES_ID = "dataminer.EditConnection";
    public static final int CONN_PROPERTIES_CMD_ID = Ide.findOrCreateCmdID((String)"dataminer.EditConnection");
    private static final String RENAME_NODE_ID = "dataminer.RenameNode";
    public static final int RENAME_NODE_CMD_ID = Ide.findOrCreateCmdID((String)"dataminer.RenameNode");
    private static final String WORKFLOW_EXPORT_ID = "dataminer.WorkflowExport";
    public static final int WORKFLOW_EXPORT_CMD_ID = Ide.findOrCreateCmdID((String)"dataminer.WorkflowExport");
    private static final String WORKFLOW_IMPORT_ID = "dataminer.WorkflowImport";
    public static final int WORKFLOW_IMPORT_CMD_ID = Ide.findOrCreateCmdID((String)"dataminer.WorkflowImport");
    private static final String DISCONNECT_CONN_ID = "dataminer.Disconnect";
    public static final int DISCONNECT_CONN_CMD_ID = Ide.findOrCreateCmdID((String)"dataminer.Disconnect");
    private static final String SHOW_EXPORT_SUCCESS = "show_export_completed_successfully";

    NavigatorController() {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == NEW_CONNECTION_CMD_ID) {
            String string = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), (String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), null, (boolean)true, (boolean)false);
            if (string != null) {
                this.addConnection(string);
            }
            return true;
        }
        if (n == NEW_WORKFLOW_CMD_ID) {
            CreateWorkflowDialog createWorkflowDialog = new CreateWorkflowDialog();
            createWorkflowDialog.invoke(context);
            return true;
        }
        if (n == NEW_PROJECT_CMD_ID) {
            try {
                Node node = context.getNode();
                if (node instanceof ConnectionFolder) {
                    ConnectionFolder connectionFolder = (ConnectionFolder)node;
                    Boolean bl = connectionFolder.isConnectionValidated();
                    if (bl == null || Boolean.FALSE.equals(bl)) {
                        bl = connectionFolder.checkConnection();
                    }
                    if (bl.booleanValue()) {
                        CreateProjectDialog createProjectDialog = new CreateProjectDialog();
                        createProjectDialog.invoke(context);
                    } else {
                        connectionFolder.closeImpl();
                    }
                } else {
                    CreateProjectDialog createProjectDialog = new CreateProjectDialog();
                    createProjectDialog.invoke(context);
                }
                return true;
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
        } else {
            if (n == PROJECT_PROPERTIES_CMD_ID) {
                CreateProjectDialog createProjectDialog = new CreateProjectDialog(true);
                createProjectDialog.invoke(context);
                return true;
            }
            if (n == DELETE_NODE_CMD_ID) {
                Element[] elementArray = context.getSelection();
                if (elementArray.length != 0 && elementArray[0] instanceof ConnectionFolder) {
                    NavigatorController.removeConnections(context);
                } else {
                    NavigatorController.deleteObjects(context);
                }
                return true;
            }
            if (n == DELETE_CONN_CMD_ID) {
                NavigatorController.removeConnections(context);
                return true;
            }
            if (n == CONN_PROPERTIES_CMD_ID) {
                this.editConnectionFolder(context);
                return true;
            }
            if (n == DISCONNECT_CONN_CMD_ID) {
                this.connectionDisconnect(context);
                return true;
            }
            if (n == RENAME_NODE_CMD_ID) {
                Element[] elementArray = context.getSelection();
                boolean bl = false;
                boolean bl2 = false;
                String string = context.getNode().getShortLabel();
                if (elementArray[0] instanceof ProjectFolder) {
                    bl = true;
                } else if (elementArray[0] instanceof WorkflowNode) {
                    bl2 = true;
                }
                RenameNodePanel renameNodePanel = new RenameNodePanel(context, bl, bl2, string);
                renameNodePanel.showAsDialog();
                return true;
            }
            if (n == WORKFLOW_EXPORT_CMD_ID) {
                NavigatorController.exportWorkflow(context);
                return true;
            }
            if (n == WORKFLOW_IMPORT_CMD_ID) {
                NavigatorController.importWorkflow(context);
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        Element[] elementArray = context.getSelection();
        int n = ideAction.getCommandId();
        if (n == NEW_CONNECTION_CMD_ID) {
            if (elementArray != null && elementArray.length == 1) {
                if (elementArray[0] instanceof ConnectionFolder || elementArray[0] instanceof Connections) {
                    ideAction.setEnabled(true);
                    return true;
                }
                ideAction.setEnabled(false);
                return false;
            }
            return true;
        }
        if (n == NEW_WORKFLOW_CMD_ID) {
            if (elementArray != null && elementArray.length == 1) {
                if (elementArray[0] instanceof ProjectFolder || elementArray[0] instanceof WorkflowNode) {
                    ideAction.setEnabled(true);
                    return true;
                }
                ideAction.setEnabled(false);
                return false;
            }
        } else if (n == NEW_PROJECT_CMD_ID) {
            if (elementArray != null && elementArray.length == 1) {
                if (elementArray[0] instanceof ProjectFolder || elementArray[0] instanceof ConnectionFolder) {
                    ideAction.setEnabled(true);
                    return true;
                }
                ideAction.setEnabled(false);
                return false;
            }
        } else if (n == PROJECT_PROPERTIES_CMD_ID) {
            if (elementArray != null && elementArray.length == 1) {
                if (elementArray[0] instanceof ProjectFolder) {
                    ideAction.setEnabled(true);
                    return true;
                }
                ideAction.setEnabled(false);
                return false;
            }
        } else if (n == DELETE_NODE_CMD_ID) {
            if (elementArray != null && elementArray.length >= 1 && (elementArray[0] instanceof WorkflowNode || elementArray[0] instanceof ProjectFolder)) {
                ideAction.setEnabled(true);
                return true;
            }
        } else if (n == RENAME_NODE_CMD_ID) {
            if (elementArray != null && elementArray.length == 1 && (elementArray[0] instanceof WorkflowNode || elementArray[0] instanceof ProjectFolder)) {
                ideAction.setEnabled(true);
                return true;
            }
        } else if (n == DELETE_CONN_CMD_ID) {
            if (elementArray != null && elementArray.length >= 1 && elementArray[0] instanceof ConnectionFolder) {
                ideAction.setEnabled(true);
                return true;
            }
        } else {
            if (n == DISCONNECT_CONN_CMD_ID) {
                if (elementArray != null && elementArray.length == 1 && elementArray[0] instanceof ConnectionFolder) {
                    ideAction.setEnabled(((ConnectionFolder)elementArray[0]).isConnected());
                }
                return true;
            }
            if (n == CONN_PROPERTIES_CMD_ID) {
                if (elementArray != null && elementArray.length == 1 && elementArray[0] instanceof ConnectionFolder) {
                    ideAction.setEnabled(true);
                    return true;
                }
            } else if (n == WORKFLOW_EXPORT_CMD_ID) {
                if (elementArray != null && elementArray.length == 1 && elementArray[0] instanceof WorkflowNode) {
                    ideAction.setEnabled(true);
                    return true;
                }
            } else if (n == WORKFLOW_IMPORT_CMD_ID && elementArray != null && elementArray.length == 1) {
                if (elementArray[0] instanceof ProjectFolder) {
                    ideAction.setEnabled(true);
                    return true;
                }
                ideAction.setEnabled(false);
                return false;
            }
        }
        ideAction.setEnabled(false);
        return false;
    }

    public static void removeConnections(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray != null) {
            for (Element element : elementArray) {
                if (!(element instanceof ConnectionFolder)) continue;
                String string = ((ConnectionFolder)element).getQualifiedConnectionName();
                Connections.getInstance().removeConnection(string);
            }
        }
    }

    private void connectionDisconnect(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray.length == 1 && elementArray[0] instanceof ConnectionFolder) {
            try {
                ConnectionFolder connectionFolder = (ConnectionFolder)elementArray[0];
                Iterator<Element> iterator = connectionFolder.getChildren();
                while (iterator.hasNext()) {
                    Element element = iterator.next();
                    connectionFolder.remove(element);
                }
                connectionFolder.markDirty(false);
                connectionFolder.disconnect();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnection(String string) {
        Object var2_2 = null;
        String string2 = DataMinerConnections.getUnqualifiedName(string);
        try {
            Connections.getInstance().addConnection(string);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
        finally {
            if (var2_2 != null) {
                try {
                    DataMinerConnections.closePrivateConnection(string2);
                }
                catch (ConnectionException connectionException) {}
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void editConnectionFolder(Context context) {
        ConnectionFolder connectionFolder = (ConnectionFolder)context.getElement();
        String string = connectionFolder.getConnectionName();
        String string2 = null;
        try {
            DatabaseConnections databaseConnections = DatabaseConnections.getInstance();
            string2 = DatabaseConnectionEditor.editConnection((String)"IdeConnections", (String)string);
            if (string2 == null) {
                return;
            }
            databaseConnections.saveConnections();
            connectionFolder.closeConnection();
            Iterator<Element> iterator = connectionFolder.getChildren();
            if (!iterator.hasNext()) {
                connectionFolder.close();
            }
            if (string.equals(string2)) return;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importWorkflow(Context context) {
        try {
            Element[] elementArray = context.getSelection();
            if (elementArray != null && elementArray.length == 1) {
                File file;
                ProjectFolder projectFolder = ProjectFolder.getProjectFolder(context);
                if (projectFolder == null) {
                    return;
                }
                Preferences preferences = Preferences.getPreferences();
                WorkflowImportPreferenceSettings workflowImportPreferenceSettings = WorkflowImportPreferenceSettings.getInstance((PropertyStorage)preferences);
                FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("XML file", "xml");
                URLFileChooser uRLFileChooser = new URLFileChooser();
                String string = workflowImportPreferenceSettings.getDataLocation();
                if (string != null && !"".equals(string) && (file = new File(string)).exists()) {
                    uRLFileChooser.setCurrentDirectory(new File(string));
                }
                uRLFileChooser.setFileFilter((FileFilter)fileNameExtensionFilter);
                uRLFileChooser.setSelectionMode(0);
                int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow());
                if (n == 0) {
                    Object object;
                    String string2 = uRLFileChooser.getSelectedFile().getAbsolutePath();
                    if (string2.trim().length() == 0) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("WORKFLOW_IMPORT_EMPTY_FILE"), (String)DataminerNavigatorLrb.get("WORKFLOW_IMPORT_TITLE"), null);
                        return;
                    }
                    File file2 = new File(string2);
                    String string3 = file2.getName();
                    if (string3.length() != 0 && !FileHelper.isFileNameWithSuffix(string3)) {
                        object = string2 + ".xml";
                        file2 = new File((String)object);
                    }
                    if (file2 == null || !file2.exists()) {
                        object = MessageFormat.format(DataminerNavigatorLrb.get("WORKFLOW_IMPORT_FILE_NOT_EXIST"), file2.getAbsolutePath());
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)object, (String)DataminerNavigatorLrb.get("WORKFLOW_IMPORT_TITLE"), null);
                        return;
                    }
                    object = new WorkflowPanel(context, string2);
                    ((DialogDisplayer)object).showAsDialog();
                    File file3 = uRLFileChooser.getCurrentDirectory();
                    if (file3.isFile()) {
                        file3 = file3.getParentFile();
                    }
                    workflowImportPreferenceSettings.setDataLocation(file3.getAbsolutePath());
                }
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
    }

    public static void deleteObjects(Context context) {
        for (Element element : context.getSelection()) {
            if (!(element instanceof BaseTreeNode) || ((BaseTreeNode)element).isDeleteable()) continue;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("DELETE_IMPOSSIBLE"), (String)DataminerNavigatorLrb.get("DELETE_IMPOSSIBLE_TITLE"), null);
            return;
        }
        NavigatorController.deleteOptionalWarning(context);
        if (!NavigatorController.deleteConfirm(context)) {
            return;
        }
        DeleteObjectsWorker deleteObjectsWorker = new DeleteObjectsWorker(context, (Component)Ide.getMainWindow(), DataminerNavigatorLrb.get("DELETING_OBJECTS_TITLE"), NavigatorController.getDeleteProgressMessage(context));
        deleteObjectsWorker.start();
    }

    private static String getDeleteProgressMessage(Context context) {
        Element[] elementArray = context.getSelection();
        String string = DataminerNavigatorLrb.get("DELETING_OBJECTS_DESCRIPTION");
        if (elementArray[0] instanceof ConnectionFolder) {
            string = elementArray.length == 1 ? DataminerNavigatorLrb.get("DELETING_CONNECTION") : DataminerNavigatorLrb.get("DELETING_CONNECTIONS");
        } else if (elementArray[0] instanceof ProjectFolder) {
            string = elementArray.length == 1 ? DataminerNavigatorLrb.get("DELETING_PROJECT") : DataminerNavigatorLrb.get("DELETING_PROJECTS");
        } else if (elementArray[0] instanceof WorkflowNode) {
            string = elementArray.length == 1 ? DataminerNavigatorLrb.get("DELETING_WORKFLOW") : DataminerNavigatorLrb.get("DELETING_WORKFLOWS");
        }
        return string;
    }

    private static boolean deleteConfirm(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray.length == 0) {
            return false;
        }
        boolean bl = false;
        String string = DataminerNavigatorLrb.get("DELETE_NODES_CONFIRMATION_DESCRIPTION");
        if (elementArray[0] instanceof ConnectionFolder) {
            string = elementArray.length == 1 ? DataminerNavigatorLrb.get("DELETE_CONN_CONFIRMATION_DESCRIPTION") : DataminerNavigatorLrb.get("DELETE_CONNS_CONFIRMATION_DESCRIPTION");
        } else if (elementArray[0] instanceof ProjectFolder) {
            string = elementArray.length == 1 ? DataminerNavigatorLrb.get("DELETE_PROJECT_CONFIRMATION_DESCRIPTION") : DataminerNavigatorLrb.get("DELETE_PROJECTS_CONFIRMATION_DESCRIPTION");
        } else if (elementArray[0] instanceof WorkflowNode) {
            string = elementArray.length == 1 ? DataminerNavigatorLrb.get("DELETE_WF_CONFIRMATION_DESCRIPTON") : DataminerNavigatorLrb.get("DELETE_WFS_CONFIRMATION_DESCRIPTON");
        }
        bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)DataminerNavigatorLrb.get("DELETE_NODES_CONFIRMATION_TITLE"), null, (boolean)true);
        return bl;
    }

    private static void deleteOptionalWarning(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray.length != 0 && (elementArray[0] instanceof ProjectFolder || elementArray[0] instanceof WorkflowNode)) {
            MessageDialogPersistence messageDialogPersistence = MessageDialog.getPersistence();
            Boolean bl = messageDialogPersistence.getConfirmed("warnDeleteNavObjects");
            if (Boolean.FALSE.equals(bl)) {
                messageDialogPersistence.setConfirmed("warnDeleteNavObjects", Boolean.valueOf(true));
            }
            MessageDialog.optionalInformation((String)"warnDeleteNavObjects", (Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("DELETE_NODES_OPT_WARNING"), (String)DataminerNavigatorLrb.get("DELETE_NODES_OPT_WARNING_TITLE"), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void exportWorkflow(Context context) {
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        Writer writer = null;
        try {
            String string;
            Object object;
            Element[] elementArray = context.getSelection();
            Element element = elementArray[0];
            if (!(element instanceof WorkflowNode)) return;
            Preferences preferences = Preferences.getPreferences();
            WorkflowImportPreferenceSettings workflowImportPreferenceSettings = WorkflowImportPreferenceSettings.getInstance((PropertyStorage)preferences);
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("XML file", "xml");
            URLFileChooser uRLFileChooser = new URLFileChooser();
            String string2 = workflowImportPreferenceSettings.getDataLocation();
            if (string2 != null && !"".equals(string2)) {
                object = new File(string2);
                if (((File)object).isFile()) {
                    object = ((File)object).getParentFile();
                }
                if (((File)object).exists()) {
                    uRLFileChooser.setCurrentDirectory((File)object);
                    string2 = ((File)object).getAbsolutePath();
                } else {
                    string2 = uRLFileChooser.getCurrentDirectory().getAbsolutePath();
                }
            }
            object = (Workflow)((WorkflowNode)element).getRepositoryData();
            String string3 = ((RepositoryObject)object).getName();
            File file = new File(string2 + File.separator + string3 + ".xml");
            int n = 1;
            while (file.exists()) {
                string3 = ((RepositoryObject)object).getName() + n;
                file = new File(string2 + File.separator + string3 + ".xml");
                ++n;
            }
            uRLFileChooser.setSelectedFile(file);
            uRLFileChooser.setFileFilter((FileFilter)fileNameExtensionFilter);
            int n2 = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow());
            if (n2 != 0) return;
            String string4 = uRLFileChooser.getSelectedFile().getAbsolutePath();
            if (string4.trim().length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("WORKFLOW_EXPORT_EMPTY_FILE"), (String)DataminerNavigatorLrb.get("WORKFLOW_EXPORT_TITLE"), null);
                return;
            }
            File file2 = new File(string4);
            String string5 = file2.getName();
            if (string5.length() != 0 && !FileHelper.isFileNameWithSuffix(string5)) {
                string = string4 + ".xml";
                file2 = new File(string);
            }
            if (file2 != null && file2.exists() && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("WORKFLOW_EXPORT_FILE_OVERWRITE"), (String)DataminerNavigatorLrb.get("WORKFLOW_EXPORT_TITLE"), null, (boolean)true)) {
                return;
            }
            string = ((WorkflowNode)element).export(context);
            if (string == null) return;
            fileOutputStream = new FileOutputStream(file2);
            writer = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            writer.write(string);
            workflowImportPreferenceSettings.setDataLocation(file2.getParentFile().getAbsolutePath());
            MessageDialog.optionalInformation((String)SHOW_EXPORT_SUCCESS, (Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("WORKFLOW_EXPORT_COMPLETE"), (String)DataminerNavigatorLrb.get("WORKFLOW_EXPORT_TITLE"), null);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)fileNotFoundException.getLocalizedMessage(), (String)DataminerNavigatorLrb.get("WORKFLOW_EXPORT_ERROR_TITLE"), null);
            return;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            return;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

