/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dmt.dataminer.navigator.DataminerNavigatorManager;
import oracle.ide.docking.BaseDockableFactory;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.layout.ViewId;
import oracle.ide.view.View;

public class DataminerNavigatorDockableFactory
implements BaseDockableFactory {
    public final View lookupView(ViewId viewId) {
        return viewId != null && viewId.equals((Object)this.getDefaultViewId()) ? this.getDockableImpl() : null;
    }

    public final Dockable getDockable(ViewId viewId) {
        DockableView dockableView;
        DockStation dockStation = DockStation.getDockStation();
        if (dockStation.getDockableStatus((Dockable)(dockableView = this.getDockableImpl())) == 0) {
            DockingParam dockingParam = this.createDockingParam();
            dockStation.dock((Dockable)dockableView, dockingParam);
        }
        return dockableView;
    }

    public final void install() {
        DockableView dockableView = this.getDockableImpl();
        if (dockableView == null) {
            return;
        }
        DockingParam dockingParam = this.createDockingParam();
        DockStation.getDockStation().dock((Dockable)dockableView, dockingParam);
    }

    protected DockingParam createDockingParam() {
        DockingParam dockingParam = new DockingParam();
        DBNavigatorManager dBNavigatorManager = DBNavigatorManager.getInstance();
        if (dBNavigatorManager.getNavigatorWindow() != null) {
            dockingParam.setTabbedWith((Dockable)dBNavigatorManager.getNavigatorWindow());
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable, 2, 0);
        }
        return dockingParam;
    }

    protected DockableView getDockableImpl() {
        return DataminerNavigatorManager.getInstance().getNavigatorWindow();
    }

    protected ViewId getDefaultViewId() {
        return DataminerNavigatorManager.getInstance().getDefaultViewId();
    }
}

