/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.svd.details;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.svd.details.DetailsLrb;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class DetailsTableModel
extends GenericBaseTableModel {
    private static final int COLUMN_COUNT = 2;
    public static final int SETTING_NAME = 0;
    public static final int SETTING_VALUE = 1;
    private ArrayList<NameValuePair> _data;
    private String[] _columnNames = new String[]{DetailsLrb.get("DETAILS_NAME"), DetailsLrb.get("DETAILS_VALUE")};
    private Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _prefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)this._p);
    private NumberFormat _nf_wprecision = NumericFormat.getInstance(true, this._prefenceSettings.getNumericalPrecisionLevel(), 0, 0);
    public static final String NUM_COMPONENTS = "NUM_COMPONENTS";
    public static final String SUGGESTED_CUTOFF = "SUGGESTED_CUTOFF";

    public DetailsTableModel() {
        this.setColumnIdentifiers(this._columnNames);
        this._data = new ArrayList();
        this.setRowCount(0);
        this.setColumnCount(2);
    }

    public DetailsTableModel(NameValuePair[] nameValuePairArray) {
        assert (nameValuePairArray != null) : "Input data is missing.";
        this.setColumnIdentifiers(this._columnNames);
        this._data = new ArrayList();
        for (int i = 0; i < nameValuePairArray.length; ++i) {
            this._data.add(nameValuePairArray[i]);
        }
        this.setRowCount(nameValuePairArray != null ? nameValuePairArray.length : 0);
        this.setColumnCount(2);
    }

    public int getRowCount() {
        return this._data == null ? 0 : this._data.size();
    }

    public void loadData(List<NameValuePair> list) {
        assert (list != null) : "Input data is missing.";
        this.clearRows();
        for (int i = 0; i < list.size(); ++i) {
            this._data.add(list.get(i));
        }
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        NameValuePair nameValuePair = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = DetailsTableModel.translateGLOBAL_DETAIL_NAMES(nameValuePair.getName());
                break;
            }
            case 1: {
                object = nameValuePair.getValue();
                if (!(object instanceof Double)) break;
                object = this._nf_wprecision.format((Double)object);
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing model attributes";
                break;
            }
        }
        if (object == null) {
            return "NULL";
        }
        return object;
    }

    public void addRow(NameValuePair nameValuePair) {
        this._data.add(nameValuePair);
    }

    private void clearRows() {
        if (!this._data.isEmpty()) {
            this._data.clear();
        }
    }

    public void loadStatus(String string) {
        this.clearRows();
        NameValuePair nameValuePair = new NameValuePair(string, "");
        this.addRow(nameValuePair);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public static String translateGLOBAL_DETAIL_NAMES(String string) {
        String string2 = (String)ALL_GLOBAL_DETAILS._DETAIL_NAMES.get(string);
        return string2 != null ? string2 : string;
    }

    public static String translateModelSettingsValue(String string) {
        String string2 = (String)ALL_GLOBAL_DETAILS._DETAIL_VALUES.get(string);
        return string2;
    }

    static class ALL_GLOBAL_DETAILS {
        private static Hashtable<String, String> _DETAIL_VALUES = new Hashtable();
        private static Hashtable<String, String> _DETAIL_NAMES = new Hashtable();

        ALL_GLOBAL_DETAILS() {
        }

        static {
            _DETAIL_NAMES.put(DetailsTableModel.NUM_COMPONENTS, DetailsLrb.get(DetailsTableModel.NUM_COMPONENTS));
            _DETAIL_NAMES.put(DetailsTableModel.SUGGESTED_CUTOFF, DetailsLrb.get(DetailsTableModel.SUGGESTED_CUTOFF));
        }
    }
}

