/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.BaseTreeTable;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.ReadOnlyCostMatrixModel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.partition.SettingsPartitionModelTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerGeneralTreeTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerSignatureTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerState;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerTextAttrsTableModel;
import oracle.dmt.dataminer.mviewer.settings.TextFeaturesPanel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.model.MiningAttributeInfo;
import oracle.dmt.dataminer.server.model.PartitionModelAttributeInfo;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.DelayedLoadInterface;
import oracle.dmt.dataminer.utils.DelayedProcessWorker;
import oracle.dmt.dataminer.utils.SimpleSearchListener;
import oracle.dmt.dataminer.workflow.dialog.model.TargetValuesPanel;
import oracle.ide.Context;
import oracle.ide.controls.JTabbedPane2;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.javatools.util.Version;

public class SettingsViewerTabPanel
extends DataMinerViewGUI
implements ActionListener,
DelayedLoadInterface {
    private SettingsViewerState _state = new SettingsViewerState(this._context);
    private boolean _isDatabaseVersion12_1andUp;
    private boolean isModelPartitioned = false;
    private static final String SETTINGS_VIEWER_ID = "SETTINGS_VIEWER_ID";
    private static String _target = SettingsLrb.get("ATTRIBUTE_TARGET_YES");
    private BlockingComponent overLayPanel = null;
    private boolean _success = false;
    private DelayedProcessWorker worker;
    private Exception _ex = null;
    private boolean reloading = false;
    private TargetValuesPanel jTargetValues;
    private DataMinerTable _genericTableModelSignature;
    private DataMinerTablePanel dataMinerTablePanel1;
    private DataMinerTable genericTableCostMatrix;
    private DataMinerTable genericTableWeights;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JPanel jCostMatrix;
    private JLabel jExpressionLabel;
    public JPanel jExpressionPanel;
    private TextFeaturesPanel jFeatures;
    private JLabel jLabel2;
    private JLabel jLabelCostMatrix;
    private JLabel jLabelWeifgts;
    private JPanel jModelSettings;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPartitionKeys;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneCostMatrix;
    private JScrollPane jScrollPaneSettings;
    private JScrollPane jScrollPaneSignature;
    private JScrollPane jScrollPaneWeights;
    private JScrollPane jScrollPaneXform;
    private JPanel jSignature;
    private ComponentWithTitlebar jSignaturesPanel;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JPanel jWeights;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar1;
    private ControlBar signatureControlBar;
    private SearchField signatureSearchField;
    private int _lastSelectedIindex = -1;
    private SettingsTreeTable _jSettingsTreeTable;

    public SettingsViewerTabPanel(Editor editor, Context context) throws Exception {
        super(editor, context);
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        this._isDatabaseVersion12_1andUp = ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    private void initComponents() {
        this.jScrollPaneXform = new JScrollPane();
        this._genericTableModelSignature = new DataMinerTable();
        this.signatureSearchField = new SearchField();
        this.signatureControlBar = new ControlBar();
        this.signatureControlBar.add((Component)this.signatureSearchField);
        this.modelViewerPartitionToolbar1 = new ModelViewerPartitionToolbar();
        this.jTabbedPane = new JTabbedPane2();
        this.jModelSettings = new JPanel();
        this.jScrollPaneSettings = new JScrollPane();
        this.jSignature = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPaneSignature = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jSignaturesPanel = new ComponentWithTitlebar();
        this.jWeights = new JPanel();
        this.jLabelWeifgts = new JLabel();
        this.jScrollPaneWeights = new JScrollPane();
        this.genericTableWeights = new DataMinerTable();
        this.jCostMatrix = new JPanel();
        this.jScrollPaneCostMatrix = new JScrollPane();
        this.genericTableCostMatrix = new BaseCostMatrixTable();
        this.jLabelCostMatrix = new JLabel();
        this.jPartitionKeys = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jExpressionPanel = new JPanel();
        this.jExpressionLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jCheckBox2 = new JCheckBox();
        this.dataMinerTablePanel1 = new DataMinerTablePanel();
        this.jFeatures = new TextFeaturesPanel();
        this._genericTableModelSignature.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.jScrollPaneXform.setViewportView((Component)((Object)this._genericTableModelSignature));
        this.signatureSearchField.setAutoFind(true);
        this.signatureSearchField.setDoubleBuffered(false);
        this.signatureSearchField.setNotifyOnEmptySearch(true);
        this.signatureSearchField.setPreferredSize(new Dimension(160, 21));
        this.signatureSearchField.setPrompt(SettingsLrb.get("ATTRIBUTE_NAME_SHORT"));
        this.signatureControlBar.setPreferredSize(new Dimension(160, 25));
        GroupLayout groupLayout = new GroupLayout(this.jModelSettings);
        this.jModelSettings.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneSettings, -1, 746, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.jScrollPaneSettings, -1, 511, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane.addTab("Settings", this.jModelSettings);
        this.jSplitPane1.setDividerLocation(500);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPaneSignature.setViewportView(this.jTextArea1);
        this.jLabel2.setText("jLabel2");
        this.jCheckBox1.setText("jCheckBox1");
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jLabel2, -2, 166, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 361, Short.MAX_VALUE).addComponent(this.jCheckBox1, -2, 217, -2)).addComponent(this.jScrollPaneSignature, GroupLayout.Alignment.TRAILING, -1, 744, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneSignature, -1, 44, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setBottomComponent(this.jPanel1);
        this.jSignaturesPanel.setComponent((JComponent)this.jScrollPaneXform);
        this.jSignaturesPanel.setControlBar(this.signatureControlBar);
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jSignaturesPanel, GroupLayout.Alignment.TRAILING, -1, 764, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jSignaturesPanel, -1, 464, Short.MAX_VALUE));
        this.jSplitPane1.setTopComponent(this.jPanel2);
        GroupLayout groupLayout4 = new GroupLayout(this.jSignature);
        this.jSignature.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING, -1, 558, Short.MAX_VALUE));
        this.jTabbedPane.addTab("Signature", this.jSignature);
        this.jLabelWeifgts.setText("jLabel3");
        this.genericTableWeights.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPaneWeights.setViewportView((Component)((Object)this.genericTableWeights));
        GroupLayout groupLayout5 = new GroupLayout(this.jWeights);
        this.jWeights.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneWeights, -1, 746, Short.MAX_VALUE).addComponent(this.jLabelWeifgts, -2, 120, -2)).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.jLabelWeifgts).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneWeights, -1, 516, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane.addTab("Weights", this.jWeights);
        this.genericTableCostMatrix.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.genericTableCostMatrix.setAutoResizeMode(0);
        this.jScrollPaneCostMatrix.setViewportView((Component)((Object)this.genericTableCostMatrix));
        this.jLabelCostMatrix.setText("jLabel3");
        GroupLayout groupLayout6 = new GroupLayout(this.jCostMatrix);
        this.jCostMatrix.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneCostMatrix, -1, 746, Short.MAX_VALUE).addComponent(this.jLabelCostMatrix, -2, 152, -2)).addContainerGap()));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addComponent(this.jLabelCostMatrix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneCostMatrix, -1, 516, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane.addTab("Cost Matrix", this.jCostMatrix);
        this.jSplitPane2.setDividerLocation(200);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.5);
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jExpressionPanel.setName("");
        this.jExpressionLabel.setText("jExpressionLabel");
        this.jExpressionLabel.setVerticalAlignment(3);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setRows(5);
        this.jTextArea2.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.jTextArea2);
        this.jCheckBox2.setLabel("Show Reverse Expression");
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsViewerTabPanel.this.jCheckBox2ActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout7 = new GroupLayout(this.jExpressionPanel);
        this.jExpressionPanel.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addComponent(this.jExpressionLabel, -1, 468, Short.MAX_VALUE).addGap(64, 64, 64).addComponent(this.jCheckBox2).addGap(83, 83, 83)).addComponent(this.jScrollPane1));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jCheckBox2).addComponent(this.jExpressionLabel, -2, 45, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 289, Short.MAX_VALUE)));
        this.jExpressionLabel.getAccessibleContext().setAccessibleName("");
        this.jSplitPane2.setRightComponent(this.jExpressionPanel);
        this.jExpressionPanel.getAccessibleContext().setAccessibleName("jExpressionPanel");
        this.jSplitPane2.setLeftComponent(this.dataMinerTablePanel1);
        GroupLayout groupLayout8 = new GroupLayout(this.jPartitionKeys);
        this.jPartitionKeys.setLayout(groupLayout8);
        groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2));
        groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout8.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane2, -1, 536, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane2.getAccessibleContext().setAccessibleParent(this);
        this.jTabbedPane.addTab("Partition Keys", this.jPartitionKeys);
        this.jTabbedPane.addTab("Features", this.jFeatures);
        GroupLayout groupLayout9 = new GroupLayout(this);
        this.setLayout(groupLayout9);
        groupLayout9.setHorizontalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout9.createSequentialGroup().addComponent(this.jTabbedPane).addContainerGap()).addComponent(this.modelViewerPartitionToolbar1, -1, -1, Short.MAX_VALUE));
        groupLayout9.setVerticalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout9.createSequentialGroup().addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane, -1, 586, Short.MAX_VALUE)));
    }

    private void jCheckBox2ActionPerformed(ActionEvent actionEvent) {
        this.displayExpression();
    }

    @Override
    public void initRes() {
        this.jCheckBox1.setText(SettingsLrb.get("SHOW_REVERSEOEXPR"));
        this.jLabel2.setText(SettingsLrb.get("MODEL_XFORM"));
        this.jLabelCostMatrix.setText(SettingsLrb.get("COST_MATRIX_TABLE_TITLE"));
        this.jLabelWeifgts.setText(SettingsLrb.get("MODEL_WEIGHTS"));
    }

    @Override
    public void initUI() {
        PartitionVO partitionVO = new PartitionVO("", "");
        this.jCheckBox1.addActionListener(this);
        this._jSettingsTreeTable = new SettingsTreeTable(this._state.getGeneralTreeTableModel());
        this._jSettingsTreeTable.setRootInvisible();
        this._jSettingsTreeTable.hideHandles();
        this._jSettingsTreeTable.setShowGrid(true);
        this._jSettingsTreeTable.setAutoResizeMode(3);
        this.jScrollPaneSettings.setVerticalScrollBarPolicy(20);
        this.jScrollPaneSettings.setHorizontalScrollBarPolicy(30);
        this.jScrollPaneSettings.setViewportView((Component)((Object)this._jSettingsTreeTable));
        ModelNode modelNode = (ModelNode)this.getContext().getNode();
        String string = modelNode.getOdmModel().getUserName();
        String string2 = modelNode.getOdmModel().getModelName();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        this.isModelPartitioned = DatabaseMetadataUtils.isModelPartitioned(connectionFolder, string, string2, partitionVO);
        this.setLoading(true);
        this.initializeControls();
        Dimension dimension = new Dimension(0, 0);
        this.jPanel1.setMinimumSize(dimension);
        this.jSplitPane1.setResizeWeight(0.75);
        if (this.isModelPartitioned) {
            if (this.reloading) {
                partitionVO = this.modelViewerPartitionToolbar1.getPartitionVO();
                this.modelViewerPartitionToolbar1.setEditor(this.getEditor(), partitionVO);
            } else {
                this.modelViewerPartitionToolbar1.setEditor(this.getEditor());
            }
        } else {
            this.modelViewerPartitionToolbar1.setVisible(false);
        }
        this.worker = new DelayedProcessWorker(this);
        this.worker.execute();
    }

    public void reload() {
        this.reloading = true;
        this.initUI();
        this.reloading = false;
    }

    public String getID() {
        return SETTINGS_VIEWER_ID;
    }

    @Override
    public void loadDataProcess() {
        try {
            this._ex = null;
            this.getContext().getNode().ensureOpen();
            if (this.isModelPartitioned) {
                this._state.load(this.modelViewerPartitionToolbar1.getPartitionVO());
            } else {
                this._state.load(new PartitionVO("", ""));
            }
            this._success = true;
        }
        catch (Exception exception) {
            this._ex = exception;
            this._success = false;
        }
    }

    @Override
    public void reloadDataProcess() {
        try {
            this._ex = null;
            if (this.isModelPartitioned) {
                this._state.reloadAttributes(this.modelViewerPartitionToolbar1.getSelectedPartitionID());
            } else {
                this._state.reloadAttributes("");
            }
            this._success = true;
        }
        catch (Exception exception) {
            this._ex = exception;
            this._success = false;
        }
    }

    @Override
    public void loadGUIProcess() {
        try {
            if (this._success && this._ex == null) {
                if ("".equals(this._state.getModelViewerState().getOdmModel().getModelGeneralDescription().getMiningFunction())) {
                    throw new Exception("ORA-40203");
                }
                this.setupTreeTable();
                this.setupSignatureTable(this._state.getSignatureTableModel());
                this.setupTextAttrsTable(this._state.getTextAttrsTableModel());
                if (this.isModelPartitioned) {
                    this.setupPartitionKeyTable(this._state.getPartitionAttrsTableModel());
                }
                this.setupCostMatrixTable();
                this.setupWeights();
                this.setupTargetValues();
                this.setLoaded(true);
            } else {
                MiningAttributeInfo miningAttributeInfo;
                this.setupDummyTreeTable(SettingsLrb.get("SETTINGS_LOADING_ERROR"));
                this.setupDummyCostMatrix(SettingsLrb.get("COST_MATRIX_FAILURE"));
                this.setupDummyWeights(SettingsLrb.get("WEIGHTS_FAILURE"));
                if (this.isModelPartitioned) {
                    this.setupDummyPartitionKeyTable(SettingsLrb.get("ATTRIBUTE_FAILURE"));
                }
                if (this._state.getSignatureTableModel() != null) {
                    this._state.getSignatureTableModel().clearRows();
                    miningAttributeInfo = new MiningAttributeInfo();
                    miningAttributeInfo.setAttributeName(SettingsLrb.get("ATTRIBUTE_FAILURE"));
                    this._state.getSignatureTableModel().addRow(miningAttributeInfo);
                    this.setupSignatureTable(this._state.getSignatureTableModel());
                }
                if (this._isDatabaseVersion12_1andUp && this._state.getTextAttrsTableModel() != null) {
                    this._state.getTextAttrsTableModel().clearRows();
                    miningAttributeInfo = new MiningAttributeInfo();
                    miningAttributeInfo.setAttributeName(SettingsLrb.get("ATTRIBUTE_FAILURE"));
                    this._state.getTextAttrsTableModel().addRow(miningAttributeInfo);
                    this.setupTextAttrsTable(this._state.getTextAttrsTableModel());
                }
            }
        }
        catch (Exception exception) {
            this._ex = exception;
        }
        finally {
            if (this._ex != null) {
                DataMinerEditor.handleEditorException(this.getEditor().getContext(), this._ex, SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"), SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_MESG"));
            }
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            }
            this.setLoading(false);
        }
    }

    private void initializeControls() {
        this.setupDummyTreeTable(SettingsLrb.get("SETTINGS_LOADING"));
        int n = this.jTabbedPane.indexOfComponent(this.jModelSettings);
        this.jTabbedPane.setTitleAt(n, SettingsLrb.get("MODEL_SETTINGS"));
        this.signatureSearchField.addSearchListener((SearchListener)new SimpleSearchListener((GenericTable)this._genericTableModelSignature, 0));
        this.hideCostMatrixTab();
        this.hideWeightsTab();
        this.hideSignatureTab();
        this.hideFeaturesTab();
        this.hidePartitionKeysTab();
        this.hideTargetValuesTab();
    }

    private void setupWeights() {
        GenericBaseTableModel genericBaseTableModel = this._state.getWeightsModel();
        if (genericBaseTableModel == null) {
            return;
        }
        this.setupWeightTable(this._state.getWeightsModel());
    }

    private void hideWeightsTab() {
        this.jTabbedPane.remove(this.jWeights);
    }

    private void hideSignatureTab() {
        this.jTabbedPane.remove(this.jSignature);
    }

    private void hidePartitionKeysTab() {
        this.jTabbedPane.remove(this.jPartitionKeys);
    }

    private void hideTargetValuesTab() {
        this.jTabbedPane.remove(this.jTargetValues);
    }

    private void hideFeaturesTab() {
        this.jTabbedPane.remove(this.jFeatures);
    }

    private void setupDummyWeights(String string) {
        this.setupWeightTable(this._state.createDummyWeightModel(string));
    }

    private void setupDummyPartitionKeyTable(String string) {
        PartitionModelAttributeInfo partitionModelAttributeInfo = new PartitionModelAttributeInfo();
        partitionModelAttributeInfo.setPartitionKeyName(string);
        if (this._state.getPartitionAttrsTableModel() != null) {
            this._state.getPartitionAttrsTableModel().clearRows();
            this._state.getPartitionAttrsTableModel().addRow(partitionModelAttributeInfo);
            this.setupPartitionKeyTable(this._state.getPartitionAttrsTableModel());
        }
    }

    private void setupTargetValues() {
        if (this._state.getTargetValues() == null) {
            return;
        }
        MiningAttributeInfo miningAttributeInfo = this._state.getSignatureTableModel().getTargetAttributeInfo();
        String string = "";
        String string2 = "";
        if (miningAttributeInfo != null) {
            string = miningAttributeInfo.getAttributeName();
            string2 = miningAttributeInfo.getDataType();
        }
        this.jTargetValues = new TargetValuesPanel(string, string2, this._state.getTargetValues());
        this.jTabbedPane.addTab(SettingsLrb.get("MODEL_TARGET_VALUES"), this.jTargetValues);
    }

    private void setupWeightTable(GenericBaseTableModel genericBaseTableModel) {
        this.genericTableWeights.setModel((TableModel)genericBaseTableModel);
        this.genericTableWeights.setSorted(false);
        this.genericTableWeights.getTableHeader().setReorderingAllowed(false);
        this.jTabbedPane.addTab(SettingsLrb.get("MODEL_WEIGHTS"), this.jWeights);
    }

    private void setupDummyTreeTable(String string) {
        this._state.loadTempStatusTreeTable(string);
    }

    private void setupTreeTable() {
        this._state.loadTree();
        SettingsViewerGeneralTreeTableModel settingsViewerGeneralTreeTableModel = (SettingsViewerGeneralTreeTableModel)((Object)this._jSettingsTreeTable.getTree().getModel());
        int n = this._state.getMaxStringLength();
        Dimension dimension = this._jSettingsTreeTable.getPreferredSize();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            Font font = this._jSettingsTreeTable.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n2 = fontMetrics.stringWidth("W") * n;
            int n3 = (fontMetrics.getHeight() + 3) * settingsViewerGeneralTreeTableModel.getNodeCount();
            dimension.width = n2;
            dimension.height = n3;
            this._jSettingsTreeTable.setPreferredSize(dimension);
        }
        this._jSettingsTreeTable.expandAll(true);
    }

    private void setupDummyCostMatrix(String string) {
        ReadOnlyCostMatrixModel readOnlyCostMatrixModel = this._state.createDummyCostMatrix(string);
        ((BaseCostMatrixTable)this.genericTableCostMatrix).setModel(readOnlyCostMatrixModel);
    }

    private void hideCostMatrixTab() {
        this.jTabbedPane.remove(this.jCostMatrix);
    }

    private void setupCostMatrixTable() {
        ReadOnlyCostMatrixModel readOnlyCostMatrixModel = this._state.getCostMatrix();
        if (readOnlyCostMatrixModel == null) {
            return;
        }
        ((BaseCostMatrixTable)this.genericTableCostMatrix).setModel(this._state.getCostMatrix());
        this.jTabbedPane.addTab(SettingsLrb.get("MODEL_COST_MATRIX"), this.jCostMatrix);
    }

    private void displayExpression() {
        SettingsPartitionModelTableModel settingsPartitionModelTableModel = this._state.getPartitionAttrsTableModel();
        int[] nArray = this.dataMinerTablePanel1.getTable().getSelectedRowsInModel();
        if (nArray != null && nArray.length > 0) {
            int n = nArray[0];
            PartitionModelAttributeInfo partitionModelAttributeInfo = settingsPartitionModelTableModel.getDataVector().get(n);
            this.jExpressionLabel.setText(SettingsLrb.get("PARTITION_EXPRESSION_DETAILS"));
            StringBuffer stringBuffer = new StringBuffer();
            if (!"".equals(partitionModelAttributeInfo.getExpression().toString().trim())) {
                stringBuffer.append(SettingsLrb.get("MODEL_XFORM_TITLE"));
                stringBuffer.append("\n\t");
                stringBuffer.append(partitionModelAttributeInfo.getExpression().toString());
            }
            if (this.jCheckBox2.isSelected() && partitionModelAttributeInfo.getRevExpression() != null && !"".equals(partitionModelAttributeInfo.getRevExpression().toString().trim())) {
                stringBuffer.append("\n");
                stringBuffer.append(SettingsLrb.get("MODEL_REV_XFORM_TITLE"));
                stringBuffer.append("\n\t");
                stringBuffer.append(partitionModelAttributeInfo.getRevExpression());
            }
            this.jTextArea2.setText(stringBuffer.toString());
        }
    }

    private void setupPartitionKeyTable(SettingsPartitionModelTableModel settingsPartitionModelTableModel) {
        if (settingsPartitionModelTableModel == null) {
            return;
        }
        this.dataMinerTablePanel1.setup((TableModel)((Object)settingsPartitionModelTableModel), "", 0);
        this.dataMinerTablePanel1.getTable().setSelectionMode(0);
        this.dataMinerTablePanel1.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SettingsViewerTabPanel.this.displayExpression();
            }
        });
        if (settingsPartitionModelTableModel.getRowCount() > 0) {
            this.dataMinerTablePanel1.getTable().setSelectedRowInModel(0);
        }
        this.jTabbedPane.add(SettingsLrb.get("PARTITION_KEYS_DIALOG_TITLE"), this.jPartitionKeys);
    }

    private void setupSignatureTable(SettingsViewerSignatureTableModel settingsViewerSignatureTableModel) {
        if (settingsViewerSignatureTableModel == null) {
            return;
        }
        this._genericTableModelSignature.setModel((TableModel)((Object)settingsViewerSignatureTableModel));
        this._genericTableModelSignature.setShowGrid(true);
        this._genericTableModelSignature.setSorted(true);
        this._genericTableModelSignature.setUpdateSelectionOnSort(true);
        this._genericTableModelSignature.getTableHeader().setReorderingAllowed(false);
        this._genericTableModelSignature.setSelectionMode(2);
        TableColumn tableColumn = this._genericTableModelSignature.getColumnModel().getColumn(3);
        ModelNode modelNode = (ModelNode)this._context.getNode();
        if (modelNode instanceof DTModelNode || modelNode instanceof GLMCModelNode || modelNode instanceof GLMRModelNode || modelNode instanceof SVMCModelNode || modelNode instanceof SVMRModelNode || modelNode instanceof NBModelNode) {
            IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

                @Override
                public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (object.toString().equals(_target)) {
                        return OracleIcons.getIcon((String)"check.png");
                    }
                    return null;
                }
            }, false);
            tableColumn.setCellRenderer(iconCellRenderer);
        } else {
            this._genericTableModelSignature.removeColumn(tableColumn);
        }
        this._genericTableModelSignature.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = SettingsViewerTabPanel.this._genericTableModelSignature.getSelectedRowsInModel();
                if (0 == nArray.length) {
                    SettingsViewerTabPanel.this._lastSelectedIindex = -1;
                    SettingsViewerTabPanel.this._state.setLastSelectedAttribute(SettingsViewerTabPanel.this._lastSelectedIindex);
                    SettingsViewerTabPanel.this.setXfrom();
                    return;
                }
                if (nArray.length > 1) {
                    SettingsViewerTabPanel.this.jTextArea1.setText(SettingsLrb.get("MULTIPLE_ATTRIBUTE_SELECTION"));
                    return;
                }
                int n = nArray[0];
                if (n >= 0 && SettingsViewerTabPanel.this._lastSelectedIindex != n) {
                    SettingsViewerTabPanel.this._lastSelectedIindex = n;
                    SettingsViewerTabPanel.this._state.setLastSelectedAttribute(SettingsViewerTabPanel.this._lastSelectedIindex);
                    SettingsViewerTabPanel.this.setXfrom();
                }
            }
        });
        this._genericTableModelSignature.setSortColumn(0, true);
        this._genericTableModelSignature.setFillsViewportHeight(true);
        this.jTabbedPane.addTab(SettingsLrb.get("MODEL_SIGNATURE_ATTRIBUTES"), this.jSignature);
    }

    private void setupTextAttrsTable(SettingsViewerTextAttrsTableModel settingsViewerTextAttrsTableModel) {
        if (settingsViewerTextAttrsTableModel == null || settingsViewerTextAttrsTableModel.getRowCount() == 0) {
            return;
        }
        this.jFeatures = new TextFeaturesPanel();
        this.jFeatures.setupTextAttrsTable(this._state);
        this.jTabbedPane.addTab(SettingsLrb.get("MODEL_TEXT_ATTRIBUTES"), this.jFeatures);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.jCheckBox1)) {
            this.setXfrom();
        }
    }

    private void setXfrom() {
        this.jTextArea1.setText("");
        MiningAttributeInfo miningAttributeInfo = this._state.getLastSelectedAttribute();
        if (miningAttributeInfo == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = miningAttributeInfo.getExpression();
        if (stringBuffer2 != null && 0 != stringBuffer2.length()) {
            StringBuffer stringBuffer3;
            stringBuffer.append(SettingsLrb.get("MODEL_XFORM_TITLE"));
            stringBuffer.append("\n\t");
            stringBuffer.append(stringBuffer2);
            if (this.jCheckBox1.isSelected() && (stringBuffer3 = miningAttributeInfo.getRevExpression()) != null && 0 != stringBuffer3.length()) {
                stringBuffer.append("\n");
                stringBuffer.append(SettingsLrb.get("MODEL_REV_XFORM_TITLE"));
                stringBuffer.append("\n\t");
                stringBuffer.append(stringBuffer3);
            }
        }
        this.jTextArea1.setText(stringBuffer.toString());
    }

    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    private static class CustomCellRenderer
    extends DefaultTreeCellRenderer {
        private SettingsTreeTable _parent;

        CustomCellRenderer(SettingsTreeTable settingsTreeTable) {
            this._parent = settingsTreeTable;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            SettingsViewerGeneralTreeTableModel.ModelSettingsNode modelSettingsNode = (SettingsViewerGeneralTreeTableModel.ModelSettingsNode)object;
            this.setText(modelSettingsNode.getLabel());
            this.setIcon(null);
            if (modelSettingsNode.isFolderNode()) {
                if (this._parent._leaffont == null) {
                    this._parent._leaffont = component.getFont();
                    this._parent._folderfont = component.getFont().deriveFont(1);
                }
                this.setFont(this._parent._folderfont);
            } else if (modelSettingsNode.isLeafNode()) {
                this.setFont(this._parent._leaffont);
            }
            return component;
        }
    }

    private static class CustomBasicUI
    extends BasicTreeUI {
        private CustomBasicUI() {
        }

        @Override
        protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        }

        @Override
        protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        }
    }

    private class SettingsTreeTable
    extends BaseTreeTable {
        private Font _leaffont;
        private Font _folderfont;

        SettingsTreeTable(SettingsViewerGeneralTreeTableModel settingsViewerGeneralTreeTableModel) {
            super((TreeTableModel)settingsViewerGeneralTreeTableModel);
            this.setIconRenderer();
        }

        private void setIconRenderer() {
            this.getTree().setCellRenderer(new CustomCellRenderer(this));
        }

        public void hideHandles() {
            SettingsViewerTabPanel.this._jSettingsTreeTable.getTree().setUI(new CustomBasicUI());
        }

        public boolean getScrollableTracksViewportWidth() {
            if (this.autoResizeMode != 0 && this.getParent() instanceof JViewport) {
                boolean bl = this.getParent().getWidth() > this.getPreferredSize().width;
                return bl;
            }
            return false;
        }
    }
}

