/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.util.ArrayList;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.server.model.MiningAttributeInfo;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.util.Version;

public class SettingsViewerSignatureTableModel
extends GenericBaseTableModel {
    private Vector<MiningAttributeInfo> _data = new Vector();
    private static int COLUMN_COUNT;
    public static final int ATTRIBUTE_NAME = 0;
    public static final int DATA_TYPE = 1;
    public static final int MINING_TYPE = 2;
    public static final int IS_TARGET = 3;
    public static final int DATA_PREP = 4;
    public static final int PARTITION_KEY = 5;
    private ArrayList<String> columnNames = new ArrayList();

    private void initColumnNames(Version version, String string) {
        this.columnNames.add(SettingsLrb.get("ATTRIBUTE_NAME_SHORT"));
        this.columnNames.add(SettingsLrb.get("DATA_TYPE"));
        this.columnNames.add(SettingsLrb.get("MINING_TYPE"));
        this.columnNames.add(SettingsLrb.get("TARGET"));
        this.columnNames.add(SettingsLrb.get("DATA_PREP"));
        if (ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_4, version, true) && string != null && !string.equals("")) {
            this.columnNames.add("PARTITION_KEY");
        }
        COLUMN_COUNT = this.columnNames.size();
        this.setColumnIdentifiers(this.columnNames.toArray());
        this.setColumnCount(COLUMN_COUNT);
    }

    public SettingsViewerSignatureTableModel(Version version, String string) {
        this.initColumnNames(version, string);
        this.setRowCount(0);
    }

    public SettingsViewerSignatureTableModel(Vector<MiningAttributeInfo> vector, Version version, String string) {
        this.initColumnNames(version, string);
        this._data = vector;
        this.setRowCount(vector.size());
    }

    public int getRowCount() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public String getTargetAttributeName() {
        String string = null;
        for (MiningAttributeInfo miningAttributeInfo : this._data) {
            if (miningAttributeInfo.getTarget().compareTo("YES") != 0) continue;
            string = miningAttributeInfo.getAttributeName();
            break;
        }
        return string;
    }

    public MiningAttributeInfo getTargetAttributeInfo() {
        MiningAttributeInfo miningAttributeInfo = null;
        for (MiningAttributeInfo miningAttributeInfo2 : this._data) {
            if (!"YES".equals(miningAttributeInfo2.getTarget())) continue;
            miningAttributeInfo = miningAttributeInfo2;
            break;
        }
        return miningAttributeInfo;
    }

    public Vector<MiningAttributeInfo> getTextAttributesInfo() {
        Vector<MiningAttributeInfo> vector = new Vector<MiningAttributeInfo>();
        for (MiningAttributeInfo miningAttributeInfo : this._data) {
            if (!"TEXT".equals(miningAttributeInfo.getAttributeType())) continue;
            vector.add(miningAttributeInfo);
        }
        return vector;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        MiningAttributeInfo miningAttributeInfo = this._data.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = miningAttributeInfo.getAttributeName();
                break;
            }
            case 1: {
                string = miningAttributeInfo.getDataType();
                break;
            }
            case 2: {
                string = ServerConstants.MiningType.toHuman(miningAttributeInfo.getAttributeType());
                break;
            }
            case 3: {
                if (miningAttributeInfo.getTarget().compareTo("YES") == 0) {
                    string = SettingsLrb.get("ATTRIBUTE_TARGET_YES");
                    break;
                }
                string = SettingsLrb.get("ATTRIBUTE_TARGET_NO");
                break;
            }
            case 4: {
                StringBuffer stringBuffer = miningAttributeInfo.getExpression();
                if (miningAttributeInfo.getDataType().equals("DM_NESTED_NUMERICALS") || miningAttributeInfo.getDataType().equals("DM_NESTED_CATEGORICALS") || miningAttributeInfo.getDataType().equals("DM_NESTED_BINARY_DOUBLES") || miningAttributeInfo.getDataType().equals("DM_NESTED_BINARY_FLOATS") || miningAttributeInfo.getDataType().equals("NESTED TABLE")) {
                    if (stringBuffer.toString().equals(miningAttributeInfo.getRevExpression().toString()) && -1 != stringBuffer.toString().indexOf("value")) {
                        string = SettingsLrb.get("ATTRIBUTE_TARGET_NO");
                        break;
                    }
                    string = SettingsLrb.get("ATTRIBUTE_TARGET_YES");
                    break;
                }
                if (miningAttributeInfo.isDataPrep()) {
                    string = SettingsLrb.get("ATTRIBUTE_TARGET_YES");
                    break;
                }
                string = "";
                break;
            }
            case 5: {
                if (miningAttributeInfo.getPartitionKey().toUpperCase().equals("YES")) {
                    string = SettingsLrb.get("ATTRIBUTE_PARTITION_KEY_YES");
                    break;
                }
                string = SettingsLrb.get("ATTRIBUTE_PARTITION_KEY_NO");
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing model attributes";
                break;
            }
        }
        if (string == null) {
            return "NULL";
        }
        return string;
    }

    public void addRow(MiningAttributeInfo miningAttributeInfo) {
        this._data.add(miningAttributeInfo);
    }

    public Vector<MiningAttributeInfo> getDataVector() {
        return this._data;
    }
}

