/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.pca;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.pca.PCACoefficientRowData;
import oracle.dmt.dataminer.mviewer.pca.PCAValuesTableModel;
import oracle.dmt.dataminer.mviewer.pca.ScreePlotLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.server.model.GlobalDetails;
import oracle.dmt.dataminer.server.model.SingularValueDecomposition;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;

public class ScreePlotViewerState
extends BaseViewerState {
    private boolean _loaded;
    private String _modelName;
    private String _userName;
    private GraphDataModel graphDataModel;
    private PCAValuesTableModel _model = new PCAValuesTableModel();
    private List<String> features = new ArrayList<String>();
    private List<Double> variances = new ArrayList<Double>();
    private List<Double> pctCumVariances = new ArrayList<Double>();
    private List<NameValuePair> _settings = null;
    static final Color[] colors = new Color[]{Color.RED, Color.BLUE};

    public ScreePlotViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "pca_viewer_scree";
        return new HelpInfo(string);
    }

    public int getNumberOfFeatures() {
        return this.features.size();
    }

    public String getSuggetsedCutofValue() {
        Object object = null;
        for (NameValuePair nameValuePair : this._settings) {
            if (!"SUGGESTED_CUTOFF".equals(nameValuePair.getName())) continue;
            object = nameValuePair.getValue();
            break;
        }
        return object != null ? object.toString() : "";
    }

    public void load(String string) throws Exception {
        this._modelViewerState1 = new ModelViewerState1(this._context);
        this._modelViewerState1.load();
        this._modelName = this._modelViewerState1.getModelName();
        this._userName = this._modelViewerState1.getUserName();
        this._loaded = false;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        this._settings = GlobalDetails.getModelDetailsGlobal(connectionFolder, this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName(), string);
        this.loadScreePlotData();
        this._loaded = true;
    }

    public void loadScreePlotData() throws Exception {
        boolean bl;
        this.features.clear();
        this.variances.clear();
        this.pctCumVariances.clear();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        SingularValueDecomposition.loadScreePlotValues(connectionFolder, this._userName, this._modelName, this.features, this.variances, this.pctCumVariances);
        if (this.pctCumVariances.isEmpty() || this.variances.isEmpty() || this.features.isEmpty()) {
            throw new Exception(ScreePlotLrb.get("SCREE_PLOT_DATA_IS_NOTAVAILABLE"));
        }
        boolean bl2 = bl = this.features.size() == this.variances.size() && this.features.size() == this.pctCumVariances.size();
        if (!bl) {
            throw new Exception(ScreePlotLrb.get("SCREE_PLOT_DATA_IS_NOTAVAILABLE"));
        }
        int n = this.features.size();
        int n2 = 2;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[]{ScreePlotLrb.get("SCREE_PLOT_VARIANCE"), ScreePlotLrb.get("SCREE_PLOT_PCT_CUM_VARIANCE")};
        Vector<PCACoefficientRowData> vector = new Vector<PCACoefficientRowData>();
        for (int i = 0; i < this.features.size(); ++i) {
            objectArray2[i] = this.features.get(i);
            objectArray[i][0] = this.variances.get(i);
            objectArray[i][1] = this.pctCumVariances.get(i);
            PCACoefficientRowData pCACoefficientRowData = new PCACoefficientRowData(this.features.get(i), this.variances.get(i) * this.variances.get(i), this.variances.get(i), this.pctCumVariances.get(i));
            vector.add(pCACoefficientRowData);
        }
        this._model = new PCAValuesTableModel(vector);
        this.graphDataModel = new DefaultGraphDataModel(null, 43, null, null, null);
        this.graphDataModel.addColumnLabels(objectArray2);
        this.graphDataModel.addRowLabels(objectArray3);
        this.graphDataModel.addGraphData(objectArray);
        this.graphDataModel.addRowColors(colors);
        this.graphDataModel.setLegendVisible(true);
        this.graphDataModel.setTitle(this._modelName);
    }

    public GraphDataModel getGraphDataModel() {
        return this.graphDataModel;
    }

    public PCAValuesTableModel getModel() {
        return this._model;
    }

    public void clearRows() {
        this._model.clearRows();
    }

    public boolean isFeatureLabelUniquie(String string) {
        return SingularValueDecomposition.isFeatureLabelUniquie(string);
    }

    public String renameFeatureLabel(String string, String string2) throws Exception {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        String string3 = SingularValueDecomposition.renameFeatureLabel(connectionFolder, this._userName, this._modelName, string, string2);
        return string3;
    }

    public String getModelName() {
        return this._modelName;
    }

    public String getUserName() {
        return this._userName;
    }

    public void updateFeature(String string, String string2) {
        int n = this.features.indexOf(string);
        if (-1 != n) {
            this.features.set(n, string2);
            Object[] objectArray = this.graphDataModel.getColumnLabels();
            Object[] objectArray2 = this.graphDataModel.getRowLabels();
            Object[][] objectArray3 = this.graphDataModel.getGraphData();
            objectArray[n] = string2;
            this.graphDataModel.clear();
            this.graphDataModel.addColumnLabels(objectArray);
            this.graphDataModel.addRowLabels(objectArray2);
            this.graphDataModel.addGraphData(objectArray3);
            this.graphDataModel.addRowColors(colors);
            this.graphDataModel.setLegendVisible(true);
            this.graphDataModel.setTitle(this._modelName);
        }
    }
}

