/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.partition;

import java.util.ArrayList;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.server.model.PartitionModelAttributeInfo;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.util.Version;

public class SettingsPartitionModelTableModel
extends GenericBaseTableModel {
    private Vector<PartitionModelAttributeInfo> _data = new Vector();
    private static int COLUMN_COUNT;
    public static final int PARTITION_KEY_NAME = 0;
    public static final int DATA_TYPE = 1;
    public static final int PARTITION_KEY_SOURCE = 2;
    public static final int PARTITION_KEY_VALUE = 3;
    private ArrayList<String> columnNames = new ArrayList();

    private void initColumnNames() {
        this.columnNames.add(SettingsLrb.get("PARTITION_KEY_NAME"));
        this.columnNames.add(SettingsLrb.get("DATA_TYPE"));
        this.columnNames.add(SettingsLrb.get("PARTITION_KEY_SOURCE"));
        this.columnNames.add(SettingsLrb.get("PARTITION_KEY_VALUE"));
        COLUMN_COUNT = this.columnNames.size();
        this.setColumnIdentifiers(this.columnNames.toArray());
        this.setColumnCount(COLUMN_COUNT);
    }

    public SettingsPartitionModelTableModel(Version version) {
        this.initColumnNames();
        this.setRowCount(0);
    }

    public SettingsPartitionModelTableModel(Vector<PartitionModelAttributeInfo> vector, Version version) {
        this.initColumnNames();
        this._data = vector;
        this.setRowCount(vector.size());
    }

    public int getRowCount() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public StringBuffer getExpression(int n) {
        return this._data.get(n).getExpression();
    }

    public String getRevExpression(int n) {
        return this._data.get(n).getRevExpression();
    }

    public void addRow(PartitionModelAttributeInfo partitionModelAttributeInfo) {
        this._data.add(partitionModelAttributeInfo);
    }

    public Vector<PartitionModelAttributeInfo> getDataVector() {
        return this._data;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        PartitionModelAttributeInfo partitionModelAttributeInfo = this._data.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = partitionModelAttributeInfo.getPartitionKeyName();
                break;
            }
            case 1: {
                string = partitionModelAttributeInfo.getDataType();
                break;
            }
            case 2: {
                if (partitionModelAttributeInfo.getExpression().toString().trim().equals("")) {
                    string = SettingsLrb.get("PARTITION_SOURCE_COLUMN");
                    break;
                }
                string = SettingsLrb.get("PARTITION_EXPRESSION");
                break;
            }
            case 3: {
                string = partitionModelAttributeInfo.getPartitionKeyValue();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing model attributes";
                break;
            }
        }
        if (string == null) {
            return "NULL";
        }
        return string;
    }
}

