/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.glmdetails;

import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.mviewer.ModelMessagePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.glmdetails.GLMDetailsLrb;
import oracle.dmt.dataminer.mviewer.glmdetails.GLMDetailsTableModel;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.server.model.GLMModelDetailsRowData;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.ui.BlockingComponent;

public class DetailsPanel
extends DataMinerViewGUI {
    private static final Logger theLogger = Logger.getLogger(DetailsPanel.class.getName());
    private GLMDetailsTableModel _table;
    private ModelViewerState1 _state;
    private BlockingComponent overLayPanel = null;
    private DataMinerTablePanel detailsTablePanel;

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public DetailsPanel(Editor editor, Context context) throws Exception {
        super(editor, context);
        ModelNode modelNode = (ModelNode)context.getNode();
        if (modelNode == null) {
            theLogger.log(Level.FINEST, "null node");
        }
        if (!modelNode.isModelExists().booleanValue()) {
            this.add(new ModelMessagePanel(ModelViewerLrb.get("MODEL_DOES_NOT_EXIST")));
            return;
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.detailsTablePanel = new DataMinerTablePanel();
        this.detailsTablePanel.setModelExample(new DefaultTableModel(new Object[][]{{"Marital Status", "Single"}, {"Marital Status", "Married"}, {"Year of birth", "1965-1973"}, {"Year of birth", "1974-1985"}}, new String[]{"Name", "Value"}));
        this.detailsTablePanel.setTitle("Details");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 494, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.detailsTablePanel, -1, 474, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.detailsTablePanel, -1, 289, Short.MAX_VALUE).addContainerGap())));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this._table = new GLMDetailsTableModel(this._context);
        this.setLoadingIndicator();
        this.detailsTablePanel.setup((TableModel)((Object)this._table), GLMDetailsLrb.get("EDITOR_PANEL_NAME"), 0);
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public void reload() {
        this.initUI();
    }

    private void setLoadingIndicator() {
        this._table.clearRows();
        GLMModelDetailsRowData gLMModelDetailsRowData = new GLMModelDetailsRowData(GLMDetailsLrb.get("DETAILS_LOADING"));
        this._table.addRow(gLMModelDetailsRowData);
    }

    public boolean isClassification() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof GLMCModelNode;
    }

    public boolean isRegression() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof GLMRModelNode;
    }

    public HelpInfo getHelpInfo() {
        String string = "Help Topic Not Specified";
        if (this.isClassification()) {
            string = "glmc_global_details_help";
        } else if (this.isRegression()) {
            string = "glmr_global_details_help";
        }
        return new HelpInfo(string);
    }

    private class LoadUI
    extends SwingWorker<Boolean, Void> {
        private LoadUI() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            DetailsPanel.this._state = new ModelViewerState1(DetailsPanel.this._context);
            DetailsPanel.this._state.load();
            DetailsPanel.this._table.load(DetailsPanel.this._state);
            return Boolean.TRUE;
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (((Boolean)this.get()).booleanValue()) {
                    // empty if block
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                DetailsPanel.this._table.clearRows();
                GLMModelDetailsRowData gLMModelDetailsRowData = new GLMModelDetailsRowData(GLMDetailsLrb.get("DETAILS_FAILURE"));
                DetailsPanel.this._table.addRow(gLMModelDetailsRowData);
                DataMinerEditor.handleEditorException(DetailsPanel.this.getEditor().getContext(), exception, GLMDetailsLrb.get("DETAILS_VIEWER_FAILURE_TITLE"), GLMDetailsLrb.get("DETAILS_VIEWER_FAILURE_MESG"));
            }
            finally {
                if (DetailsPanel.this.overLayPanel != null) {
                    DetailsPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

