/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree.model;

import ilog.views.sdm.model.IlvDefaultSDMLink;
import ilog.views.sdm.model.IlvSDMNode;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.mviewer.dt.schema.Node;
import oracle.dmt.dataminer.mviewer.dtree.DTTreeRule;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeNode;
import oracle.dmt.dataminer.utils.HTMLStringUtils;

public final class DTTreeLink
extends IlvDefaultSDMLink {
    private static final Logger theLogger = Logger.getLogger(DTTreeLink.class.getName());
    private String _id;
    private DTTreeNode _from;
    private DTTreeNode _to;
    private static String defaultLinkName = DecisionTreeEditorLrb.get("LINK");

    public DTTreeLink(String string) {
        super(string);
    }

    public static DTTreeLink createLink(DTTreeNode dTTreeNode, DTTreeNode dTTreeNode2) throws Exception {
        DTTreeLink dTTreeLink = new DTTreeLink(DTTreeLink.getCommonTag());
        dTTreeLink.setTo((IlvSDMNode)dTTreeNode);
        dTTreeLink.setFrom((IlvSDMNode)dTTreeNode2);
        return dTTreeLink;
    }

    public static String getCommonTag() {
        return "DTTreeLink";
    }

    public String getTag() {
        return DTTreeLink.getCommonTag();
    }

    public IlvSDMNode getFrom() {
        return this._from;
    }

    public void setFrom(IlvSDMNode ilvSDMNode) {
        this._from = (DTTreeNode)ilvSDMNode;
    }

    public void setTo(IlvSDMNode ilvSDMNode) {
        this._to = (DTTreeNode)ilvSDMNode;
    }

    public IlvSDMNode getTo() {
        return this._to;
    }

    public String getProperty(String string) {
        String string2 = null;
        try {
            DTTreeNode dTTreeNode = (DTTreeNode)this.getTo();
            Node node = dTTreeNode.getData();
            if ("label".equals(string)) {
                string2 = "";
            } else if ("tooltip".equals(string)) {
                DTTreeRule.Predicate predicate = DTTreeRule.getPredicateNoSurrogates(node);
                if (predicate == null) {
                    return DecisionTreeEditorLrb.get("NULL_PREDICATE");
                }
                DTTreeRule.RuleElement ruleElement = predicate.getRuleElement();
                if (ruleElement == null) {
                    return DecisionTreeEditorLrb.get("NULL_RULE_ELEMENT");
                }
                String string3 = HTMLStringUtils.forHTML(DTTreeRule.getFormattedExpressionString(ruleElement, 20));
                string2 = "<html>\n" + DecisionTreeEditorLrb.get("NODE_SPLIT_PREDICATE") + "<br>" + string3;
                string2 = string2 + "</html>\n";
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return string2;
    }

    public void setProperty(String string, Object object) {
    }

    public String[] getDependentProperties(String string) {
        return new String[0];
    }

    public String[] getPropertyNames() {
        return new String[0];
    }

    public String getID() {
        return this._id;
    }

    public void setID(String string) {
        this._id = string;
    }

    public String getDefaultLinkName() {
        return defaultLinkName;
    }
}

