/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreePreferencesSettings;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.icons.OracleIcons;

public class DecisionTreePreferencesPanel
extends DefaultTraversablePanel
implements ActionListener,
DataminerGUIPanel {
    private JRadioButton horizontalRb;
    private JLabel infoLabel;
    private JLabel layoutOptionsLabel;
    private JLabel nodeOptionsLabel;
    private JCheckBox showDetailChk;
    private JCheckBox showHistogramChk;
    private JRadioButton sortByConfidenceRb;
    private JRadioButton sortByRootOrderRb;
    private JLabel sortOptionsLabel;
    private JRadioButton verticalRb;

    public DecisionTreePreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.nodeOptionsLabel = new JLabel();
        this.showHistogramChk = new JCheckBox();
        this.showDetailChk = new JCheckBox();
        this.sortOptionsLabel = new JLabel();
        this.sortByRootOrderRb = new JRadioButton();
        this.sortByConfidenceRb = new JRadioButton();
        this.layoutOptionsLabel = new JLabel();
        this.verticalRb = new JRadioButton();
        this.horizontalRb = new JRadioButton();
        this.infoLabel = new JLabel();
        this.nodeOptionsLabel.setText("Node Display Options");
        this.showHistogramChk.setSelected(true);
        this.showHistogramChk.setText("Show Histogram");
        this.showHistogramChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DecisionTreePreferencesPanel.this.showHistogramChkActionPerformed(actionEvent);
            }
        });
        this.showDetailChk.setSelected(true);
        this.showDetailChk.setText("Show Detailed Header");
        this.sortOptionsLabel.setText("Sort Target Values By");
        this.sortByRootOrderRb.setText("Root Node Order");
        this.sortByConfidenceRb.setText("Confidence");
        this.layoutOptionsLabel.setText("Default Layout");
        this.verticalRb.setText("Vertical");
        this.horizontalRb.setText("Horizontal");
        this.infoLabel.setText("Info text");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.showDetailChk).addComponent(this.showHistogramChk, -1, 443, Short.MAX_VALUE).addComponent(this.sortOptionsLabel).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sortByConfidenceRb).addComponent(this.sortByRootOrderRb))))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.nodeOptionsLabel).addGap(84, 84, 84)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.horizontalRb).addComponent(this.verticalRb))).addComponent(this.layoutOptionsLabel))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel, -2, 326, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.nodeOptionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showHistogramChk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showDetailChk).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sortOptionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sortByRootOrderRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sortByConfidenceRb).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.layoutOptionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.verticalRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.horizontalRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 64, Short.MAX_VALUE).addComponent(this.infoLabel).addContainerGap()));
    }

    private void showHistogramChkActionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DecisionTreeEditorLrb.get("NODE_OPTIONS_LABEL"), this.nodeOptionsLabel);
        hashMap.put(DecisionTreeEditorLrb.get("SHOW_HISTOGRAM"), this.showHistogramChk);
        hashMap.put(DecisionTreeEditorLrb.get("SHOW_DETAIL_HEADER"), this.showDetailChk);
        hashMap.put(DecisionTreeEditorLrb.get("SORT_OPTIONS_LABEL"), this.sortOptionsLabel);
        hashMap.put(DecisionTreeEditorLrb.get("LAYOUT_OPTIONS_LABEL"), this.layoutOptionsLabel);
        UIResourceHelper.setComponentText(hashMap);
        this.setHelpID("preferences_model_viewer_dtree");
        this.verticalRb.setText(DecisionTreeEditorLrb.get("VERTICAL"));
        this.horizontalRb.setText(DecisionTreeEditorLrb.get("HORIZONTAL"));
        this.horizontalRb.setText(DecisionTreeEditorLrb.get("HORIZONTAL"));
        this.sortByRootOrderRb.setText(DecisionTreeEditorLrb.get("ROOT_ORDER"));
        this.sortByConfidenceRb.setText(DecisionTreeEditorLrb.get("CONFIDENCE_ORDER"));
    }

    @Override
    public void initUI() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.sortByConfidenceRb);
        buttonGroup.add(this.sortByRootOrderRb);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.horizontalRb);
        buttonGroup2.add(this.verticalRb);
        this.infoLabel.setVisible(false);
        this.infoLabel.setText(DecisionTreeEditorLrb.get("INFO_LABEL"));
        this.infoLabel.setIcon(OracleIcons.getIcon((String)"info.png"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.infoLabel.setVisible(true);
    }

    public void onEntry(TraversableContext traversableContext) {
        DecisionTreePreferencesSettings decisionTreePreferencesSettings = DecisionTreePreferencesPanel.getPreferences(traversableContext);
        this.showHistogramChk.setSelected(decisionTreePreferencesSettings.isShowHistogram());
        this.showDetailChk.setSelected(decisionTreePreferencesSettings.isShowNodeDetailHeader());
        this.sortByRootOrderRb.setSelected(decisionTreePreferencesSettings.isSortByRootOrder());
        this.sortByConfidenceRb.setSelected(!decisionTreePreferencesSettings.isSortByRootOrder());
        this.horizontalRb.setSelected(decisionTreePreferencesSettings.isHorizontalLayout());
        this.verticalRb.setSelected(!decisionTreePreferencesSettings.isHorizontalLayout());
        this.showHistogramChk.addActionListener(this);
        this.showDetailChk.addActionListener(this);
        this.sortByConfidenceRb.addActionListener(this);
        this.sortByRootOrderRb.addActionListener(this);
        this.horizontalRb.addActionListener(this);
        this.verticalRb.addActionListener(this);
    }

    public void onExit(TraversableContext traversableContext) {
        DecisionTreePreferencesSettings decisionTreePreferencesSettings = DecisionTreePreferencesPanel.getPreferences(traversableContext);
        decisionTreePreferencesSettings.setShowHistogram(this.showHistogramChk.isSelected());
        decisionTreePreferencesSettings.setShowNodeDetailHeader(this.showDetailChk.isSelected());
        decisionTreePreferencesSettings.setSortByRootOrder(this.sortByRootOrderRb.isSelected());
        decisionTreePreferencesSettings.setHorizontalOrientation(this.horizontalRb.isSelected());
        this.showHistogramChk.removeActionListener(this);
        this.showDetailChk.removeActionListener(this);
        this.sortByConfidenceRb.removeActionListener(this);
        this.sortByRootOrderRb.removeActionListener(this);
        this.horizontalRb.removeActionListener(this);
        this.verticalRb.removeActionListener(this);
    }

    private static DecisionTreePreferencesSettings getPreferences(TraversableContext traversableContext) {
        return DecisionTreePreferencesSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

