/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.tree.IlvTreeLayout;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.event.SDMPropertyChangeEvent;
import ilog.views.sdm.event.SDMPropertyChangeListener;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.editor.Diagram;
import oracle.diagram.core.editor.ScrollManagerView;
import oracle.diagram.core.interaction.SelectionChangeNotificationPlugin;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.framework.menu.DefaultDiagramMainMenuPlugin;
import oracle.diagram.framework.menu.DiagramMainMenuPlugin;
import oracle.diagram.framework.readonly.DefaultDiagramReadOnlyPlugin;
import oracle.diagram.framework.readonly.DiagramReadOnlyPlugin;
import oracle.diagram.framework.toolbar.DefaultDiagramToolbarPlugin;
import oracle.diagram.framework.toolbar.ToolbarPlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.DataMinerDiagramEditor;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.exception.InvalidNodeTypeException;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.TreeRulesPanel;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dt.schema.Node;
import oracle.dmt.dataminer.mviewer.dtree.DTTreeRule;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeContextMenu;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeDiagram;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreePreferencesSettings;
import oracle.dmt.dataminer.mviewer.dtree.NodeDetailPane;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeLink;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeNode;
import oracle.dmt.dataminer.mviewer.dtree.model.DecisionTreeSDMModel;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;

public class DecisionTreeEditor
extends DataMinerDiagramEditor {
    private int _treeFlowDirection;
    private int _maxAttributeLength;
    private static final Logger theLogger = Logger.getLogger(DecisionTreeEditor.class.getName());
    private BlockingComponent overLayPanel = null;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar;
    private PartitionVO pvo = new PartitionVO("", "");
    private JSplitPane splitComponent;
    private JScrollPane detailView;
    private JEditorPane textEditorPane;
    private static int DOLAYOUT_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.doDTreelayout");
    private static int TOGGLE_HISTOGRAM_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.toggleDTreeHistogram");
    private static int TOGGLE_DETAIL_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.toggleDetailedHeader");
    private static int EXPAND_ALL_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.expandAllNodes");
    private static final int MAX_VISIBLE_TARGET_VALUES = 9;
    private static final int MIN_VISIBLE_TARGET_VALUES = 2;
    private static final int DEFAULT_SELECTED_TARGET_VALUE = 3;

    public DecisionTreeEditor() {
        super((Diagram)new DecisionTreeDiagram());
        DecisionTreePreferencesSettings decisionTreePreferencesSettings = DecisionTreePreferencesSettings.getInstance();
        this._treeFlowDirection = !decisionTreePreferencesSettings.isHorizontalLayout() ? 8 : 2;
        this._maxAttributeLength = decisionTreePreferencesSettings.getMaxTargetValueDisplayLength();
        this.setPreferredLayoutBaseName("Tree");
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("tree_diagram_editor");
    }

    public ContextMenu getContextMenu() {
        ContextMenu contextMenu = super.getContextMenu();
        DecisionTreeContextMenu decisionTreeContextMenu = DecisionTreeContextMenu.getInstance();
        contextMenu.addMenuFilter((MenuFilter)decisionTreeContextMenu);
        return contextMenu;
    }

    @Override
    public ContextMenuListener getContextMenuListener() {
        return DecisionTreeContextMenu.getInstance();
    }

    protected void installEditorPlugins(Diagram diagram) {
        super.installEditorPlugins(diagram);
        DiagramContext diagramContext = diagram.getDiagramContext();
        diagramContext.addPlugin(DiagramMainMenuPlugin.class, (Plugin)DefaultDiagramMainMenuPlugin.getInstance());
        diagramContext.addPlugin(DiagramReadOnlyPlugin.class, (Plugin)new OdmrReadOnlyPlugin(diagramContext));
        diagramContext.addPlugin(ToolbarPlugin.class, (Plugin)new TreeViewerToolbarPlugin(diagramContext, this));
        diagramContext.addPlugin(SelectionChangeNotificationPlugin.class, (Plugin)new SelectionChangePlugin());
    }

    public void initializeLayout(Layout layout) {
        super.initializeLayout(layout);
        layout.setProperty("Layout.ShowUnifiedThumbnail", Boolean.TRUE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openImpl(boolean bl) throws OpenAbortedException {
        super.openImpl(bl);
        if (!bl) {
            return;
        }
        DTModelNode dTModelNode = this.getContextNode();
        try {
            final IlvSDMEngine ilvSDMEngine = dTModelNode.getEngine();
            SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
            final DecisionTreeSDMModel decisionTreeSDMModel = (DecisionTreeSDMModel)dTModelNode.getFilteredModel(sDMUndoFilter);
            DecisionTreePreferencesSettings decisionTreePreferencesSettings = DecisionTreePreferencesSettings.getInstance();
            decisionTreeSDMModel.setSortByConfidence(!decisionTreePreferencesSettings.isSortByRootOrder());
            decisionTreeSDMModel.setBarChartVisible(decisionTreePreferencesSettings.isShowHistogram());
            decisionTreeSDMModel.setHeaderDetailVisible(decisionTreePreferencesSettings.isShowNodeDetailHeader());
            decisionTreePreferencesSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                    ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
                    boolean bl = false;
                    for (int i = 0; i < changeInfoArray.length; ++i) {
                        ChangeInfo changeInfo = changeInfoArray[i];
                        if (!changeInfo.getPropertyName().equals("targetValueDisplayMax")) continue;
                        DecisionTreeEditor.this._maxAttributeLength = changeInfo.getNewValueAsInt();
                        bl = true;
                    }
                    if (bl) {
                        decisionTreeSDMModel.fireDataChanged(null);
                        DecisionTreeEditor.this.doLayout(ilvSDMEngine, DecisionTreeEditor.this._treeFlowDirection, false);
                    }
                }
            });
            if (dTModelNode.isModelExists().booleanValue()) {
                this.load(dTModelNode, decisionTreeSDMModel);
                ilvSDMEngine.setModel((IlvSDMModel)sDMUndoFilter);
                this.doLayout(ilvSDMEngine, this._treeFlowDirection, true);
                this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel);
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ModelViewerLrb.get("LOAD_MODEL_MISSING"), (String)ModelViewerLrb.get("MODEL_MISSING_TITLE"), null);
                this.abortOpen((oracle.ide.model.Node)dTModelNode, ModelViewerLrb.get("MODEL_DOES_NOT_EXIST"));
            }
        }
        catch (Exception exception) {
            if (exception instanceof OpenAbortedException) {
                throw (OpenAbortedException)((Object)exception);
            }
            if (exception instanceof DecisionTreeSDMModel.MalformedModelException) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelViewerLrb.get("FAILED_ERROR_TITLE"), (String)exception.getMessage(), null);
            } else {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelViewerLrb.get("FAILED_ERROR_TITLE"), (String)ModelViewerLrb.get("FAILED_OPEN"), null);
            }
            this.abortOpen((oracle.ide.model.Node)dTModelNode);
        }
        finally {
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            }
        }
    }

    public void reload() {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        LoadUI loadUI = new LoadUI(true);
        loadUI.execute();
    }

    private void setPropertyChangeListener(IlvSDMEngine ilvSDMEngine, DecisionTreeSDMModel decisionTreeSDMModel) {
        Enumeration enumeration = decisionTreeSDMModel.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof DTTreeNode)) continue;
            DTTreeNode dTTreeNode = (DTTreeNode)e;
            dTTreeNode.assignPropertyChangeListener(ilvSDMEngine);
        }
        decisionTreeSDMModel.addSDMPropertyChangeListener(new ModelListener());
    }

    public int getMaxAttributeLength() {
        return this._maxAttributeLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLayout(IlvSDMEngine ilvSDMEngine, int n, boolean bl) {
        IlvTreeLayout ilvTreeLayout = new IlvTreeLayout();
        IlvGrapher ilvGrapher = ilvSDMEngine.getGrapher();
        ilvTreeLayout.attach(ilvGrapher);
        ilvTreeLayout.setFlowDirection(n);
        ilvTreeLayout.setGlobalLinkStyle(2);
        try {
            ilvTreeLayout.performLayout();
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            theLogger.log(Level.FINEST, ilvGraphLayoutException.getMessage());
        }
        finally {
            IlvManagerView ilvManagerView;
            if (bl && (ilvManagerView = this.getDiagram().getDiagramContext().getManagerView()) != null) {
                ilvManagerView.fitTransformerToContent();
            }
        }
        ilvTreeLayout.detach();
    }

    public void expandAllNodes() {
        IlvSDMEngine ilvSDMEngine;
        SDMUndoFilter sDMUndoFilter;
        DTModelNode dTModelNode = this.getContextNode();
        DecisionTreeSDMModel decisionTreeSDMModel = (DecisionTreeSDMModel)dTModelNode.getFilteredModel(sDMUndoFilter = (SDMUndoFilter)(ilvSDMEngine = dTModelNode.getEngine()).getModel());
        Enumeration enumeration = decisionTreeSDMModel.getObjects();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof DTTreeNode)) continue;
            sDMUndoFilter.setObjectProperty(e, "expanded", (Object)1);
        }
    }

    @Override
    public void closeImpl(boolean bl) {
        super.closeImpl(bl);
    }

    private void load(DTModelNode dTModelNode, DecisionTreeSDMModel decisionTreeSDMModel) throws Exception {
        if (dTModelNode.isModelExists().booleanValue()) {
            decisionTreeSDMModel.load(dTModelNode.getModelLoader().getRootObject(), this.getContext());
            dTModelNode.setReadOnly(true);
        }
    }

    public DTTreeNode getSelectedDiagramNode() throws Exception {
        List<DTTreeNode> list = this.getSelectedDiagramNodes();
        if (list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    public List<DTTreeNode> getSelectedDiagramNodes() throws Exception {
        ArrayList<DTTreeNode> arrayList = new ArrayList<DTTreeNode>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof DTTreeNode)) continue;
                arrayList.add((DTTreeNode)e);
            }
        }
        return arrayList;
    }

    public DTTreeLink getSelectedDiagramLink() {
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return null;
        }
        IlvManager ilvManager = ilvManagerView.getManager();
        DTModelNode dTModelNode = this.getContextNode();
        IlvSDMEngine ilvSDMEngine = dTModelNode.getEngine();
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getSelectedObjects();
        if (ilvManager.getSelectedObjectsCount() > 1 || ilvManager.getSelectedObjectsCount() == 0) {
            return null;
        }
        IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
        Object object = ilvSDMEngine.getObject(ilvGraphic);
        if (object instanceof DTTreeLink) {
            return (DTTreeLink)((Object)object);
        }
        return null;
    }

    public List<DTTreeLink> getSelectedDiagramLinks() throws Exception {
        ArrayList<DTTreeLink> arrayList = new ArrayList<DTTreeLink>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof DTTreeLink)) continue;
                arrayList.add((DTTreeLink)((Object)e));
            }
        }
        return arrayList;
    }

    public List<Object> getSelectedDiagramObjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    @Override
    public void closeEditor() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.closeEditors(Collections.singletonList(DecisionTreeEditor.this));
            }
        });
    }

    public Component createGUI() {
        DTModelNode dTModelNode = this.getContextNode();
        if (!dTModelNode.isLoaded()) {
            return null;
        }
        this.detailView = new JScrollPane();
        this.detailView.setLayout(new ScrollPaneLayout());
        this.textEditorPane = new JEditorPane();
        this.textEditorPane.setEditable(false);
        this.textEditorPane.setContentType("text/html");
        this.textEditorPane.setText(DecisionTreeEditorLrb.get("NO_SELECTION"));
        this.detailView.getViewport().add(this.textEditorPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        ToolbarPlugin toolbarPlugin = (ToolbarPlugin)this.getDiagram().getDiagramContext().getPlugin(ToolbarPlugin.class);
        if (toolbarPlugin != null) {
            Toolbar toolbar = toolbarPlugin.getToolbar();
            if (toolbar == null) {
                toolbarPlugin.createToolbar((View)this);
                toolbar = toolbarPlugin.getToolbar();
            }
            jPanel.add((Component)toolbar, "North");
        }
        jPanel.add((Component)new ScrollManagerView(this.getDiagram().getDiagramContext().getManagerView()), "Center");
        this.splitComponent = new JSplitPane(0, jPanel, this.detailView);
        if (this.overLayPanel == null) {
            this.overLayPanel = new BlockingComponent((JComponent)jPanel);
            this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            this.overLayPanel.setMessage(BlockingComponent.Message.LOADING);
            this.splitComponent.setLeftComponent(this.overLayPanel.getBlockingComponent());
        }
        this.splitComponent.setDividerLocation(0.8);
        this.splitComponent.updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DecisionTreeEditor.this.splitComponent.setDividerLocation(0.8);
                DecisionTreeEditor.this.splitComponent.setResizeWeight(0.8);
            }
        });
        return this.splitComponent;
    }

    public Component getDetailView() {
        return this.splitComponent.getBottomComponent();
    }

    public Component getHorizontalScrollBar() {
        return null;
    }

    public Component getVerticalScrollBar() {
        return null;
    }

    @Override
    public void update(Object object, UpdateMessage updateMessage) {
        super.update(object, updateMessage);
    }

    @Override
    protected void shownImpl(boolean bl) {
        super.shownImpl(bl);
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this.reload();
    }

    private DecisionTreeSDMModel getModel(DTModelNode dTModelNode) {
        IlvSDMEngine ilvSDMEngine = dTModelNode.getEngine();
        SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
        DecisionTreeSDMModel decisionTreeSDMModel = (DecisionTreeSDMModel)dTModelNode.getFilteredModel(sDMUndoFilter);
        return decisionTreeSDMModel;
    }

    private DTModelNode getContextNode() {
        oracle.ide.model.Node node = this.getContext().getNode();
        if (node instanceof DTModelNode) {
            return (DTModelNode)node;
        }
        throw new InvalidNodeTypeException(node, DTModelNode.class);
    }

    public class TreeViewerToolbarPlugin
    extends DefaultDiagramToolbarPlugin
    implements Controller {
        private IdeAction _doFitToWindow;
        private IdeAction _toggleHistogramAction;
        private IdeAction _toggleHeaderAction;
        private IdeAction _expandAllAction;
        private DecisionTreeEditor parentEditor;

        public TreeViewerToolbarPlugin(DiagramContext diagramContext, DecisionTreeEditor decisionTreeEditor2) {
            super(diagramContext);
            this._doFitToWindow = IdeAction.get((int)DOLAYOUT_CMDID);
            this._toggleHistogramAction = IdeAction.get((int)TOGGLE_HISTOGRAM_CMDID);
            this._toggleHeaderAction = IdeAction.get((int)TOGGLE_DETAIL_CMDID);
            this._expandAllAction = IdeAction.get((int)EXPAND_ALL_CMDID);
            this.parentEditor = null;
            this.parentEditor = decisionTreeEditor2;
            this._doFitToWindow.addController((Controller)this);
            this._toggleHistogramAction.addController((Controller)this);
            this._toggleHeaderAction.addController((Controller)this);
            this._expandAllAction.addController((Controller)this);
        }

        public void update(Context context) {
            super.update(context);
            if (this._doFitToWindow != null) {
                this._doFitToWindow.updateAction(context);
            }
        }

        protected Toolbar createToolbarImpl(View view) {
            Object object;
            Object[] objectArray;
            int n;
            DecisionTreeSDMModel decisionTreeSDMModel;
            DTModelNode dTModelNode;
            DecisionTreePreferencesSettings decisionTreePreferencesSettings = DecisionTreePreferencesSettings.getInstance();
            try {
                dTModelNode = DecisionTreeEditor.this.getContextNode();
                decisionTreeSDMModel = DecisionTreeEditor.this.getModel(dTModelNode);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            final DecisionTreeSDMModel decisionTreeSDMModel2 = decisionTreeSDMModel;
            final DTModelNode dTModelNode2 = dTModelNode;
            Toolbar toolbar = super.createToolbarImpl(view);
            ToolButton toolButton = new ToolButton((Action)this._doFitToWindow);
            toolButton.setIcon(OracleIcons.getIcon((String)"fit_to_window.png"));
            toolButton.setToolTipText(ModelViewerLrb.get("FIT_TO_WINDOW_TIP"));
            ToolButton toolButton2 = new ToolButton((Action)this._expandAllAction);
            toolButton2.setIcon(OracleIcons.getIcon((String)"expandall.png"));
            toolButton2.setToolTipText(ModelViewerLrb.get("EXPAND_ALL_TIP"));
            this._toggleHistogramAction.setState(decisionTreePreferencesSettings.isShowHistogram());
            ToggleToolButton toggleToolButton = new ToggleToolButton((ToggleAction)this._toggleHistogramAction);
            toggleToolButton.setIcon((Icon)DataMinerIcons.get(Icons.TOGGLE_BAR_GRAPH));
            toggleToolButton.setToolTipText(DecisionTreeEditorLrb.get("SHOW_HISTOGRAM_TIP"));
            this._toggleHeaderAction.setState(decisionTreePreferencesSettings.isShowNodeDetailHeader());
            ToggleToolButton toggleToolButton2 = new ToggleToolButton((ToggleAction)this._toggleHeaderAction);
            toggleToolButton2.setIcon((Icon)DataMinerIcons.get(Icons.TOGGLE_DETAIL));
            toggleToolButton2.setToolTipText(DecisionTreeEditorLrb.get("TOGGLE_HEADER_MORE_TIP"));
            ButtonGroup buttonGroup = new ButtonGroup();
            final DropDownMenuButton dropDownMenuButton = new DropDownMenuButton();
            final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(DecisionTreeEditorLrb.get("HORIZONTAL_LAYOUT"));
            final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(DecisionTreeEditorLrb.get("VERTICAL_LAYOUT"));
            buttonGroup.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem2);
            jRadioButtonMenuItem2.setIcon(DataMinerIcons.get(Icons.TREE_DIAGRAM_V));
            jRadioButtonMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DecisionTreeEditor.this._treeFlowDirection = 8;
                    dropDownMenuButton.setIcon((Icon)DataMinerIcons.get(Icons.TREE_DIAGRAM_V));
                    DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, true);
                }
            });
            jRadioButtonMenuItem.setIcon(DataMinerIcons.get(Icons.TREE_DIAGRAM_H));
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DecisionTreeEditor.this._treeFlowDirection = 2;
                    dropDownMenuButton.setIcon((Icon)DataMinerIcons.get(Icons.TREE_DIAGRAM_H));
                    DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, true);
                }
            });
            dropDownMenuButton.setToolTipText(ModelViewerLrb.get("LAYOUT_TIP"));
            jRadioButtonMenuItem2.setSelected(DecisionTreeEditor.this._treeFlowDirection != 2);
            jRadioButtonMenuItem.setSelected(DecisionTreeEditor.this._treeFlowDirection == 2);
            if (DecisionTreeEditor.this._treeFlowDirection == 2) {
                dropDownMenuButton.setIcon((Icon)DataMinerIcons.get(Icons.TREE_DIAGRAM_H));
            } else if (DecisionTreeEditor.this._treeFlowDirection == 8) {
                dropDownMenuButton.setIcon((Icon)DataMinerIcons.get(Icons.TREE_DIAGRAM_V));
            }
            dropDownMenuButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        dropDownMenuButton.addPopupItem((JMenuItem)jRadioButtonMenuItem2);
                        dropDownMenuButton.addPopupItem((JMenuItem)jRadioButtonMenuItem);
                    } else if (itemEvent.getStateChange() == 2) {
                        dropDownMenuButton.removeAllPopupItems();
                    }
                }
            });
            ButtonGroup buttonGroup2 = new ButtonGroup();
            final DropDownMenuButton dropDownMenuButton2 = new DropDownMenuButton();
            final JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(DecisionTreeEditorLrb.get("SORT_BY_CONFIDENCE"));
            final JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem(DecisionTreeEditorLrb.get("SORT_BY_ROOT_ORDER"));
            buttonGroup2.add(jRadioButtonMenuItem3);
            buttonGroup2.add(jRadioButtonMenuItem4);
            jRadioButtonMenuItem3.setIcon(DataMinerIcons.get(Icons.SORT_CONFIDENCE));
            jRadioButtonMenuItem3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                        decisionTreeSDMModel2.setSortByConfidence(true);
                        dropDownMenuButton2.setIcon((Icon)DataMinerIcons.get(Icons.SORT_CONFIDENCE));
                        dropDownMenuButton2.setToolTipText(DecisionTreeEditorLrb.get("SORT_TIP"));
                        decisionTreeSDMModel2.fireDataChanged(null);
                        DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, false);
                        IlvSDMEngine ilvSDMEngine = dTModelNode2.getEngine();
                        DecisionTreeEditor.this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel2);
                        dTModelNode2.getEngine().setSelected(list.toArray(), true);
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }
            });
            jRadioButtonMenuItem4.setIcon(OracleIcons.getIcon((String)"sortbylocation.png"));
            jRadioButtonMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                        decisionTreeSDMModel2.setSortByConfidence(false);
                        dropDownMenuButton2.setIcon(OracleIcons.getIcon((String)"sortbylocation.png"));
                        dropDownMenuButton2.setToolTipText(DecisionTreeEditorLrb.get("SORT_TIP"));
                        decisionTreeSDMModel2.fireDataChanged(null);
                        DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, false);
                        IlvSDMEngine ilvSDMEngine = dTModelNode2.getEngine();
                        DecisionTreeEditor.this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel2);
                        dTModelNode2.getEngine().setSelected(list.toArray(), true);
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }
            });
            dropDownMenuButton2.setToolTipText(DecisionTreeEditorLrb.get("SORT_TIP"));
            jRadioButtonMenuItem3.setSelected(decisionTreeSDMModel2.isSortByConfidence());
            jRadioButtonMenuItem4.setSelected(decisionTreeSDMModel2.isSortByConfidence() == false);
            if (decisionTreeSDMModel2.isSortByConfidence().booleanValue()) {
                dropDownMenuButton2.setIcon((Icon)DataMinerIcons.get(Icons.SORT_CONFIDENCE));
            } else {
                dropDownMenuButton2.setIcon(OracleIcons.getIcon((String)"sortbylocation.png"));
            }
            dropDownMenuButton2.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        dropDownMenuButton2.addPopupItem((JMenuItem)jRadioButtonMenuItem3);
                        dropDownMenuButton2.addPopupItem((JMenuItem)jRadioButtonMenuItem4);
                    } else if (itemEvent.getStateChange() == 2) {
                        dropDownMenuButton2.removeAllPopupItems();
                    }
                }
            });
            int n2 = n = decisionTreeSDMModel2.getRootTargetValueCount() > 9 ? 9 : decisionTreeSDMModel2.getRootTargetValueCount() - 1;
            if (n > 0) {
                objectArray = new Object[n];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = i + 2;
                }
            } else {
                objectArray = new Object[]{};
            }
            JLabel jLabel = new JLabel();
            jLabel.setText(DecisionTreeEditorLrb.get("MAX_TARGET_VALUES"));
            JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
            if (n > 0) {
                object = objectArray.length >= 4 ? objectArray[3] : objectArray[objectArray.length - 1];
                jComboBox.setSelectedItem(object);
            }
            jComboBox.setToolTipText(DecisionTreeEditorLrb.get("MAX_TARGET_VALUES_TIP"));
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                        Integer n = (Integer)jComboBox.getSelectedItem();
                        decisionTreeSDMModel2.setMaxTargetValuesDisplayed(n);
                        DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, false);
                        IlvSDMEngine ilvSDMEngine = dTModelNode2.getEngine();
                        DecisionTreeEditor.this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel2);
                        dTModelNode2.getEngine().setSelected(list.toArray(), true);
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }
            });
            object = jComboBox.getPreferredSize();
            jComboBox.setMaximumSize((Dimension)object);
            jComboBox.setMinimumSize((Dimension)object);
            JButton jButton = new JButton();
            jButton.setToolTipText(ClusteringTreeEditorLrb.get("REFRESH_TIP"));
            jButton.setIcon(OracleIcons.getIcon((String)"refresh.png"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = TreeViewerToolbarPlugin.this.getSelectedNodeId();
                    DecisionTreeEditor.this.refresh();
                    TreeViewerToolbarPlugin.this.setSelectedNodeUsingId(string, decisionTreeSDMModel2, dTModelNode2);
                }
            });
            DTModelNode dTModelNode3 = (DTModelNode)DecisionTreeEditor.this.getContext().getNode();
            if (dTModelNode3.getPartitionId() != null && !"".equals(dTModelNode3.getPartitionId())) {
                DecisionTreeEditor.this.pvo.setPartitionID(dTModelNode3.getPartitionId());
                DecisionTreeEditor.this.pvo.setPartitionName(dTModelNode3.getPartitionName());
                DecisionTreeEditor.this.modelViewerPartitionToolbar = new ModelViewerPartitionToolbar();
                DecisionTreeEditor.this.modelViewerPartitionToolbar.setEditor((Editor)this.parentEditor, DecisionTreeEditor.this.pvo);
                DecisionTreeEditor.this.modelViewerPartitionToolbar.setVisible(true);
                toolbar.add((Component)DecisionTreeEditor.this.modelViewerPartitionToolbar, 0);
            }
            toolbar.addSeparator();
            toolbar.add((Component)toolButton);
            toolbar.add((Component)dropDownMenuButton);
            toolbar.add((Component)toolButton2);
            toolbar.addSeparator();
            toolbar.addFiller();
            toolbar.add((Component)toggleToolButton);
            toolbar.add((Component)toggleToolButton2);
            toolbar.add((Component)dropDownMenuButton2);
            toolbar.addSeparator(new Dimension(10, 0));
            toolbar.add((Component)jLabel);
            toolbar.addFiller();
            toolbar.add(jComboBox);
            toolbar.addFiller();
            toolbar.addSeparator();
            toolbar.add((Component)jButton);
            toolbar.add(Box.createHorizontalGlue());
            JButton jButton2 = new JButton(ModelViewerLrb.get("TREE_SAVE_RULES_BTN"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreeRulesPanel treeRulesPanel = new TreeRulesPanel((oracle.ide.model.Node)DecisionTreeEditor.this.getContextNode());
                    treeRulesPanel.showAsDialog();
                }
            });
            toolbar.add((Component)jButton2);
            return toolbar;
        }

        private String getSelectedNodeId() {
            String string = null;
            try {
                IlvSDMNode ilvSDMNode;
                List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                if (!list.isEmpty() && (ilvSDMNode = (IlvSDMNode)list.get(0)) instanceof DTTreeNode) {
                    string = ((DTTreeNode)ilvSDMNode).getData().getId();
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return string;
        }

        private void setSelectedNodeUsingId(String string, DecisionTreeSDMModel decisionTreeSDMModel, DTModelNode dTModelNode) {
            if (string != null) {
                Enumeration enumeration = decisionTreeSDMModel.getObjects();
                while (enumeration.hasMoreElements()) {
                    String string2;
                    Object e = enumeration.nextElement();
                    if (!(e instanceof DTTreeNode) || !(string2 = ((DTTreeNode)e).getData().getId()).equals(string)) continue;
                    dTModelNode.getEngine().setSelected(e, true);
                    break;
                }
            }
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            DecisionTreeSDMModel decisionTreeSDMModel;
            DTModelNode dTModelNode;
            View view = context.getView();
            if (!(view instanceof DecisionTreeEditor)) {
                return false;
            }
            try {
                dTModelNode = DecisionTreeEditor.this.getContextNode();
                decisionTreeSDMModel = DecisionTreeEditor.this.getModel(dTModelNode);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            DecisionTreeSDMModel decisionTreeSDMModel2 = decisionTreeSDMModel;
            DTModelNode dTModelNode2 = dTModelNode;
            if (ideAction.getCommandId() == DOLAYOUT_CMDID) {
                IlvSDMEngine ilvSDMEngine = dTModelNode2.getEngine();
                DecisionTreeEditor.this.doLayout(ilvSDMEngine, DecisionTreeEditor.this._treeFlowDirection, true);
                return true;
            }
            if (ideAction.getCommandId() == TOGGLE_HISTOGRAM_CMDID) {
                List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                decisionTreeSDMModel2.toggleBarChartVisible();
                decisionTreeSDMModel2.fireDataChanged(null);
                DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, false);
                IlvSDMEngine ilvSDMEngine = dTModelNode2.getEngine();
                DecisionTreeEditor.this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel2);
                dTModelNode2.getEngine().setSelected(list.toArray(), true);
                return true;
            }
            if (ideAction.getCommandId() == TOGGLE_DETAIL_CMDID) {
                try {
                    List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                    decisionTreeSDMModel2.toggleHeaderDetailVisible();
                    decisionTreeSDMModel2.fireDataChanged(null);
                    DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, false);
                    IlvSDMEngine ilvSDMEngine = dTModelNode2.getEngine();
                    DecisionTreeEditor.this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel2);
                    dTModelNode2.getEngine().setSelected(list.toArray(), true);
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
                return true;
            }
            if (ideAction.getCommandId() == EXPAND_ALL_CMDID) {
                DecisionTreeEditor.this.expandAllNodes();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            View view = context.getView();
            if (!(view instanceof DecisionTreeEditor)) {
                return false;
            }
            if (ideAction.getCommandId() == DOLAYOUT_CMDID) {
                return true;
            }
            if (ideAction.getCommandId() == TOGGLE_HISTOGRAM_CMDID) {
                return true;
            }
            if (ideAction.getCommandId() == TOGGLE_DETAIL_CMDID) {
                return true;
            }
            return ideAction.getCommandId() == EXPAND_ALL_CMDID;
        }
    }

    public class SelectionChangePlugin
    extends AbstractPlugin
    implements SelectionChangeNotificationPlugin {
        private boolean isEnabled = true;

        public void selectionChanged(DiagramContext diagramContext) {
            try {
                List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                if (list.size() > 1) {
                    DecisionTreeEditor.this.textEditorPane.setText(DecisionTreeEditorLrb.get("MULTI_SELECTION"));
                    int n = DecisionTreeEditor.this.splitComponent.getDividerLocation();
                    DecisionTreeEditor.this.splitComponent.setBottomComponent(DecisionTreeEditor.this.detailView);
                    DecisionTreeEditor.this.splitComponent.setDividerLocation(n);
                } else if (list.size() == 1) {
                    Object object = list.get(0);
                    if (object instanceof DTTreeNode) {
                        DTTreeNode dTTreeNode = (DTTreeNode)object;
                        NodeDetailPane nodeDetailPane = new NodeDetailPane(dTTreeNode);
                        int n = DecisionTreeEditor.this.splitComponent.getDividerLocation();
                        DecisionTreeEditor.this.splitComponent.setBottomComponent(nodeDetailPane);
                        DecisionTreeEditor.this.splitComponent.setDividerLocation(n);
                    } else if (object instanceof DTTreeLink) {
                        DTTreeLink dTTreeLink = (DTTreeLink)((Object)object);
                        DTTreeNode dTTreeNode = (DTTreeNode)dTTreeLink.getTo();
                        Node node = dTTreeNode.getData();
                        String string = "";
                        string = "<html>\n" + DecisionTreeEditorLrb.get("NODE_SPLIT_PREDICATE") + "<br>" + "<p style=\"font-family: monospace\">" + DTTreeRule.getFormattedPredicateString(DTTreeRule.getPredicate(node).getRuleElement()) + "</p>" + "</html>";
                        int n = DecisionTreeEditor.this.splitComponent.getDividerLocation();
                        DecisionTreeEditor.this.splitComponent.setBottomComponent(DecisionTreeEditor.this.detailView);
                        DecisionTreeEditor.this.splitComponent.setDividerLocation(n);
                        DecisionTreeEditor.this.textEditorPane.setText(string);
                        DecisionTreeEditor.this.textEditorPane.select(0, 0);
                    }
                } else {
                    DecisionTreeEditor.this.textEditorPane.setText(DecisionTreeEditorLrb.get("NO_SELECTION"));
                    int n = DecisionTreeEditor.this.splitComponent.getDividerLocation();
                    DecisionTreeEditor.this.splitComponent.setBottomComponent(DecisionTreeEditor.this.detailView);
                    DecisionTreeEditor.this.splitComponent.setDividerLocation(n);
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }

        public void setEnabled(boolean bl) {
            this.isEnabled = bl;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    }

    private static class OdmrReadOnlyPlugin
    extends DefaultDiagramReadOnlyPlugin {
        public OdmrReadOnlyPlugin(DiagramContext diagramContext) {
            super(diagramContext);
        }

        protected boolean checkWritableDiagram() {
            return false;
        }
    }

    public static class ModelListener
    implements SDMPropertyChangeListener {
        public void propertyChanged(SDMPropertyChangeEvent sDMPropertyChangeEvent) {
            String string = sDMPropertyChangeEvent.getPropertyName();
            Object object = sDMPropertyChangeEvent.getObject();
            if ("expanded".equals(string) && object instanceof DTTreeNode) {
                ((DTTreeNode)object).setChildrenVisibility();
            }
        }
    }

    private class LoadUI
    extends SwingWorker {
        boolean _reload = false;
        Exception _ex = null;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        protected Object doInBackground() throws Exception {
            try {
                DTModelNode dTModelNode = DecisionTreeEditor.this.getContextNode();
                dTModelNode.setReloading(this._reload);
                dTModelNode.load();
                dTModelNode.setReloading(false);
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                DTModelNode dTModelNode = DecisionTreeEditor.this.getContextNode();
                IlvSDMEngine ilvSDMEngine = dTModelNode.getEngine();
                SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
                DecisionTreeSDMModel decisionTreeSDMModel = (DecisionTreeSDMModel)dTModelNode.getFilteredModel(sDMUndoFilter);
                if (dTModelNode.isModelExists().booleanValue()) {
                    DecisionTreeEditor.this.load(dTModelNode, decisionTreeSDMModel);
                    ilvSDMEngine.setModel((IlvSDMModel)sDMUndoFilter);
                    DecisionTreeEditor.this.doLayout(ilvSDMEngine, DecisionTreeEditor.this._treeFlowDirection, false);
                    DecisionTreeEditor.this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)ModelViewerLrb.get("RELOAD_MODEL_MISSING"), (String)ModelViewerLrb.get("MODEL_MISSING_TITLE"), null);
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof OpenAbortedException)) {
                    this._ex = exception;
                }
            }
            finally {
                if (this._ex != null) {
                    DataMinerEditor.handleEditorException(DecisionTreeEditor.this.getContext(), this._ex, ModelViewerLrb.get("FAILED_ERROR_TITLE"), ModelViewerLrb.get("FAILED_OPEN"));
                }
                if (DecisionTreeEditor.this.overLayPanel != null) {
                    DecisionTreeEditor.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

