/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree;

import ilog.views.IlvManagerView;
import ilog.views.sdm.IlvSDMEngine;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.publish.PublishPlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerDiagramEditor;
import oracle.dmt.dataminer.mviewer.dt.schema.Node;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditor;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controls.ToggleAction;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;

public class DecisionTreeContextMenu
implements ContextMenuListener,
Controller,
MenuFilter {
    private static final Logger theLogger = Logger.getLogger(DecisionTreeContextMenu.class.getName());
    private static final int COPY_IMAGE_ID = Ide.createCmdID((String)"copyImage");
    private static final int SAVE_IMAGE_ID = Ide.createCmdID((String)"saveImage");
    protected static final int PRIMARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeAction");
    protected static final int SECONDARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeActionSecondary");
    protected static final int TERTIARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeActionTertiary");
    private static volatile DecisionTreeContextMenu _instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DecisionTreeContextMenu getInstance() {
        if (_instance != null) return _instance;
        Class<DecisionTreeContextMenu> clazz = DecisionTreeContextMenu.class;
        synchronized (DecisionTreeContextMenu.class) {
            if (_instance != null) return _instance;
            _instance = new DecisionTreeContextMenu();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        View view = context.getView();
        ArrayList<DTTreeNode> arrayList = new ArrayList<DTTreeNode>();
        if (!(view instanceof DecisionTreeEditor)) return;
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        Object object = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (object == null) return;
        Enumeration enumeration = object.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof DTTreeNode)) continue;
            arrayList.add((DTTreeNode)e);
        }
        ilvManagerView = IdeAction.get((int)COPY_IMAGE_ID);
        object = contextMenu.createMenuItem((ToggleAction)ilvManagerView, 1.0f);
        ((AbstractButton)object).setText(WorkflowEditorLrb.get("CONTEXT_MENU_COPY_IMAGE"));
        ilvManagerView.addController((Controller)this);
        contextMenu.add((Component)object);
        enumeration = IdeAction.get((int)SAVE_IMAGE_ID);
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)enumeration, 1.0f);
        jMenuItem.setText(WorkflowEditorLrb.get("CONTEXT_MENU_SAVE_IMAGE"));
        enumeration.addController(this);
        contextMenu.add((Component)jMenuItem);
        if (arrayList.size() == 0) {
            return;
        }
        DTTreeNode dTTreeNode = (DTTreeNode)arrayList.get(0);
        Node node = dTTreeNode.getData();
        int n = arrayList.size();
        IdeAction ideAction = IdeAction.get((int)PRIMARY_EDIT_ACTION_ID);
        JMenuItem jMenuItem2 = contextMenu.createMenuItem((ToggleAction)ideAction, 1.0f);
        ideAction.addController((Controller)this);
        IdeAction ideAction2 = IdeAction.get((int)SECONDARY_EDIT_ACTION_ID);
        JMenuItem jMenuItem3 = contextMenu.createMenuItem((ToggleAction)ideAction2, 1.0f);
        ideAction2.addController((Controller)this);
        IdeAction ideAction3 = IdeAction.get((int)TERTIARY_EDIT_ACTION_ID);
        JMenuItem jMenuItem4 = contextMenu.createMenuItem((ToggleAction)ideAction3, 1.0f);
        ideAction3.addController((Controller)this);
        if (n != 1) return;
        if (this.isRequirePrimaryEditMenu(node)) {
            jMenuItem2.setText(this.getPrimaryEditMenuText(node));
            contextMenu.add((Component)jMenuItem2, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
        }
        if (this.isRequireSecondaryEditMenu(node)) {
            jMenuItem3.setText(this.getSecondaryEditMenuText(node));
            contextMenu.add((Component)jMenuItem3, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        }
        if (!this.isRequireTertiaryEditMenu(node)) return;
        jMenuItem4.setText(this.getTertiaryEditMenuText(node));
        contextMenu.add((Component)jMenuItem4, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
    }

    private boolean isRequirePrimaryEditMenu(Node node) {
        return false;
    }

    private boolean isRequireSecondaryEditMenu(Node node) {
        return false;
    }

    private boolean isRequireTertiaryEditMenu(Node node) {
        return false;
    }

    private String getPrimaryEditMenuText(Node node) {
        if (node != null) {
            return DecisionTreeEditorLrb.get("EDIT_NODE");
        }
        return null;
    }

    private String getSecondaryEditMenuText(Node node) {
        return DecisionTreeEditorLrb.get("BUILD_NODE_SECONDARY");
    }

    private String getTertiaryEditMenuText(Node node) {
        return DecisionTreeEditorLrb.get("DATA_SOURCE_NODE_TERTIARY");
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public static void handlePrimaryEdit(Context context, DecisionTreeEditor decisionTreeEditor) throws Exception {
        DTTreeNode dTTreeNode = decisionTreeEditor.getSelectedDiagramNode();
        if (!(dTTreeNode instanceof DTTreeNode)) {
            theLogger.log(Level.SEVERE, "Node type: " + dTTreeNode.getClass().getName() + " not handled in WorflowContextMenu.handlePrimaryEdit ()");
        }
    }

    private void handleSecondaryEdit(Context context, DecisionTreeEditor decisionTreeEditor) throws Exception {
        DTTreeNode dTTreeNode = decisionTreeEditor.getSelectedDiagramNode();
        if (!(dTTreeNode instanceof DTTreeNode)) {
            theLogger.log(Level.SEVERE, "Node type: " + dTTreeNode.getClass().getName() + " not handled in WorflowContextMenu.handleSecondaryEdit ()");
        }
    }

    private void handleTertiaryEdit(Context context, DecisionTreeEditor decisionTreeEditor) throws Exception {
        DTTreeNode dTTreeNode = decisionTreeEditor.getSelectedDiagramNode();
        if (!(dTTreeNode instanceof DTTreeNode)) {
            theLogger.log(Level.SEVERE, "Node type: " + dTTreeNode.getClass().getName() + " not handled in WorflowContextMenu.handleSecondaryEdit ()");
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        View view = context.getView();
        if (!(view instanceof DecisionTreeEditor)) {
            return false;
        }
        if (ideAction.getCommandId() == COPY_IMAGE_ID) {
            DataMinerDiagramEditor.CopyEditorToClipboard(((DiagramView)view).getActiveManagerView());
            return true;
        }
        if (ideAction.getCommandId() == SAVE_IMAGE_ID) {
            DiagramContext diagramContext = DiagramContext.getDiagramContext((IlvManagerView)((DiagramView)view).getActiveManagerView());
            PublishPlugin publishPlugin = (PublishPlugin)diagramContext.getPlugin(PublishPlugin.class);
            publishPlugin.publish();
            return true;
        }
        DecisionTreeEditor decisionTreeEditor = (DecisionTreeEditor)view;
        if (ideAction.getCommandId() == PRIMARY_EDIT_ACTION_ID || ideAction.equals(IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES))) {
            try {
                DecisionTreeContextMenu.handlePrimaryEdit(context, decisionTreeEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == SECONDARY_EDIT_ACTION_ID) {
            try {
                this.handleSecondaryEdit(context, decisionTreeEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == TERTIARY_EDIT_ACTION_ID) {
            try {
                this.handleTertiaryEdit(context, decisionTreeEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        Object object;
        Object object2;
        View view = context.getView();
        if (!(view instanceof DecisionTreeEditor)) {
            return false;
        }
        DTModelNode dTModelNode = (DTModelNode)context.getNode();
        ArrayList<DTTreeNode> arrayList = new ArrayList<DTTreeNode>();
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            object2 = ilvSDMEngine.getSelectedObjects();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                if (!(object instanceof DTTreeNode)) continue;
                arrayList.add((DTTreeNode)object);
            }
        } else {
            return true;
        }
        if (arrayList.size() == 0) {
            return true;
        }
        object2 = (DTTreeNode)arrayList.get(0);
        object = ((DTTreeNode)object2).getData();
        int n = arrayList.size();
        boolean bl = false;
        if (ideAction.getCommandId() == PRIMARY_EDIT_ACTION_ID || ideAction.equals(IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES))) {
            if (this.isRequirePrimaryEditMenu((Node)object)) {
                bl = n == 1 && !dTModelNode.isReadOnly();
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (ideAction.getCommandId() == SECONDARY_EDIT_ACTION_ID) {
            if (this.isRequireSecondaryEditMenu((Node)object)) {
                bl = n == 1 && !dTModelNode.isReadOnly();
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (ideAction.getCommandId() == TERTIARY_EDIT_ACTION_ID) {
            if (this.isRequireTertiaryEditMenu((Node)object)) {
                bl = n == 1 && !dTModelNode.isReadOnly();
            }
            ideAction.setEnabled(bl);
            return true;
        }
        return true;
    }

    public boolean accept(Component component) {
        if (!(component instanceof JMenuItem)) {
            return true;
        }
        JMenuItem jMenuItem = (JMenuItem)component;
        Action action = jMenuItem.getAction();
        int n = 0;
        if (action != null && !(action instanceof IdeAction)) {
            return true;
        }
        if (action != null) {
            IdeAction ideAction = (IdeAction)jMenuItem.getAction();
            n = ideAction.getCommandId();
        }
        switch (n) {
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                return false;
            }
        }
        return true;
    }
}

