/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.filter.FilterConsumer;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientItemTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoefficientFilterPanel;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.workflow.DataMinerViewListenerAdapter;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;

public class RegrCoefficientFilterPanel
extends GeneralCoefficientFilterPanel {
    private static final Logger theLogger = Logger.getLogger(RegrCoefficientFilterPanel.class.getName());
    private JCheckBox _jAbsoluteValueFilter;
    private JButton _jApplyFilterButton;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar1;

    public RegrCoefficientFilterPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public RegrCoefficientFilterPanel(CoefViewerMainPanel coefViewerMainPanel, Context context, CoefViewerState coefViewerState) {
        try {
            this._mainPanel = coefViewerMainPanel;
            this._context = context;
            this._state = coefViewerState;
            this.initComponents();
            this.initRes();
            this.initUI();
            this.initializeUIState();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void initComponents() {
        this._jAbsoluteValueFilter = new JCheckBox();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSize = new JSpinner();
        this._jApplyFilterButton = new JButton();
        this.modelViewerPartitionToolbar1 = new ModelViewerPartitionToolbar();
        this._jAbsoluteValueFilter.setText("Sort by absolute value");
        this._jAbsoluteValueFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jAbsoluteValueFilter.setMargin(new Insets(0, 0, 0, 0));
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setHorizontalAlignment(11);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this._jAbsoluteValueFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 262, Short.MAX_VALUE).addComponent(this._jFetchSizeLabel, -2, 109, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFetchSize, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jApplyFilterButton)).addGroup(groupLayout.createSequentialGroup().addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jAbsoluteValueFilter).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jApplyFilterButton).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jFetchSizeLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2).addContainerGap()));
    }

    @Override
    protected JSpinner getFetchSizeComponent() {
        return this._jFetchSize;
    }

    @Override
    protected JCheckBox getAbsoluteValueComponent() {
        return this._jAbsoluteValueFilter;
    }

    @Override
    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(CoefficientsLrb.get("FETCH_SIZE_ADA") + "\n" + CoefficientsLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1));
        ResourceUtils.resButton((AbstractButton)this._jAbsoluteValueFilter, (String)CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
        this._jAbsoluteValueFilter.setToolTipText(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
    }

    @Override
    public void initUI() {
        this.setLocale(this._jFetchSize, Locale.getDefault());
        this._jAbsoluteValueFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegrCoefficientFilterPanel.this._jAbsoluteValueFilter_actionPerformed(actionEvent);
            }
        });
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegrCoefficientFilterPanel.this._jApplyFilterButton_actionPerformed(actionEvent);
            }
        });
        CoefficientItemTableModel coefficientItemTableModel = new CoefficientItemTableModel();
        this._state.setFilterItemTableModel(coefficientItemTableModel);
        this._jItemFilterTable.setModel((TableModel)((Object)coefficientItemTableModel));
        this.enableControls(false);
        this._mainPanel.addDataMinerViewListener(new DataMinerViewListenerAdapter(){

            @Override
            public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
                RegrCoefficientFilterPanel.this.enableControls(true);
            }

            @Override
            public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
                RegrCoefficientFilterPanel.this.enableControls(false);
            }
        });
        ((GroupLayout)this.getLayout()).invalidateLayout(this);
        if (this._mainPanel.isModelParitioned()) {
            this.modelViewerPartitionToolbar1.setEditor(this._mainPanel.getEditor(), this._mainPanel.getPartitionVO());
            this.modelViewerPartitionToolbar1.setVisible(true);
        } else {
            this.modelViewerPartitionToolbar1.setVisible(false);
        }
    }

    @Override
    public void setupUI(CoefficientFilterSetting coefficientFilterSetting) {
        this._coefFilterSetting = coefficientFilterSetting;
        this.loadStateAttributes();
        this.enableControls(true);
        this.setLoaded(true);
    }

    public String getSelectedPartitionName() {
        return this.modelViewerPartitionToolbar1.getSelectedPartitionName();
    }

    public String getSelectedParitionId() {
        return this.modelViewerPartitionToolbar1.getSelectedPartitionID();
    }

    public PartitionVO getPartitionVO() {
        return this.modelViewerPartitionToolbar1.getPartitionVO();
    }

    private void initializeUIState() throws Exception {
        this._coefFilterSetting = new CoefficientFilterSetting();
        this.loadStateAttributes();
    }

    public void unloadUI() throws Exception {
        this.enableControls(false);
        if (this._consumerView == null) {
            return;
        }
        this.updateInput();
        ((FilterConsumer)this._consumerView).setCachedFilterState(this._coefFilterSetting);
        this.clearState();
        this.setLoaded(false);
    }

    public void updateInput() throws Exception {
        Number number = this.getNumber(this._jFetchSize);
        this._coefFilterSetting.setFetchSize(number.intValue());
        this._coefFilterSetting.setFilterByAbsolute(this._jAbsoluteValueFilter.isSelected());
    }

    private void clearState() {
        this._consumerView = null;
        this.resetUIAttributes();
        this._jApplyFilterButton.setEnabled(false);
        this._coefFilterSetting = null;
    }

    private void resetUIAttributes() {
        this.setNumber(this._jFetchSize, 1000);
    }

    @Override
    protected void enableControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
        this._jFetchSize.setEnabled(bl);
        this._jFetchSizeLabel.setEnabled(bl);
        this._jAbsoluteValueFilter.setEnabled(bl);
    }

    public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
        this._jApplyFilterButton.setEnabled(true);
        if (!this.isLoaded() && this._consumerView != null) {
            this.setupUIDetail();
        }
    }

    public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
        this._jApplyFilterButton.setEnabled(false);
    }

    @Override
    protected void loadStateAttributes() {
        if (this._coefFilterSetting.getViewerState() != null) {
            this.setNumber(this._jFetchSize, this._modelViewerPrefenceSettings.getFetchSizeOtherModels());
            this._jAbsoluteValueFilter.setSelected(this._coefFilterSetting.getFilterAndSortByAbsolute());
        }
    }

    private void _jAbsoluteValueFilter_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this._state.setSortByAbsoluteValue(this._jAbsoluteValueFilter.isSelected());
        this._coefFilterSetting.setFilterByAbsolute(this._jAbsoluteValueFilter.isSelected());
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        try {
            this._jApplyFilterButton.setEnabled(false);
            GeneralCoefficientFilterPanel.ValidateUpdateState validateUpdateState = new GeneralCoefficientFilterPanel.ValidateUpdateState();
            validateUpdateState.setTitle(CoefficientsLrb.get("FILTER_PROCESS_TITLE"));
            validateUpdateState.setMessage(CoefficientsLrb.get("FILTER_PROCESS_MESG"));
            validateUpdateState.setCancelable(false);
            validateUpdateState.start(true);
            if (validateUpdateState.getException() != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)validateUpdateState.getException(), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
                this.enableControls(true);
            }
            if (validateUpdateState.getValidation()) {
                this._mainPanel.setFilterState(this._coefFilterSetting);
            } else {
                this.enableControls(true);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            this.enableControls(true);
        }
    }
}

