/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.controls.renderers.ComboBoxListRenderer;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientEditor;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientItemTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoefficientFilterPanel;
import oracle.dmt.dataminer.mviewer.coefficients.RenameFeaturePanel;
import oracle.dmt.dataminer.navigator.RefreshController;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.DataMinerViewListenerAdapter;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;

public class PCACoefficientFilterPanel
extends GeneralCoefficientFilterPanel {
    private static final Logger theLogger = Logger.getLogger(PCACoefficientFilterPanel.class.getName());
    private NumberFormat _labelNumericalFormat;
    private JCheckBox _jAbsoluteValueFilter;
    private JButton _jApplyFilterButton;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private JComboBox<Object> _jTargetValueCombo;
    private JLabel _jTargetValueLabel;
    private JButton jBtnTargetEdit;
    private JLabel jSingValueLbl;
    private JLabel jSingValueLbl1;

    public PCACoefficientFilterPanel(CoefViewerMainPanel coefViewerMainPanel, Context context, CoefViewerState coefViewerState) {
        this._labelNumericalFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel(), 0, 0);
        try {
            this._mainPanel = coefViewerMainPanel;
            this._context = context;
            this._state = coefViewerState;
            this.initComponents();
            this.initRes();
            this.initUI();
            this._coefFilterSetting = new CoefficientFilterSetting(false);
            this.loadStateAttributes();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public static PCACoefficientFilterPanel createCoefficientFilterPanel() {
        PCACoefficientFilterPanel pCACoefficientFilterPanel = new PCACoefficientFilterPanel();
        pCACoefficientFilterPanel.initComponents();
        pCACoefficientFilterPanel.initRes();
        pCACoefficientFilterPanel.initUI();
        return pCACoefficientFilterPanel;
    }

    private PCACoefficientFilterPanel() {
        this._labelNumericalFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel(), 0, 0);
    }

    private void initComponents() {
        this._jTargetValueLabel = new JLabel();
        this._jTargetValueCombo = new JComboBox();
        this.jBtnTargetEdit = new JButton();
        this._jApplyFilterButton = new JButton();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSize = new JSpinner();
        this.jSingValueLbl = new JLabel();
        this.jSingValueLbl1 = new JLabel();
        this._jAbsoluteValueFilter = new JCheckBox();
        this.setPreferredSize(new Dimension(835, 71));
        this._jTargetValueLabel.setText("Target Value:");
        this.jBtnTargetEdit.setText("Edit");
        this.jBtnTargetEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PCACoefficientFilterPanel.this.jBtnTargetEditActionPerformed(actionEvent);
            }
        });
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jFetchSizeLabel.setMaximumSize(new Dimension(64, 14));
        this._jFetchSizeLabel.setMinimumSize(new Dimension(64, 14));
        this._jFetchSizeLabel.setPreferredSize(new Dimension(64, 14));
        this._jFetchSize.setMaximumSize(new Dimension(87, 20));
        this._jFetchSize.setMinimumSize(new Dimension(87, 20));
        this._jFetchSize.setPreferredSize(new Dimension(87, 20));
        this.jSingValueLbl.setText("Singular Value:");
        this.jSingValueLbl1.setText(" ");
        this._jAbsoluteValueFilter.setText("Sort by absolute value");
        this._jAbsoluteValueFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jAbsoluteValueFilter.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this._jAbsoluteValueFilter, -2, 213, -2)).addGroup(groupLayout.createSequentialGroup().addGap(416, 416, 416).addComponent(this.jSingValueLbl, -2, 95, -2).addGap(18, 18, 18).addComponent(this.jSingValueLbl1, -2, 95, -2))).addContainerGap(211, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(23, 23, 23).addComponent(this._jTargetValueLabel, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetValueCombo, -2, 173, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnTargetEdit).addGap(280, 357, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this._jFetchSizeLabel, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jFetchSize, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this._jApplyFilterButton, GroupLayout.Alignment.LEADING, -1, 110, Short.MAX_VALUE)).addGap(24, 24, 24))));
        groupLayout.linkSize(0, this.jSingValueLbl, this.jSingValueLbl1);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSingValueLbl).addComponent(this.jSingValueLbl1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._jAbsoluteValueFilter).addContainerGap(17, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jApplyFilterButton, -2, -1, -2).addComponent(this._jTargetValueLabel).addComponent(this._jTargetValueCombo, -2, -1, -2).addComponent(this.jBtnTargetEdit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jFetchSizeLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE))));
        groupLayout.linkSize(1, this.jSingValueLbl, this.jSingValueLbl1);
    }

    private void jBtnTargetEditActionPerformed(ActionEvent actionEvent) {
        this.renameFeature(this._jTargetValueCombo);
    }

    @Override
    protected JSpinner getFetchSizeComponent() {
        return this._jFetchSize;
    }

    @Override
    protected JCheckBox getAbsoluteValueComponent() {
        return this._jAbsoluteValueFilter;
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jSingValueLbl, (Component)this.jSingValueLbl1, (String)CoefficientsLrb.get("PCA_EIGENVALUE"));
        this.jSingValueLbl.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("PCA_EIGENVALUE"));
        this.jSingValueLbl.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("PCA_EIGENVALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this._jTargetValueLabel, this._jTargetValueCombo, (String)CoefficientsLrb.get("FEATURE_VALUE"));
        this._jTargetValueLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FEATURE_VALUE"));
        this._jTargetValueLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FEATURE_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jBtnTargetEdit, (String)CoefficientsLrb.get("FEATURE_EDIT"));
        this.jBtnTargetEdit.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FEATURE_EDIT"));
        this.jBtnTargetEdit.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FEATURE_EDIT_ADA"));
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(CoefficientsLrb.get("FETCH_SIZE_ADA") + "\n" + CoefficientsLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1000));
        ResourceUtils.resButton((AbstractButton)this._jAbsoluteValueFilter, (String)CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
        this._jAbsoluteValueFilter.setToolTipText(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
    }

    @Override
    public void initUI() {
        this.setLocale(this._jFetchSize, Locale.getDefault());
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PCACoefficientFilterPanel.this._jApplyFilterButton_actionPerformed(actionEvent);
            }
        });
        this._jAbsoluteValueFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PCACoefficientFilterPanel.this._jAbsoluteValueFilter_actionPerformed(actionEvent);
            }
        });
        CoefficientItemTableModel coefficientItemTableModel = new CoefficientItemTableModel();
        this._state.setFilterItemTableModel(coefficientItemTableModel);
        this._jItemFilterTable.setModel((TableModel)((Object)coefficientItemTableModel));
        this.enableControls(false);
        this._mainPanel.addDataMinerViewListener(new DataMinerViewListenerAdapter(){

            @Override
            public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
                PCACoefficientFilterPanel.this.enableControls(true);
            }

            @Override
            public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
                PCACoefficientFilterPanel.this.enableControls(false);
            }
        });
        this._jTargetValueCombo.setRenderer(new ComboBoxListRenderer());
        this._jTargetValueCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PCACoefficientFilterPanel.this._jTargetValueCombo_actionPerformed(actionEvent);
            }
        });
        this._jTargetValueCombo.setModel(new DefaultComboBoxModel());
    }

    @Override
    public void setupUI(CoefficientFilterSetting coefficientFilterSetting) {
        this._coefFilterSetting = coefficientFilterSetting;
        this.loadStateAttributes();
        this.enableControls(true);
        this.setLoaded(true);
    }

    public void updateInput() throws Exception {
        Number number = this.getNumber(this._jFetchSize);
        this._coefFilterSetting.setFetchSize(number.intValue());
        this._coefFilterSetting.setUseFilterSpecification(false);
    }

    @Override
    protected void enableControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
        this._jFetchSize.setEnabled(bl);
        this._jFetchSizeLabel.setEnabled(bl);
        this._jTargetValueCombo.setEnabled(bl);
        this.jBtnTargetEdit.setEnabled(bl);
    }

    public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
        this._jApplyFilterButton.setEnabled(true);
        if (!this.isLoaded() && this._consumerView != null) {
            this.setupUIDetail();
        }
    }

    public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
        this._jApplyFilterButton.setEnabled(false);
    }

    @Override
    protected void loadStateAttributes() {
        if (this._coefFilterSetting.getViewerState() != null) {
            this.setNumber(this._jFetchSize, this._modelViewerPrefenceSettings.getFetchSizeOtherModels());
            this._jAbsoluteValueFilter.setSelected(this._coefFilterSetting.getFilterAndSortByAbsolute());
        }
    }

    private void _jTargetValueCombo_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this._state.setSelectedTargetClass(this._jTargetValueCombo.getSelectedItem());
        this.prepareReload();
    }

    private void _jAbsoluteValueFilter_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this._state.setSortByAbsoluteValue(this._jAbsoluteValueFilter.isSelected());
        this._coefFilterSetting.setFilterByAbsolute(this._jAbsoluteValueFilter.isSelected());
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        try {
            this._jApplyFilterButton.setEnabled(false);
            GeneralCoefficientFilterPanel.ValidateUpdateState validateUpdateState = new GeneralCoefficientFilterPanel.ValidateUpdateState();
            validateUpdateState.setTitle(CoefficientsLrb.get("FILTER_PROCESS_TITLE"));
            validateUpdateState.setMessage(CoefficientsLrb.get("FILTER_PROCESS_MESG"));
            validateUpdateState.setCancelable(false);
            validateUpdateState.start(true);
            if (validateUpdateState.getException() != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)validateUpdateState.getException(), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
                this.enableControls(true);
            }
            if (validateUpdateState.getValidation()) {
                this._mainPanel.setFilterState(this._coefFilterSetting);
            } else {
                this.enableControls(true);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            this.enableControls(true);
        }
    }

    @Override
    public void updateTarget() {
        this._jTargetValueCombo.setModel(new DefaultComboBoxModel<Object>(this._state.getTargetPredictions()));
        this._jTargetValueCombo.setSelectedItem(this._state.getSelectedTargetClass());
        Double d = this._state.getFeatureIdSingularValue(this._state.getSelectedTargetClass());
        String string = this._labelNumericalFormat.format(d);
        this.jSingValueLbl1.setText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameFeature(JComboBox<Object> jComboBox) {
        String string = jComboBox.getSelectedItem().toString();
        RenameFeaturePanel renameFeaturePanel = new RenameFeaturePanel(this._context, this._state, string);
        if (renameFeaturePanel.showAsDialog(this)) {
            Cursor cursor = this._mainPanel.getCursor();
            try {
                this._mainPanel.setCursor(Cursor.getPredefinedCursor(3));
                String string2 = this._state.renameFeatureLabel(renameFeaturePanel.getCurrentName(), string);
                this._state.reloadFeatureValues(new PartitionVO("", ""));
                jComboBox.setModel(new DefaultComboBoxModel<Object>(this._state.getTargetPredictions()));
                jComboBox.getModel().setSelectedItem(string2);
                CoefficientEditor coefficientEditor = (CoefficientEditor)this._mainPanel.getEditor();
                RefreshController.getInstance().forceRefreshInSiblingEditors(coefficientEditor.getParentNodeId(), coefficientEditor);
                this._mainPanel.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
            }
            catch (Exception exception) {
                try {
                    if (exception.getMessage().equals(CoefficientsLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"))) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)CoefficientsLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"), (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_TITLE"), null);
                    } else {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_TITLE"), (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_MESG"), null);
                    }
                    this._mainPanel.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                }
                catch (Throwable throwable) {
                    this._mainPanel.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
            }
        }
    }

    public void reload(PartitionVO partitionVO) {
        ReLoadUI reLoadUI = new ReLoadUI(partitionVO);
        reLoadUI.execute();
    }

    private class ReLoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;
        PartitionVO pvo = new PartitionVO("", "");

        public ReLoadUI(PartitionVO partitionVO) {
            this.pvo = partitionVO;
        }

        protected Object doInBackground() throws Exception {
            try {
                PCACoefficientFilterPanel.this._state.reloadFeatureValues(this.pvo);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return PCACoefficientFilterPanel.this._state;
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    PCACoefficientFilterPanel.this._jTargetValueCombo.setModel(new DefaultComboBoxModel<Object>(PCACoefficientFilterPanel.this._state.getTargetPredictions()));
                }
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            finally {
                if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)CoefficientsLrb.get("ERROR_RELOADING_FEATURES_TITLE"), (String)CoefficientsLrb.get("ERROR_RELOADING_FEATURES_MSG"), null);
                }
                if (PCACoefficientFilterPanel.this.overLayPanel != null) {
                    PCACoefficientFilterPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

