/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.util.Comparator;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.server.model.SVDCoefficientRowData;
import oracle.dmt.dataminer.utils.comparator.AbsoluteNumberComparator;
import oracle.dmt.dataminer.utils.comparator.NumberComparator;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class PCACoefViewerTableModel
extends GenericBaseTableModel {
    private static final String[] COLUMN_NAMES = new String[]{CoefficientsLrb.get("ATTRIBUTE_COLUMN"), CoefficientsLrb.get("SVD_SINGULAR_VALUE_COLUMN")};
    public static final int ATTRIBUTE = 0;
    public static final int SINGULAR_VALUE = 1;
    private boolean _absoluteSort = false;
    private Vector<SVDCoefficientRowData> _data = new Vector(1000, 500);

    public PCACoefViewerTableModel() {
        this.setColumnIdentifiers(COLUMN_NAMES);
        this.setRowCount(0);
    }

    public PCACoefViewerTableModel(Vector<SVDCoefficientRowData> vector) {
        this.setColumnIdentifiers(COLUMN_NAMES);
        this._data = vector;
        this.setRowCount(vector.size());
    }

    public void addRows(Vector<SVDCoefficientRowData> vector) {
        for (SVDCoefficientRowData sVDCoefficientRowData : vector) {
            this.getDataVector().add(sVDCoefficientRowData);
        }
    }

    public int getRowCount() {
        return this._data == null ? 0 : this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public SVDCoefficientRowData getRow(int n) {
        return this._data.get(n);
    }

    public void addSelection(PCACoefViewerTableModel pCACoefViewerTableModel, int[] nArray) {
        Vector<SVDCoefficientRowData> vector = pCACoefViewerTableModel.getDataVector();
        SVDCoefficientRowData sVDCoefficientRowData = null;
        for (int i = 0; i < nArray.length; ++i) {
            sVDCoefficientRowData = vector.elementAt(nArray[i]);
            this._data.add(sVDCoefficientRowData);
        }
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Vector<SVDCoefficientRowData> getDataVector() {
        return this._data;
    }

    public void removeSelectedRows(int[] nArray) {
        Vector<SVDCoefficientRowData> vector = new Vector<SVDCoefficientRowData>();
        SVDCoefficientRowData sVDCoefficientRowData = null;
        for (int i = 0; i < nArray.length; ++i) {
            sVDCoefficientRowData = this._data.elementAt(nArray[i]);
            vector.add(sVDCoefficientRowData);
        }
        this._data.removeAll(vector);
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Comparator getColumnSortComparator(int n) {
        if (n == 1) {
            if (this._absoluteSort) {
                return AbsoluteNumberComparator.getComparator();
            }
            return NumberComparator.getComparator();
        }
        return super.getColumnSortComparator(n);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        SVDCoefficientRowData sVDCoefficientRowData = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = sVDCoefficientRowData.getAttributeFullName();
                break;
            }
            case 1: {
                object = sVDCoefficientRowData.getSingularValue();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return object == null ? " " : object;
    }

    public void setAbsoluteValueSort(boolean bl) {
        this._absoluteSort = bl;
    }

    public boolean getAbsoluteValueSort() {
        return this._absoluteSort;
    }

    public void addRow(SVDCoefficientRowData sVDCoefficientRowData) {
        this._data.add(sVDCoefficientRowData);
    }
}

