/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.util.Vector;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.server.model.CoefficientBaseData;
import oracle.dmt.dataminer.server.model.Model;
import oracle.ide.Context;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class CoefficientItemTableModel
extends GenericBaseTableModel {
    private Vector<CoefficientBaseData> _data = new Vector(1000, 500);
    private static final int COLUMN_COUNT = 2;
    public static final int NAME = 0;
    public static final int VALUE = 1;
    private String[] _columnNames = new String[]{CoefficientsLrb.get("ADD_ITEM_NAME_COLUMN"), CoefficientsLrb.get("ADD_ITEM_VALUE_COLUMN")};

    public CoefficientItemTableModel() {
        this.setColumnIdentifiers(this._columnNames);
        this.setRowCount(0);
        this.setColumnCount(2);
    }

    public CoefficientItemTableModel(Vector<? extends CoefficientBaseData> vector) {
        this.setColumnIdentifiers(this._columnNames);
        this._data = new Vector<CoefficientBaseData>(vector);
        this.setRowCount(vector.size());
        this.setColumnCount(2);
    }

    public CoefficientItemTableModel(Context context, Model model, CoefficientItemTableModel coefficientItemTableModel) {
        this.setColumnIdentifiers(this._columnNames);
        this.setRowCount(0);
        this.setColumnCount(2);
    }

    public void load() throws Exception {
    }

    public int getRowCount() {
        return this._data != null ? this._data.size() : 0;
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public Vector<CoefficientBaseData> getDataVector() {
        return this._data;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        CoefficientBaseData coefficientBaseData = this._data.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = coefficientBaseData.getAttributeFullName();
                break;
            }
            case 1: {
                if (coefficientBaseData != null && coefficientBaseData.isNameSubnameValueSort()) {
                    string = coefficientBaseData.getValue();
                    break;
                }
                string = "";
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing items";
                break;
            }
        }
        return string;
    }

    public void removeSelectedRows(int[] nArray) {
        Vector<CoefficientBaseData> vector = new Vector<CoefficientBaseData>();
        CoefficientBaseData coefficientBaseData = null;
        for (int i = 0; i < nArray.length; ++i) {
            coefficientBaseData = this._data.elementAt(nArray[i]);
            vector.add(coefficientBaseData);
        }
        this._data.removeAll(vector);
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public TableModel getModel() {
        return this;
    }
}

