/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.controls.renderers.ComboBoxListRenderer;
import oracle.dmt.dataminer.filter.FilterConsumer;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientItemTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoefficientFilterPanel;
import oracle.dmt.dataminer.mviewer.coefficients.RenameFeaturePanel;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.workflow.DataMinerViewListenerAdapter;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;

public class CoefficientFilterPanel
extends GeneralCoefficientFilterPanel {
    private static final Logger theLogger = Logger.getLogger(CoefficientFilterPanel.class.getName());
    private JCheckBox _jAbsoluteValueFilter;
    private JButton _jApplyFilterButton;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private JComboBox<Object> _jTargetValueCombo;
    private JLabel _jTargetValueLabel;
    private JButton jBtnTargetEdit;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar1;

    private CoefficientFilterPanel() {
    }

    public CoefficientFilterPanel(CoefViewerMainPanel coefViewerMainPanel, Context context, CoefViewerState coefViewerState) {
        try {
            this._mainPanel = coefViewerMainPanel;
            this._context = context;
            this._state = coefViewerState;
            this.initComponents();
            this.initRes();
            this.initUI();
            this.initializeUIState();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public static CoefficientFilterPanel createCoefficientFilterPanel() {
        CoefficientFilterPanel coefficientFilterPanel = new CoefficientFilterPanel();
        coefficientFilterPanel.initComponents();
        coefficientFilterPanel.initRes();
        coefficientFilterPanel.initUI();
        return coefficientFilterPanel;
    }

    private void initComponents() {
        this._jTargetValueLabel = new JLabel();
        this._jTargetValueCombo = new JComboBox();
        this.jBtnTargetEdit = new JButton();
        this._jAbsoluteValueFilter = new JCheckBox();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSize = new JSpinner();
        this._jApplyFilterButton = new JButton();
        this.modelViewerPartitionToolbar1 = new ModelViewerPartitionToolbar();
        this._jTargetValueLabel.setText("Target Value:");
        this.jBtnTargetEdit.setText("Edit");
        this.jBtnTargetEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoefficientFilterPanel.this.jBtnTargetEditActionPerformed(actionEvent);
            }
        });
        this._jAbsoluteValueFilter.setText("Sort by absolute value");
        this._jAbsoluteValueFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jAbsoluteValueFilter.setMargin(new Insets(0, 0, 0, 0));
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jFetchSizeLabel.setMaximumSize(new Dimension(64, 14));
        this._jFetchSizeLabel.setMinimumSize(new Dimension(64, 14));
        this._jFetchSizeLabel.setPreferredSize(new Dimension(64, 14));
        this._jFetchSize.setMaximumSize(new Dimension(87, 20));
        this._jFetchSize.setMinimumSize(new Dimension(87, 20));
        this._jFetchSize.setPreferredSize(new Dimension(87, 20));
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jTargetValueLabel, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetValueCombo, -2, 173, -2).addGap(0, 0, 0).addComponent(this.jBtnTargetEdit).addGap(18, 18, 18).addComponent(this._jAbsoluteValueFilter, -2, 227, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.modelViewerPartitionToolbar1, -1, 595, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._jFetchSizeLabel, -2, 96, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jFetchSize, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this._jApplyFilterButton, GroupLayout.Alignment.LEADING, -1, 110, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jApplyFilterButton, -2, -1, -2).addComponent(this._jTargetValueLabel).addComponent(this._jTargetValueCombo, -2, -1, -2).addComponent(this.jBtnTargetEdit).addComponent(this._jAbsoluteValueFilter)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jFetchSizeLabel, -2, -1, -2)).addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
    }

    private void jBtnTargetEditActionPerformed(ActionEvent actionEvent) {
        this.renameFeature(this._jTargetValueCombo);
    }

    @Override
    protected JSpinner getFetchSizeComponent() {
        return this._jFetchSize;
    }

    @Override
    protected JCheckBox getAbsoluteValueComponent() {
        return this._jAbsoluteValueFilter;
    }

    @Override
    public void initRes() {
        if (this.isNMF() || this.isSVD()) {
            ResourceUtils.resLabel((JLabel)this._jTargetValueLabel, this._jTargetValueCombo, (String)CoefficientsLrb.get("FEATURE_VALUE"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FEATURE_VALUE"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FEATURE_VALUE_ADA"));
            ResourceUtils.resButton((AbstractButton)this.jBtnTargetEdit, (String)CoefficientsLrb.get("FEATURE_EDIT"));
            this.jBtnTargetEdit.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FEATURE_EDIT"));
            this.jBtnTargetEdit.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FEATURE_EDIT_ADA"));
        } else if (!this.isAnomaly()) {
            ResourceUtils.resLabel((JLabel)this._jTargetValueLabel, this._jTargetValueCombo, (String)CoefficientsLrb.get("TARGET_VALUE"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("TARGET_VALUE"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("TARGET_VALUE_ADA"));
        } else {
            ResourceUtils.resLabel((JLabel)this._jTargetValueLabel, this._jTargetValueCombo, (String)CoefficientsLrb.get("PREDICTIVE_CLASS"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("PREDICTIVE_CLASS"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("PREDICTIVE_CLASS_ADA"));
        }
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(CoefficientsLrb.get("FETCH_SIZE_ADA") + "\n" + CoefficientsLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1000));
        ResourceUtils.resButton((AbstractButton)this._jAbsoluteValueFilter, (String)CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
        this._jAbsoluteValueFilter.setToolTipText(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
    }

    @Override
    public void initUI() {
        this.setLocale(this._jFetchSize, Locale.getDefault());
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoefficientFilterPanel.this._jApplyFilterButton_actionPerformed(actionEvent);
            }
        });
        this._jAbsoluteValueFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoefficientFilterPanel.this._jAbsoluteValueFilter_actionPerformed(actionEvent);
            }
        });
        CoefficientItemTableModel coefficientItemTableModel = new CoefficientItemTableModel();
        this._state.setFilterItemTableModel(coefficientItemTableModel);
        this._jItemFilterTable.setModel((TableModel)((Object)coefficientItemTableModel));
        this.enableControls(false);
        this._mainPanel.addDataMinerViewListener(new DataMinerViewListenerAdapter(){

            @Override
            public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
                CoefficientFilterPanel.this.enableControls(true);
            }

            @Override
            public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
                CoefficientFilterPanel.this.enableControls(false);
            }
        });
        this._jTargetValueCombo.setRenderer(new ComboBoxListRenderer());
        this._jTargetValueCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoefficientFilterPanel.this._jTargetValueCombo_actionPerformed(actionEvent);
            }
        });
        if (this.isAnomaly()) {
            this._jTargetValueCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{CoefViewerState.TYPICAL, CoefViewerState.OUTLIER}));
            this._jTargetValueCombo.setSelectedItem(CoefViewerState.TYPICAL);
            this._state.setPredictiveValue(CoefViewerState.TYPICAL);
        } else {
            this._jTargetValueCombo.setModel(new DefaultComboBoxModel());
        }
        if (this.isNB() || this.isNMF()) {
            this._jAbsoluteValueFilter.setVisible(false);
        }
        this.jBtnTargetEdit.setVisible(this.isNMF());
        this.resizePartitionToolbar();
    }

    public void resizePartitionToolbar() {
        if (this._mainPanel.isModelParitioned()) {
            this.modelViewerPartitionToolbar1.setEditor(this._mainPanel.getEditor(), this._mainPanel.getPartitionVO());
            this.modelViewerPartitionToolbar1.setVisible(true);
            for (Component component : this.modelViewerPartitionToolbar1.getComponents()) {
                component.setMaximumSize(component.getPreferredSize());
                component.setSize(component.getPreferredSize());
            }
        } else {
            for (Component component : this.modelViewerPartitionToolbar1.getComponents()) {
                component.setMaximumSize(new Dimension(0, 0));
            }
        }
        ((GroupLayout)this.getLayout()).invalidateLayout(this);
    }

    public String getSelectedParitionId() {
        if (this._mainPanel.isModelParitioned()) {
            return this.modelViewerPartitionToolbar1.getSelectedPartitionID();
        }
        return "";
    }

    public PartitionVO getPartitionVO() {
        return this.modelViewerPartitionToolbar1.getPartitionVO();
    }

    private void initializeUIState() throws Exception {
        this._coefFilterSetting = new CoefficientFilterSetting();
        this.loadStateAttributes();
    }

    public void unloadUI() throws Exception {
        this.enableControls(false);
        if (this._consumerView == null) {
            return;
        }
        this.updateInput();
        ((FilterConsumer)this._consumerView).setCachedFilterState(this._coefFilterSetting);
        this.clearState();
        this.setLoaded(false);
    }

    public void updateInput() throws Exception {
        Number number = this.getNumber(this._jFetchSize);
        this._coefFilterSetting.setFetchSize(number.intValue());
        this._coefFilterSetting.setUseFilterSpecification(false);
    }

    private void clearState() {
        this._consumerView = null;
        this.resetUIAttributes();
        this._jApplyFilterButton.setEnabled(false);
        this._coefFilterSetting = null;
    }

    private void resetUIAttributes() {
        this.setNumber(this._jFetchSize, 1000);
    }

    @Override
    protected void enableControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
        this._jFetchSize.setEnabled(bl);
        this._jFetchSizeLabel.setEnabled(bl);
        this._jAbsoluteValueFilter.setEnabled(bl);
        this._jTargetValueCombo.setEnabled(bl);
        this.jBtnTargetEdit.setEnabled(bl);
    }

    public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
        this._jApplyFilterButton.setEnabled(true);
        if (!this.isLoaded() && this._consumerView != null) {
            this.setupUIDetail();
        }
    }

    public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
        this._jApplyFilterButton.setEnabled(false);
    }

    @Override
    protected void loadStateAttributes() {
        if (this._coefFilterSetting.getViewerState() != null) {
            this.setNumber(this._jFetchSize, this._modelViewerPrefenceSettings.getFetchSizeOtherModels());
            this._jAbsoluteValueFilter.setSelected(this._coefFilterSetting.getViewerState().getSortByAbsoluteValue());
        }
    }

    private void _jTargetValueCombo_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        if (this.isAnomaly()) {
            this._state.setPredictiveValue(this._jTargetValueCombo.getSelectedItem().toString());
        } else {
            this._state.setSelectedTargetClass(this._jTargetValueCombo.getSelectedItem());
        }
        this.prepareReload();
    }

    private void _jAbsoluteValueFilter_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this._state.setSortByAbsoluteValue(this._jAbsoluteValueFilter.isSelected());
        this._coefFilterSetting.setFilterByAbsolute(this._jAbsoluteValueFilter.isSelected());
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        try {
            this._jApplyFilterButton.setEnabled(false);
            GeneralCoefficientFilterPanel.ValidateUpdateState validateUpdateState = new GeneralCoefficientFilterPanel.ValidateUpdateState(this);
            validateUpdateState.setTitle(CoefficientsLrb.get("FILTER_PROCESS_TITLE"));
            validateUpdateState.setMessage(CoefficientsLrb.get("FILTER_PROCESS_MESG"));
            validateUpdateState.setCancelable(false);
            validateUpdateState.start(true);
            if (validateUpdateState.getException() != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)validateUpdateState.getException(), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
                this.enableControls(true);
            }
            if (validateUpdateState.getValidation()) {
                this._mainPanel.setFilterState(this._coefFilterSetting);
            } else {
                this.enableControls(true);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            this.enableControls(true);
        }
    }

    @Override
    public void updateTarget() {
        if (this.isAnomaly()) {
            this._jTargetValueCombo.setSelectedItem(this._state.getPredictiveValue());
            return;
        }
        this._jTargetValueCombo.setModel(new DefaultComboBoxModel<Object>(this._state.getTargetPredictions()));
        this._jTargetValueCombo.setSelectedItem(this._state.getSelectedTargetClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameFeature(JComboBox<Object> jComboBox) {
        String string = jComboBox.getSelectedItem().toString();
        RenameFeaturePanel renameFeaturePanel = new RenameFeaturePanel(this._context, this._state, string);
        if (renameFeaturePanel.showAsDialog(this)) {
            Cursor cursor = this._mainPanel.getCursor();
            try {
                this._mainPanel.setCursor(Cursor.getPredefinedCursor(3));
                String string2 = this._state.renameFeatureLabel(renameFeaturePanel.getCurrentName(), string);
                this._state.reloadFeatureValues(this.modelViewerPartitionToolbar1.getPartitionVO());
                jComboBox.setModel(new DefaultComboBoxModel<Object>(this._state.getTargetPredictions()));
                jComboBox.getModel().setSelectedItem(string2);
                this._mainPanel.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
            }
            catch (Exception exception) {
                try {
                    if (exception.getMessage().equals(CoefficientsLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"))) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)CoefficientsLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"), (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_TITLE"), null);
                    } else {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_TITLE"), (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_MESG"), null);
                    }
                    this._mainPanel.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                }
                catch (Throwable throwable) {
                    this._mainPanel.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
            }
        }
    }
}

