/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import java.awt.Component;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeNode;
import oracle.dmt.dataminer.server.model.CentroidRowData;
import oracle.dmt.dataminer.server.model.PredicateRowData;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.config.Preferences;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.ui.table.GenericTableModel;

public class ClusterCentroidPane
extends JPanel
implements DataminerGUIPanel {
    private static volatile List<RowSorter.SortKey> sortKeys = null;
    private static final ModelViewerPreferenceSettings modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private ClusTreeNode treeNode;
    private RowSorterListener sorterListener;
    private JScrollPane scrollPane;
    private DataMinerTable valuesTable;
    private static final int ATTRIBUTE = 0;
    private static final int IMPORTANCE = 1;
    private static final int MODE = 2;
    private static final int MEAN = 3;
    private static final int VARIANCE = 4;
    private static final int SUPPORT = 5;
    private static final int COLUMN_COUNT = 6;

    public ClusterCentroidPane(ClusTreeNode clusTreeNode) {
        this.treeNode = clusTreeNode;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.valuesTable = new DataMinerTable();
        this.valuesTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Value", "Count", "% Percent"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Double.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.scrollPane.setViewportView((Component)((Object)this.valuesTable));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 475, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING, -1, 132, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        modelViewerPrefenceSettings.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
                for (int i = 0; i < changeInfoArray.length; ++i) {
                    ChangeInfo changeInfo = changeInfoArray[i];
                    if (!changeInfo.getPropertyName().equals("numerical_precision_level") && !changeInfo.getPropertyName().equals("percentage_precision_level")) continue;
                    ClusterCentroidPane.this.initTable();
                    break;
                }
            }
        });
        this.valuesTable.setSortColumn(1, true);
        this.valuesTable.setColumnSelectorAvailable(true);
        this.valuesTable.setAutoResizeMode(3);
        this.initTable();
    }

    private void initTable() {
        String[] stringArray = new String[]{ClusteringTreeEditorLrb.get("CENTROID_ATTR_COLUMN"), ClusteringTreeEditorLrb.get("CONFIDENCE_COLUMN"), ClusteringTreeEditorLrb.get("MODE_COLUMN"), ClusteringTreeEditorLrb.get("MEAN_COLUMN"), ClusteringTreeEditorLrb.get("VARIANCE_COLUMN"), ClusteringTreeEditorLrb.get("ATTRIBUTE_SUPPORT")};
        this.valuesTable.setModel(new ValuesTableModel(this.treeNode.getData().getCentroid(), this.treeNode.getTopItems(), stringArray));
        NumberFormat numberFormat = NumericFormat.getInstance(true, modelViewerPrefenceSettings.getPercentagePrecisionLevel(), modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 1);
        this.valuesTable.getColumnModel().getColumn(1).setCellRenderer(new HistogramBarRenderer(1L, true, numberFormat));
        this.valuesTable.getColumnModel().getColumn(3).setCellRenderer(new NumberCellRenderer());
        this.valuesTable.getColumnModel().getColumn(4).setCellRenderer(new NumberCellRenderer());
        this.valuesTable.getColumnModel().getColumn(5).setCellRenderer(new NumberCellRenderer());
        this.valuesTable.setRolloverHighlightingEnabled(false);
        TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(this.valuesTable.getModel());
        tableRowSorter.setSortKeys(ClusterCentroidPane.getSortKeys());
        this.valuesTable.setRowSorter(tableRowSorter);
        if (this.sorterListener == null) {
            this.sorterListener = new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent rowSorterEvent) {
                    Object object = rowSorterEvent.getSource();
                    sortKeys = ((RowSorter)object).getSortKeys();
                }
            };
            this.valuesTable.getRowSorter().addRowSorterListener(this.sorterListener);
        }
        this.valuesTable.setDragEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<RowSorter.SortKey> getSortKeys() {
        if (sortKeys != null) return sortKeys;
        Class<ClusterCentroidPane> clazz = ClusterCentroidPane.class;
        synchronized (ClusterCentroidPane.class) {
            if (sortKeys != null) return sortKeys;
            sortKeys = new ArrayList<RowSorter.SortKey>();
            sortKeys.add(new RowSorter.SortKey(1, SortOrder.DESCENDING));
            // ** MonitorExit[var0] (shouldn't be in output)
            return sortKeys;
        }
    }

    private static class ValuesTableModel
    extends DefaultTableModel
    implements GenericTableModel {
        private Vector<CentroidRowData> _data;
        private Map<String, PredicateRowData> _topItems;

        public ValuesTableModel(Vector<CentroidRowData> vector, Map<String, PredicateRowData> map, String[] stringArray) {
            this._data = vector;
            this._topItems = map;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this._data.size());
            this.setColumnCount(6);
        }

        public int getColumnAlignment(int n) {
            return 2;
        }

        public boolean canHide(int n) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 3) {
                return Double.class;
            }
            if (n == 4) {
                return Double.class;
            }
            if (n == 1) {
                return Double.class;
            }
            if (n == 5) {
                return Double.class;
            }
            return String.class;
        }

        public void reload(Vector<CentroidRowData> vector) {
            this._data = vector;
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            CentroidRowData centroidRowData = this._data.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = ClusTreeNode.getQualifiedAttributeName(centroidRowData);
                    break;
                }
                case 3: {
                    object = centroidRowData.getMean();
                    break;
                }
                case 4: {
                    object = centroidRowData.getVariance();
                    break;
                }
                case 2: {
                    object = centroidRowData.getMode();
                    break;
                }
                case 1: {
                    String string = ClusTreeNode.getQualifiedAttributeName(centroidRowData);
                    PredicateRowData predicateRowData = this._topItems.get(string);
                    Double d = predicateRowData != null ? predicateRowData.getAttribute_confidence() : 0.0;
                    object = d;
                    break;
                }
                case 5: {
                    String string = ClusTreeNode.getQualifiedAttributeName(centroidRowData);
                    PredicateRowData predicateRowData = this._topItems.get(string);
                    Double d = predicateRowData != null ? predicateRowData.getAttribute_support() : 0.0;
                    object = d;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        public Vector<CentroidRowData> getDataList() {
            return this._data;
        }
    }
}

