/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.component;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentModelRow;
import oracle.dmt.dataminer.mviewer.clustering.component.ComponentLrb;
import oracle.dmt.dataminer.utils.comparator.NumberComparator;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ClusterComponentTableModel
extends GenericBaseTableModel {
    static Vector<String> _colNames = new Vector();
    public static final int _COLUMN_NAME = 0;
    public static final int _COLUMN_DISTRIBUTION = 1;
    public static final int _COLUMN_MEAN = 2;
    public static final int _COLUMN_VARIANCE = 3;
    private Vector<ClusterComponentModelRow> _data;

    public ClusterComponentTableModel() {
        ClusterComponentModelRow clusterComponentModelRow = new ClusterComponentModelRow(ComponentLrb.get("CLUSTER_COMPONENT_EDITOR_LOADING"));
        Vector<ClusterComponentModelRow> vector = new Vector<ClusterComponentModelRow>();
        vector.add(clusterComponentModelRow);
        this.setDataVector(vector);
        this.setColumnIdentifiers(_colNames);
    }

    private ClusterComponentTableModel(Vector<ClusterComponentModelRow> vector) {
        Object[] objectArray = _colNames.toArray(new String[_colNames.size()]);
        this.setDataVector(vector);
        this.setColumnIdentifiers(objectArray);
    }

    public void loadData(List<ClusterComponentModelRow> list) {
        assert (list != null) : "Input data is missing.";
        this.clear();
        this.setDataList(list);
        this.fireTableDataChanged();
    }

    public void loadStatus() {
        this.clear();
        ClusterComponentModelRow clusterComponentModelRow = new ClusterComponentModelRow(ComponentLrb.get("CLUSTER_COMPONENT_EDITOR_LOADING"));
        Vector<ClusterComponentModelRow> vector = new Vector<ClusterComponentModelRow>();
        vector.add(clusterComponentModelRow);
        this.setDataVector(vector);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public void clear() {
        for (ClusterComponentModelRow clusterComponentModelRow : this._data) {
            clusterComponentModelRow.setGraphDataModel(null);
            clusterComponentModelRow.setFrequencyValues(null);
        }
        this._data.clear();
    }

    public void setDataVector(Vector<ClusterComponentModelRow> vector) {
        this._data = vector;
        this.setRowCount(this._data.size());
    }

    public void setDataList(List<ClusterComponentModelRow> list) {
        this._data.addAll(list);
        this.setRowCount(this._data.size());
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        ClusterComponentModelRow clusterComponentModelRow = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = clusterComponentModelRow.getAttributeName();
                break;
            }
            case 2: {
                if (null == clusterComponentModelRow.getMeanValue()) break;
                object = clusterComponentModelRow.getMeanValue();
                break;
            }
            case 3: {
                if (null == clusterComponentModelRow.getCovarianceValue()) break;
                object = clusterComponentModelRow.getCovarianceValue();
                break;
            }
            case 1: {
                object = clusterComponentModelRow.getGraphDataModel();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing cluster details";
                break;
            }
        }
        return object != null ? object : "";
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return NumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }

    public ClusterComponentTableModel getFilteredStatistics(String string, int n) throws Exception {
        Vector<ClusterComponentModelRow> vector = null;
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Vector<ClusterComponentModelRow> vector2 = this.getDataVector();
        vector = new Vector<ClusterComponentModelRow>();
        Iterator<ClusterComponentModelRow> iterator = vector2.iterator();
        ClusterComponentModelRow clusterComponentModelRow = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            clusterComponentModelRow = iterator.next();
            if (bl) {
                bl2 = true;
            } else {
                String string2 = null;
                switch (n) {
                    case 0: {
                        string2 = clusterComponentModelRow.getAttributeName();
                        break;
                    }
                    default: {
                        assert (false) : "Invalid table filter category.";
                        string2 = clusterComponentModelRow.getAttributeName();
                    }
                }
                if (string2 == null) {
                    string2 = "";
                }
                bl2 = searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector.add(clusterComponentModelRow);
        }
        return new ClusterComponentTableModel(vector);
    }

    public Vector<ClusterComponentModelRow> getDataVector() {
        return this._data;
    }

    public static Vector<String> getColNames() {
        return _colNames;
    }

    public static String getColName(int n) {
        return _colNames.get(n);
    }

    static {
        _colNames.add(ComponentLrb.get("DETAIL_TABLE_COLUMN_NAME"));
        _colNames.add(ComponentLrb.get("DETAIL_TABLE_COLUMN_DISTRIBUTION"));
        _colNames.add(ComponentLrb.get("DETAIL_TABLE_COLUMN_MEAN"));
        _colNames.add(ComponentLrb.get("DETAIL_TABLE_COLUMN_VARIANCE"));
    }
}

