/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.generated.server.DmHistogramBin;
import oracle.dmt.dataminer.generated.server.DmHistograms;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetails;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModel;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModelRow;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.StateChangeListener;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.ClusteringModelNode;
import oracle.dmt.dataminer.server.model.Clustering;
import oracle.dmt.dataminer.server.model.ClusteringDetailRowShort;
import oracle.dmt.dataminer.server.model.ClusteringEM;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.dmt.dataminer.server.model.ClusteringKM;
import oracle.dmt.dataminer.server.model.ClusteringOC;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.comparator.LetterNumberComparator;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;

public class SingleClusterViewerState
extends BaseViewerState
implements GraphModelProvider,
ClusterDetails {
    private boolean _loaded;
    private String _modelName;
    private String _userName;
    private boolean _leafsOnly = true;
    private ClusterDetailsModel _tableModel;
    private Map<String, ClusteringDetailRowShort> _clusterCountsMap;
    private ClusteringOC _modelOCClustering = null;
    private ClusteringKM _modelKMClustering = null;
    private ClusteringEM _modelEMClustering = null;
    private ClusteringFilterSetting _filterSetting;
    private String _clusterLabel = null;
    private List<String> _clusterLabels = null;
    private static int _DEPTH_RADIUS = 0;
    public static final Color _BASE_CHART_COLOR = new Color(255, 255, 153);
    private String _styleSelection = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;
    private int _depthRadius = _DEPTH_RADIUS;
    int _precisionLevelOfHistogramLabels = 5;
    boolean _maxPrecision = false;
    private StateChangeListener stateChangeListener;

    public SingleClusterViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._tableModel = new ClusterDetailsModel();
        this._loaded = false;
        this._context = context;
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "cluster_detail_help";
        return new HelpInfo(string);
    }

    public SingleClusterViewerState load(String string) throws Exception {
        this._modelViewerState1 = new ModelViewerState1(this._context);
        this._modelViewerState1.load();
        Clustering clustering = null;
        if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isClusteringModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isKmeansAlgorithm()) {
            this._modelKMClustering = clustering = new ClusteringKM(this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
        } else if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isClusteringModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isOClusterAlgorithm()) {
            clustering = new ClusteringOC(this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
            this._modelOCClustering = (ClusteringOC)clustering;
        } else if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isClusteringModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isEMAlgorithm()) {
            clustering = new ClusteringEM(this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
            this._modelEMClustering = (ClusteringEM)clustering;
        } else {
            if ("".equals(this._modelViewerState1.getOdmModel().getModelGeneralDescription().getMiningFunction())) {
                throw new Exception("ORA-40203");
            }
            throw new Exception(ClusterLrb.get("DETAIL_CLUSTER_UNRECOGNIZED_MODEL_TYPE"));
        }
        this._modelName = this._modelViewerState1.getModelName();
        this._userName = this._modelViewerState1.getUserName();
        this._filterSetting = new ClusteringFilterSetting();
        this.loadClusterNew(false, string);
        this._loaded = true;
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this._context.getNode();
        clusteringModelNode.setClusterDetails(this);
        clusteringModelNode.setClusterDetailsLoaded();
        return this;
    }

    public void reload(boolean bl, String string) throws Exception {
        this._loaded = false;
        this.loadClusterNew(bl, string);
        this._loaded = true;
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this._context.getNode();
        clusteringModelNode.setClusterDetails(this);
        clusteringModelNode.setClusterDetailsLoaded();
    }

    private void createAllGraphDataModelsTotalPopulation() throws Exception {
        Vector<ClusterDetailsModelRow> vector = this._tableModel.getDataVector();
        for (ClusterDetailsModelRow clusterDetailsModelRow : vector) {
            String string = clusterDetailsModelRow.getFullAttributeName();
            GraphDataModel graphDataModel = this.createGraphDataModelClusterPopulationGeneric(string, false);
            graphDataModel.setTitle(null);
            graphDataModel.setLegendVisible(false);
            graphDataModel.setDepthRadius(0);
            graphDataModel.setLineDataLineDisplayed(false);
            clusterDetailsModelRow.setGraphDataModel(graphDataModel);
        }
    }

    public GraphDataModel createGraphDataModelForAttribute(String string) throws Exception {
        return this.createGraphDataModelClusterPopulationGeneric(string);
    }

    private GraphDataModel createGraphDataModelClusterPopulationGeneric(String string) throws Exception {
        return this.createGraphDataModelClusterPopulationGeneric(string, true);
    }

    private GraphDataModel createGraphDataModelClusterPopulationGeneric(String string, boolean bl) throws Exception {
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 18, null, null, null);
        ClusterDetailsModelRow clusterDetailsModelRow = this._tableModel.getClusterDetailRow(string);
        DmHistograms dmHistograms = clusterDetailsModelRow.getHistogram();
        int n = 0;
        if (dmHistograms == null || dmHistograms.length() == 0) {
            return defaultGraphDataModel;
        }
        int n2 = dmHistograms.length();
        int n3 = 1;
        Object[][] objectArray = new Object[n2][n3];
        Object[] objectArray2 = new Object[n2];
        Object[] objectArray3 = new String[n3];
        for (int i = 0; i < n3; ++i) {
            BigDecimal bigDecimal;
            DmHistogramBin dmHistogramBin;
            int n4;
            objectArray3[i] = bl ? ClusterLrb.get("HISTOGRAM_Y_AXIS") : "";
            for (n4 = 0; n4 < n2; ++n4) {
                dmHistogramBin = dmHistograms.getElement(n4);
                bigDecimal = dmHistogramBin.getCount();
                n += bigDecimal.intValue();
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dmHistogramBin = dmHistograms.getElement(n4);
                bigDecimal = dmHistogramBin.getCount();
                BigDecimal bigDecimal2 = dmHistogramBin.getUpperBound();
                BigDecimal bigDecimal3 = dmHistogramBin.getLowerBound();
                int n5 = dmHistogramBin.getBinId().intValue();
                if (n5 > n2) {
                    n5 = n2;
                }
                String string2 = bigDecimal2 != null && bigDecimal3 != null ? (this._maxPrecision ? dmHistogramBin.getLabel() : this.formatLabelFromBoundaries(bigDecimal3, bigDecimal2)) : dmHistogramBin.getLabel();
                objectArray[n5 - 1][i] = this.isKmeans() ? (n == 0 ? Double.valueOf(bigDecimal.doubleValue() * 100.0) : Double.valueOf(bigDecimal.doubleValue() / (double)n * 100.0)) : Double.valueOf(bigDecimal.doubleValue() * 100.0);
                objectArray2[n5 - 1] = bl ? string2 : "";
            }
        }
        defaultGraphDataModel.addColumnLabels(objectArray2);
        defaultGraphDataModel.addRowLabels(objectArray3);
        defaultGraphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        defaultGraphDataModel.addGraphData(objectArray);
        if (bl) {
            defaultGraphDataModel.setDepthRadius(this._depthRadius);
        }
        defaultGraphDataModel.setLegendVisible(false);
        defaultGraphDataModel.setLineDataLineDisplayed(false);
        return defaultGraphDataModel;
    }

    private String formatLabelFromBoundaries(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        double d = bigDecimal.doubleValue();
        double d2 = bigDecimal2.doubleValue();
        String string = NumericFormat.format(d, true, this._precisionLevelOfHistogramLabels) + "";
        String string2 = NumericFormat.format(d2, true, this._precisionLevelOfHistogramLabels) + "";
        return string + " : " + string2;
    }

    @Override
    public GraphDataModel getGraphDataModel(int n) {
        if (this._tableModel == null) {
            return null;
        }
        Vector<ClusterDetailsModelRow> vector = this._tableModel.getDataVector();
        ClusterDetailsModelRow clusterDetailsModelRow = vector.get(n);
        GraphDataModel graphDataModel = clusterDetailsModelRow.getGraphDataModel();
        return graphDataModel;
    }

    @Override
    public String getStyleSelection() {
        return this._styleSelection;
    }

    private Map<String, ClusteringDetailRowShort> getMap() {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this._context.getNode();
        Map<String, ClusteringDetailRowShort> map = clusteringModelNode.getClusterCountsMap(this._userName, this._modelName);
        return map;
    }

    private void setMap(Map<String, ClusteringDetailRowShort> map) {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this._context.getNode();
        clusteringModelNode.setClusterCountsMap(this._userName, this._modelName, map);
    }

    private void loadClusterNew(boolean bl, String string) throws Exception {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        Vector<ClusterDetailsModelRow> vector = new Vector<ClusterDetailsModelRow>();
        if (this.isKmeans()) {
            if (this._clusterCountsMap == null) {
                this._clusterCountsMap = this.getMap();
                if (this._clusterCountsMap == null) {
                    this._clusterCountsMap = this._modelKMClustering.getTotalNumberOfModelAttributesPerCluster2(connectionFolder, this._userName, this._modelName, string);
                    this.setMap(this._clusterCountsMap);
                }
                this.loadClusterMapFromCacheNew();
                this.selectInitialClusterToLoadFirstInList();
            } else if (bl) {
                this._clusterCountsMap = this._modelKMClustering.getTotalNumberOfModelAttributesPerCluster2(connectionFolder, this._userName, this._modelName, string);
                this.setMap(this._clusterCountsMap);
                this.reloadClusterMapFromCacheNew();
            }
            vector = this._modelKMClustering.getModelAttributeDetails(this._context, this._userName, this._modelName, this._filterSetting, string);
        } else if (this.isOC()) {
            if (this._clusterCountsMap == null) {
                this._clusterCountsMap = this.getMap();
                if (this._clusterCountsMap == null) {
                    this._clusterCountsMap = this._modelOCClustering.getTotalNumberOfModelAttributesPerCluster2(connectionFolder, this._userName, this._modelName, string);
                    this.setMap(this._clusterCountsMap);
                }
                this.loadClusterMapFromCacheNew();
                this.selectInitialClusterToLoadFirstInList();
            } else if (bl) {
                this._clusterCountsMap = this._modelOCClustering.getTotalNumberOfModelAttributesPerCluster2(connectionFolder, this._userName, this._modelName, string);
                this.setMap(this._clusterCountsMap);
                this.reloadClusterMapFromCacheNew();
            }
            vector = this._modelOCClustering.getModelAttributeDetails(this._context, this._userName, this._modelName, this._filterSetting, string);
        } else if (this.isEMCluster()) {
            if (this._clusterCountsMap == null || this._clusterCountsMap.size() < 1) {
                this._clusterCountsMap = this.getMap();
                if (this._clusterCountsMap == null) {
                    this._clusterCountsMap = this._modelEMClustering.getTotalNumberOfModelAttributesPerCluster2(connectionFolder, this._userName, this._modelName, string);
                    this.setMap(this._clusterCountsMap);
                }
                this.loadClusterMapFromCacheNew();
                this.selectInitialClusterToLoadFirstInList();
            } else if (bl) {
                this._clusterCountsMap = this._modelEMClustering.getTotalNumberOfModelAttributesPerCluster2(connectionFolder, this._userName, this._modelName, string);
                this.setMap(this._clusterCountsMap);
                this.reloadClusterMapFromCacheNew();
            }
            vector = this._modelEMClustering.getModelAttributeDetails(this._context, this._userName, this._modelName, this._filterSetting, string);
        } else assert (false) : this.getClass().getName() + " not loaded.";
        this._tableModel = new ClusterDetailsModel(vector);
        this.createAllGraphDataModelsTotalPopulation();
    }

    public void selectInitialClusterToLoadByCountNew() {
        Collection<ClusteringDetailRowShort> collection = this._clusterCountsMap.values();
        String string = "";
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        for (ClusteringDetailRowShort clusteringDetailRowShort : collection) {
            if (bl) {
                bl = false;
                n2 = clusteringDetailRowShort.getAttributeCount();
                string = clusteringDetailRowShort.getClusterId();
                n = clusteringDetailRowShort.getId();
                continue;
            }
            if (clusteringDetailRowShort.getAttributeCount() >= n2) continue;
            n2 = clusteringDetailRowShort.getAttributeCount();
            string = clusteringDetailRowShort.getClusterId();
            n = clusteringDetailRowShort.getId();
        }
        this._filterSetting.setClusterId(n);
        this._clusterLabel = string;
    }

    public void selectInitialClusterToLoadFirstInList() {
        if (this._clusterLabels != null && this._clusterLabels.size() > 0) {
            this._clusterLabel = this._clusterLabels.get(0);
            ClusteringDetailRowShort clusteringDetailRowShort = this._clusterCountsMap.get(this._clusterLabel);
            this._filterSetting.setClusterId(clusteringDetailRowShort.getId());
        } else {
            this._clusterLabel = "";
        }
    }

    public void clearRows() {
        this._tableModel.clearRows();
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void setCluster_id(Integer n) {
        this._filterSetting.setClusterId(n);
    }

    public Integer getCluster_id() {
        return this._filterSetting.getClusterId();
    }

    public ClusterDetailsModel getTableModel() {
        return this._tableModel;
    }

    public int getDepthRadius() {
        return this._depthRadius;
    }

    public void setFetchSize(Integer n) {
        this._filterSetting.setFetchSize(n);
    }

    public Map<String, ClusteringDetailRowShort> getClusterLabelToIDMap() {
        return this._clusterCountsMap;
    }

    public void setLeafsOnly(boolean bl) {
        if (this.isLoaded() && this._leafsOnly != bl) {
            this._leafsOnly = bl;
            this.reloadClusterMapFromCacheNew();
            this.resetClusterIDIfNotInMapping();
        }
    }

    private void resetClusterIDIfNotInMapping() {
        Map<String, ClusteringDetailRowShort> map = this._leafsOnly ? this.getLeafsOnlyMap(this._clusterCountsMap) : this._clusterCountsMap;
        ClusteringDetailRowShort clusteringDetailRowShort = map.get(this._clusterLabel);
        if (clusteringDetailRowShort == null) {
            this.selectInitialClusterToLoadFirstInList();
        }
    }

    private void loadClusterMapFromCacheNew() {
        Map<String, ClusteringDetailRowShort> map = this._leafsOnly ? this.getLeafsOnlyMap(this._clusterCountsMap) : this._clusterCountsMap;
        this._clusterLabels = new ArrayList<String>(map.keySet());
        Collections.sort(this._clusterLabels, LetterNumberComparator.getComparator());
    }

    private void reloadClusterMapFromCacheNew() {
        ClusteringDetailRowShort clusteringDetailRowShort = this._clusterCountsMap.get(this._clusterLabel);
        this._clusterLabel = clusteringDetailRowShort != null ? clusteringDetailRowShort.getClusterId() : this._clusterLabels.get(0);
        Map<String, ClusteringDetailRowShort> map = this._leafsOnly ? this.getLeafsOnlyMap(this._clusterCountsMap) : this._clusterCountsMap;
        this._clusterLabels = new ArrayList<String>(map.keySet());
        Collections.sort(this._clusterLabels, LetterNumberComparator.getComparator());
        if (this._clusterLabel == null) {
            this._clusterLabel = this._clusterLabels.get(0);
        }
    }

    public boolean isLeafsOnly() {
        return this._leafsOnly;
    }

    public void setClusterLabel(String string) {
        this._clusterLabel = string;
    }

    public String getClusterLabel() {
        return this._clusterLabel;
    }

    public Object[] getClusterLabels() {
        return this._clusterLabels.toArray(new Object[this._clusterLabels.size()]);
    }

    public void setFilterSetting(ClusteringFilterSetting clusteringFilterSetting) {
        this._filterSetting = clusteringFilterSetting;
    }

    public ClusteringFilterSetting getFilterSetting() {
        return this._filterSetting;
    }

    @Override
    public Integer getTotalNumberOfModelAttributes() {
        Integer n = this.getCluster_id();
        Integer n2 = null;
        Collection<ClusteringDetailRowShort> collection = this._clusterCountsMap.values();
        for (ClusteringDetailRowShort clusteringDetailRowShort : collection) {
            String string = clusteringDetailRowShort.getClusterId();
            if (!string.equals(n.toString())) continue;
            n2 = clusteringDetailRowShort.getAttributeCount();
            break;
        }
        return n2;
    }

    public void addStateChangeListener(StateChangeListener stateChangeListener) {
        this.stateChangeListener = stateChangeListener;
    }

    @Override
    public void triggerUpdate() {
        if (this.stateChangeListener != null) {
            this.stateChangeListener.stateChanged();
        }
    }

    private Map<String, ClusteringDetailRowShort> getLeafsOnlyMap(Map<String, ClusteringDetailRowShort> map) {
        HashMap<String, ClusteringDetailRowShort> hashMap = new HashMap<String, ClusteringDetailRowShort>();
        for (Map.Entry<String, ClusteringDetailRowShort> entry : map.entrySet()) {
            String string = entry.getKey();
            ClusteringDetailRowShort clusteringDetailRowShort = entry.getValue();
            if (clusteringDetailRowShort.hasChildren()) continue;
            hashMap.put(string, clusteringDetailRowShort);
        }
        return hashMap;
    }
}

