/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.util.Map;
import oracle.dmt.dataminer.server.model.AssociationRules;
import oracle.ide.Context;

public class ARGlobalMetrics {
    private AssociationRules _model = null;
    private String _modelName;
    private String _userName;
    private Context _context;
    private int _total_rules_count;
    private int _total_itemset_count;
    private Double _maximum_lift_value;
    private boolean onlyOneColumnNameInModelItems = true;
    private boolean onlyOneSubColumnNameInModelItems = true;
    private boolean onlyOneConstantValueInModelItems = true;
    private boolean noSubNameColumnsInModelItems = false;
    private Integer totalNumberOfSingleOccuringItems = 1000;

    public ARGlobalMetrics(Context context, AssociationRules associationRules, String string, String string2) {
        assert (context != null) : "Context must not be null";
        assert (associationRules != null) : "Model must not be null";
        assert (string != null) : "UserName must not be null";
        assert (string2 != null) : "ModelName must not be null";
        this._context = context;
        this._model = associationRules;
        this._userName = string;
        this._modelName = string2;
    }

    public void loadGlobalMetrics(String string) throws Exception {
        Map<String, Object> map = this._model.getGlobalMetrics(this._context, this._userName, this._modelName, string);
        this._total_rules_count = (Integer)map.get("TOTAL_RULES_COUNT");
        this._maximum_lift_value = (Double)map.get("MAXIMUM_LIFT_VALUE");
        this._total_itemset_count = (Integer)map.get("TOTAL_ITEMSET_COUNT");
        Integer n = (Integer)map.get("SINGLE_ITEMSET_COUNT");
        Integer n2 = (Integer)map.get("ATTRIBUTE_SUBNAME_COUNT");
        String string2 = (String)map.get("MIN_ATTRIBUTE_NAME");
        String string3 = (String)map.get("MAX_ATTRIBUTE_NAME");
        String string4 = (String)map.get("MIN_ATTRIBUTE_SUBNAME");
        String string5 = (String)map.get("MAX_ATTRIBUTE_SUBNAME");
        Object object = map.get("MIN_ATTRIBUTE_VALUE");
        Object object2 = map.get("MAX_ATTRIBUTE_VALUE");
        if (this._total_rules_count != 0) {
            this.onlyOneColumnNameInModelItems = string2.compareTo(string3) == 0;
            this.onlyOneSubColumnNameInModelItems = string4 != null ? string4.compareTo(string5) == 0 : true;
            this.noSubNameColumnsInModelItems = n2 == 0;
            this.totalNumberOfSingleOccuringItems = n;
            if (object instanceof Number) {
                this.onlyOneConstantValueInModelItems = (Number)object == (Number)object2;
            } else if (object == null) {
                this.onlyOneConstantValueInModelItems = true;
            } else if (object instanceof String) {
                this.onlyOneConstantValueInModelItems = ((String)object).compareTo((String)object2) == 0;
            } else {
                throw new Exception("Unknown data type for attribute value in model.");
            }
        }
    }

    public boolean isOnlyOneColumnNameInModelItems() {
        return this.onlyOneColumnNameInModelItems;
    }

    public boolean isOnlyOneSubColumnNameInModelItems() {
        return this.onlyOneSubColumnNameInModelItems;
    }

    public boolean isOnlyOneConstantValueInModelItems() {
        return this.onlyOneConstantValueInModelItems;
    }

    public boolean isNoSubNameColumnsInModelItems() {
        return this.noSubNameColumnsInModelItems;
    }

    public Integer getTotalNumberOfSingleOccuringItems() {
        return this.totalNumberOfSingleOccuringItems;
    }

    public int getTotal_rules_count() {
        return this._total_rules_count;
    }

    public Double getMaximum_lift_value() {
        return this._maximum_lift_value;
    }

    public int getTotal_itemset_count() {
        return this._total_itemset_count;
    }
}

