/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.renderers;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class NumberCellRenderer
extends DefaultTableCellRenderer {
    private static final Preferences p = Preferences.getPreferences();
    private static final ModelViewerPreferenceSettings prefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)p);
    private NumberFormat formatter;
    private FormatType formatType;

    public NumberCellRenderer() {
        this(FormatType.NUMERICAL);
    }

    public NumberCellRenderer(FormatType formatType) {
        this.formatType = formatType;
        switch (formatType) {
            case NUMERICAL: {
                this.formatter = NumericFormat.getInstance(true, prefenceSettings.getNumericalPrecisionLevel(), 0, 0);
                this.formatter.setMaximumFractionDigits(prefenceSettings.getPercentagePrecisionLevel());
                break;
            }
            case PERCENTAGE: {
                this.formatter = NumericFormat.getInstance(true, prefenceSettings.getPercentagePrecisionLevel(), 0, 0);
                this.formatter.setMaximumFractionDigits(prefenceSettings.getPercentagePrecisionLevel());
                break;
            }
            case SCIENTIFIC: {
                StringBuilder stringBuilder = new StringBuilder("0.");
                for (int i = 0; i < prefenceSettings.getPercentagePrecisionLevel(); ++i) {
                    stringBuilder.append("#");
                }
                stringBuilder.append("E0");
                this.formatter = new DecimalFormat(stringBuilder.toString());
            }
        }
        this.formatter.setMinimumIntegerDigits(1);
    }

    @Override
    protected void setValue(Object object) {
        if (object == null) {
            super.setValue("");
        } else if (object instanceof Double) {
            super.setValue(this.formatter.format((Double)object));
        } else if (object instanceof Integer) {
            super.setValue(this.formatter.format(((Integer)object).intValue()));
        } else if (object instanceof BigDecimal) {
            super.setValue(this.formatter.format(((BigDecimal)object).doubleValue()));
        } else {
            super.setValue(object.toString());
        }
    }

    public static enum FormatType {
        PERCENTAGE,
        NUMERICAL,
        SCIENTIFIC;

    }
}

