/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.util.Calendar;
import java.util.Date;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dataminer.controls.DayComponent;

class YearComponent
extends JSpinner
implements ChangeListener {
    private Calendar _cal;
    private DayComponent _dp;
    private final int _MAX_ALLOWED_YEAR = 9999;
    private final int _MIN_ALLOWED_YEAR = 1;

    public YearComponent(Calendar calendar, DayComponent dayComponent) {
        this._cal = calendar;
        this._dp = dayComponent;
        this._init();
    }

    private void _init() {
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        spinnerDateModel.setCalendarField(1);
        this.setModel(spinnerDateModel);
        Calendar calendar = (Calendar)this._cal.clone();
        calendar.set(1, 0, 1);
        spinnerDateModel.setStart(calendar.getTime());
        calendar.set(9999, 1, 1);
        spinnerDateModel.setEnd(calendar.getTime());
        this.setEditor(new JSpinner.DateEditor((JSpinner)this, "yyyy"));
        this.setValue(this._cal.getTime());
        this.setOpaque(false);
        this.addChangeListener(this);
    }

    public void updateDisplay() {
        this.setValue(this._cal.getTime());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Date date = (Date)this.getValue();
        Calendar calendar = (Calendar)this._cal.clone();
        calendar.setTime(date);
        int n = calendar.get(1);
        this._cal.set(5, 1);
        this._cal.set(1, n);
        this._dp.rebuild();
    }

    void cleanUp() {
        this._cal = null;
        this._dp = null;
    }
}

