/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class PeerTreeSelectionModel
extends DefaultTreeSelectionModel {
    private JTree _tree;
    protected boolean updatingListSelectionModel;

    public PeerTreeSelectionModel(JTree jTree) {
        this._tree = jTree;
        this.createListToTreeSelectionModelWrapper();
    }

    @Override
    public void setSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray == null || this.hasNullPaths(treePathArray)) {
            return;
        }
        if (treePathArray.length == 0) {
            super.setSelectionPaths(treePathArray);
            return;
        }
        if (this.areParentsEqual(treePathArray, treePathArray[0].getParentPath())) {
            super.setSelectionPaths(treePathArray);
            return;
        }
        if (this.areContainerAncestorsEqual(treePathArray, this.getContainerAncestorPath(treePathArray[0]))) {
            super.setSelectionPaths(treePathArray);
            return;
        }
    }

    protected boolean canAddSelectionPath(TreePath treePath) {
        return this.canAddSelectionPaths(new TreePath[]{treePath});
    }

    private boolean canAddSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray == null || treePathArray.length == 0 || this.hasNullPaths(treePathArray)) {
            return false;
        }
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            super.addSelectionPaths(treePathArray);
            return true;
        }
        if (this.areParentsEqual(treePathArray, treePath.getParentPath())) {
            super.addSelectionPaths(treePathArray);
            return true;
        }
        if (this.areContainerAncestorsEqual(treePathArray, this.getContainerAncestorPath(treePath))) {
            super.addSelectionPaths(treePathArray);
            return true;
        }
        return false;
    }

    private boolean areParentsEqual(TreePath[] treePathArray, TreePath treePath) {
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath2 = treePathArray[i].getParentPath();
            if (treePath == null || treePath2 == null) {
                if (treePath == null && treePath2 == null) continue;
                return false;
            }
            if (treePath2.equals(treePath)) continue;
            return false;
        }
        return true;
    }

    private boolean areContainerAncestorsEqual(TreePath[] treePathArray, TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath2 = this.getContainerAncestorPath(treePathArray[i]);
            if (treePath == null || treePath2 == null) {
                if (treePath == null && treePath2 == null) continue;
                return false;
            }
            if (treePath2.equals(treePath)) continue;
            return false;
        }
        return true;
    }

    private TreePath getContainerAncestorPath(TreePath treePath) {
        for (TreePath treePath2 = treePath.getParentPath(); treePath2 != null; treePath2 = treePath2.getParentPath()) {
            if (!this.isContainerAncestorPath(treePath2)) continue;
            return treePath2;
        }
        return null;
    }

    private boolean isContainerAncestorPath(TreePath treePath) {
        return false;
    }

    private boolean hasNullPaths(TreePath[] treePathArray) {
        for (int i = 0; i < treePathArray.length; ++i) {
            if (treePathArray[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSelectionMode(int n) {
        super.setSelectionMode(n);
    }

    public int getMinSelectionIndex() {
        return this.listSelectionModel.getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.listSelectionModel.getMaxSelectionIndex();
    }

    public void createListToTreeSelectionModelWrapper() {
        this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
    }

    ListSelectionModel getListSelectionModel() {
        return this.listSelectionModel;
    }

    @Override
    public void resetRowSelection() {
        if (!this.updatingListSelectionModel) {
            this.updatingListSelectionModel = true;
            try {
                super.resetRowSelection();
            }
            finally {
                this.updatingListSelectionModel = false;
            }
        }
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSelectedPathsFromSelectedRows() {
        if (!this.updatingListSelectionModel) {
            this.updatingListSelectionModel = true;
            try {
                int n = this.listSelectionModel.getMinSelectionIndex();
                int n2 = this.listSelectionModel.getMaxSelectionIndex();
                this.clearSelection();
                if (n != -1 && n2 != -1) {
                    for (int i = n; i <= n2; ++i) {
                        TreePath treePath;
                        if (!this.listSelectionModel.isSelectedIndex(i) || (treePath = this._tree.getPathForRow(i)) == null || this.canAddSelectionPath(treePath)) continue;
                        this.listSelectionModel.removeSelectionInterval(i, i);
                    }
                }
            }
            finally {
                this.updatingListSelectionModel = false;
            }
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            PeerTreeSelectionModel.this.updateSelectedPathsFromSelectedRows();
        }
    }
}

