/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.math.BigDecimal;
import java.util.ArrayList;
import oracle.dmt.dataminer.controls.NameValuePair;

public class MatrixInfo {
    protected String _optionValue;
    protected ArrayList<NameValuePair> _matrixValues;

    public boolean isEmpty() {
        return this._matrixValues == null || this._matrixValues.isEmpty();
    }

    protected MatrixInfo(String string) {
        this._optionValue = string;
    }

    protected String getOptionValue() {
        return this._optionValue;
    }

    public void setOptionValue(String string) {
        this._optionValue = string;
    }

    public ArrayList<NameValuePair> getValues() {
        return this._matrixValues;
    }

    public int getRowCount() {
        int n = 0;
        if (this._matrixValues != null) {
            n = this._matrixValues.size();
        }
        return n;
    }

    public void clear() {
        if (this._matrixValues != null) {
            this._matrixValues.clear();
        }
        this._matrixValues = null;
    }

    public void put(String string, BigDecimal bigDecimal) {
        if (this._matrixValues == null) {
            this._matrixValues = new ArrayList();
        }
        this._matrixValues.add(new NameValuePair(string, new BigDecimal(bigDecimal.toString())));
    }

    public void put(String string, BigDecimal bigDecimal, int n) {
        if (this._matrixValues == null) {
            this._matrixValues = new ArrayList();
        }
        this._matrixValues.add(new NameValuePair(string, (Object)new BigDecimal(bigDecimal.toString()), n));
    }

    public BigDecimal getPriorValue(String string) {
        if (this._matrixValues != null && !this._matrixValues.isEmpty()) {
            for (NameValuePair nameValuePair : this._matrixValues) {
                if (!nameValuePair._name.equals(string)) continue;
                return (BigDecimal)nameValuePair._value;
            }
        }
        return null;
    }

    protected void putAll(ArrayList<NameValuePair> arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        if (this._matrixValues == null) {
            this._matrixValues = new ArrayList();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            NameValuePair nameValuePair = arrayList.get(i);
            NameValuePair nameValuePair2 = new NameValuePair(nameValuePair.getName(), (Object)new BigDecimal(nameValuePair.getValue().toString()), nameValuePair.getCount());
            if (nameValuePair.getKey() != null) {
                nameValuePair2.setKey(nameValuePair.getKey());
            }
            this._matrixValues.add(nameValuePair2);
        }
    }

    public void put(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (this._matrixValues == null) {
            this._matrixValues = new ArrayList();
        }
        this._matrixValues.add(new NameValuePair(bigDecimal, (Object)bigDecimal2, 1));
    }

    public void put(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n) {
        if (this._matrixValues == null) {
            this._matrixValues = new ArrayList();
        }
        this._matrixValues.add(new NameValuePair(bigDecimal, (Object)bigDecimal2, n));
    }

    public BigDecimal getPriorValue(BigDecimal bigDecimal) {
        if (this._matrixValues != null && !this._matrixValues.isEmpty()) {
            for (NameValuePair nameValuePair : this._matrixValues) {
                if (!nameValuePair._key.equals(bigDecimal)) continue;
                return (BigDecimal)nameValuePair._value;
            }
        }
        return null;
    }
}

