/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import oracle.dmt.dataminer.controls.JSONElement;
import oracle.dmt.dataminer.controls.JSONSubGroupByEditorProvider;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.AddSubGroupByColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONQueryEditorPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.ide.Context;
import oracle.javatools.icons.OracleIcons;

public class JSONSubGroupByTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
FocusListener {
    protected JPanel enclosingPanel = new JPanel();
    protected JButton delegate;
    protected JLabel label;
    protected String selectedText = JSONElement.EMPTY_STRING;
    protected JSONSubGroupByEditorProvider parentPanel;

    public JSONSubGroupByTableCellEditor(final Context context, final JSONSubGroupByEditorProvider jSONSubGroupByEditorProvider, final JSONQueryEditorPanel jSONQueryEditorPanel) {
        this.parentPanel = jSONSubGroupByEditorProvider;
        this.enclosingPanel.setLayout(new BorderLayout());
        this.label = new JLabel(this.selectedText);
        this.delegate = new JButton(OracleIcons.getIcon((String)"edit.png"));
        this.enclosingPanel.add(this.label);
        this.enclosingPanel.add("After", this.delegate);
        this.label.setLabelFor(this.delegate);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object2;
                AggregationElementsExType.AggregationElement aggregationElement = jSONSubGroupByEditorProvider.getAggregationElement();
                AggregationElementsExType.AggregationElement.SubGroupBy subGroupBy = new AggregationElementsExType.AggregationElement.SubGroupBy();
                subGroupBy.setAttributes(new AggregationElementsExType.AggregationElement.SubGroupBy.Attributes());
                for (Object object2 : aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute()) {
                    JSONAttributeType jSONAttributeType = (JSONAttributeType)MetaDataHelper.copyMetadataObject(object2);
                    subGroupBy.getAttributes().getJSONAttribute().add(jSONAttributeType);
                }
                AddSubGroupByColumnPanel addSubGroupByColumnPanel = new AddSubGroupByColumnPanel(context, (AbstractDataNode)jSONQueryEditorPanel.getData(), jSONQueryEditorPanel, aggregationElement.getSubGroupBy());
                if (!addSubGroupByColumnPanel.showAsDialog(jSONSubGroupByEditorProvider.getParentPanel())) {
                    aggregationElement.setSubGroupBy(subGroupBy);
                } else {
                    AttributeTypeHelper.setJSONOutputAttributeType(context, aggregationElement.getOutput().getName(), aggregationElement);
                    jSONSubGroupByEditorProvider.addNewAggregationElement(aggregationElement);
                }
                object2 = new StringBuilder();
                for (JSONAttributeType jSONAttributeType : aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute()) {
                    if (((StringBuilder)object2).length() > 0) {
                        ((StringBuilder)object2).append(", ");
                    }
                    ((StringBuilder)object2).append(jSONAttributeType.getDBName());
                }
                JSONSubGroupByTableCellEditor.this.changeSelection(((StringBuilder)object2).toString());
            }
        };
        this.delegate.addActionListener(actionListener);
        this.delegate.addFocusListener(this);
    }

    private void changeSelection(String string) {
        this.selectedText = string;
        this.label.setText(this.selectedText);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        List<JSONAttributeType> list = this.parentPanel.getSubGroupByJSONAttributes(n);
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (JSONAttributeType jSONAttributeType : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(jSONAttributeType.getDBName());
            }
        } else {
            stringBuilder.append(JSONElement.EMPTY_STRING);
        }
        this.changeSelection(stringBuilder.toString());
        return this.enclosingPanel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.selectedText;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.cancelCellEditing();
    }
}

