/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IndentComboBoxPane
extends JPanel {
    private int numberOfSpaces = 4;
    private JComboBox comboBox = null;
    private JLabel jLabel = new JLabel();

    public IndentComboBoxPane(JComboBox jComboBox) {
        this(jComboBox, null);
    }

    public IndentComboBoxPane(JComboBox jComboBox, Integer n) {
        this.comboBox = jComboBox;
        if (n != null) {
            this.numberOfSpaces = n;
        }
        this.initUI();
    }

    public void initUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(255, 255, 255));
        this.add((Component)this.jLabel, "West");
        this.add((Component)this.comboBox, "Center");
        this.updateText();
    }

    private void updateText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.numberOfSpaces; ++i) {
            stringBuilder.append(' ');
        }
        this.jLabel.setText(stringBuilder.toString());
    }

    @Override
    public void setEnabled(boolean bl) {
        this.jLabel.setEnabled(bl);
        this.comboBox.setEnabled(bl);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.jLabel != null) {
            this.jLabel.setBackground(color);
        }
        if (this.comboBox != null) {
            this.comboBox.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.jLabel != null) {
            this.jLabel.setForeground(color);
        }
        if (this.comboBox != null) {
            this.comboBox.setForeground(color);
        }
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setNumberofSpaces(int n) {
        this.numberOfSpaces = n;
    }
}

