/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer;

import java.awt.Component;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataminerNavigatorManager;
import oracle.dmt.dataminer.navigator.DataminerNavigatorWindow;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.runner.RunManagerDockableFactory;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DataMinerConnections;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.docking.DockableWindow;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.javatools.dialogs.MessageDialog;

public class ToolsMenuAddin
implements Controller,
Addin {
    private static final String DATA_MINER_UI_TOOL_MENU_NAME = StringUtils.stripMnemonic((String)PreferencesLrb.get("DATA_MINER_DISPLAY_UI"));
    private static final String DATA_MINER_DROP_REPOS_MENU_NAME = StringUtils.stripMnemonic((String)PreferencesLrb.get("DATA_MINER_DROP_REPOS"));
    private static final int DATA_MINER_UI_TOOL_MENU_NAME_MNEMONIC = StringUtils.getMnemonicKeyCode((String)PreferencesLrb.get("DATA_MINER_DISPLAY_UI"));
    public static final int TOOLS_DATA_MINER_DISPLAY_UI = Ide.findOrCreateCmdID((String)"dataminer.toolsDataMinerDisplayUI");
    public static final int TOOLS_DATA_MINER_DROP_REPOS = Ide.findOrCreateCmdID((String)"dataminer.dropRepos");

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == TOOLS_DATA_MINER_DISPLAY_UI) {
            this.findOrCreateNavWindow(true);
            RunManagerDockableFactory runManagerDockableFactory = RunManagerDockableFactory.getInstance();
            DockableWindow dockableWindow = (DockableWindow)runManagerDockableFactory.getDockable(runManagerDockableFactory.getDockableViewId());
            dockableWindow.setDockableVisible(true);
            return true;
        }
        if (n == TOOLS_DATA_MINER_DROP_REPOS) {
            String string;
            String string2;
            Node node;
            NavigatorWindow navigatorWindow = this.findOrCreateNavWindow(true);
            navigatorWindow.getTreeExplorer();
            TreeExplorer treeExplorer = navigatorWindow.getTreeExplorer();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Enumeration enumeration = treeExplorer.getRoot().getChildTNodes();
            while (enumeration.hasMoreElements()) {
                node = (TNode)enumeration.nextElement();
                string2 = node.getData().getShortLabel();
                hashtable.put(string2, string2);
            }
            node = context.getNode();
            string2 = null;
            if (node instanceof ConnectionFolder) {
                string2 = node.getShortLabel();
                string2 = DataMinerConnections.getQualifiedName(string2);
            }
            if ((string = new DataMinerConnectionSelector().getMyConnection(PreferencesLrb.get("SELECT_CONN_TITLE"), PreferencesLrb.get("SELECT_CONN_MSG"), string2, hashtable)) == null) {
                return true;
            }
            String string3 = DataMinerConnections.getUnqualifiedName(string);
            Context context2 = null;
            URL uRL = DMURLFormatHelper.getURL(string3);
            ConnectionFolder connectionFolder = (ConnectionFolder)NodeFactory.find((URL)uRL);
            if (connectionFolder != null) {
                context2 = Context.newIdeContext((Node)connectionFolder);
            }
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)PreferencesLrb.get("DROP_REPOS_CONFIRM"), (String)PreferencesLrb.get("DROP_REPOS_CONFIRM_TITLE"), null, (boolean)true)) {
                return true;
            }
            ConfigUtils.configureConnection(context2, string3, ConfigUtils.RunMode.DROP_REPOS);
            return true;
        }
        return false;
    }

    private NavigatorWindow findOrCreateNavWindow(boolean bl) {
        DataminerNavigatorManager dataminerNavigatorManager = (DataminerNavigatorManager)DataminerNavigatorManager.getInstance();
        DataminerNavigatorWindow dataminerNavigatorWindow = dataminerNavigatorManager.getNavigatorInstance();
        if (bl) {
            dataminerNavigatorWindow.show();
        }
        return dataminerNavigatorWindow;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == TOOLS_DATA_MINER_DISPLAY_UI || n == TOOLS_DATA_MINER_DROP_REPOS) {
            if (n == TOOLS_DATA_MINER_DISPLAY_UI) {
                boolean bl = false;
                DataminerNavigatorManager dataminerNavigatorManager = (DataminerNavigatorManager)DataminerNavigatorManager.getInstance();
                DataminerNavigatorWindow dataminerNavigatorWindow = dataminerNavigatorManager.getNavigatorInstance();
                if (dataminerNavigatorWindow != null) {
                    bl = dataminerNavigatorWindow.isVisible();
                }
                RunManagerDockableFactory runManagerDockableFactory = RunManagerDockableFactory.getInstance();
                DockableWindow dockableWindow = (DockableWindow)runManagerDockableFactory.getDockable(runManagerDockableFactory.getDockableViewId());
                boolean bl2 = dockableWindow.isVisible();
                ideAction.setEnabled(!bl || !bl2);
            }
            return true;
        }
        return false;
    }

    public void initialize() {
    }

    private static class DataMinerConnectionSelector
    extends ConnectionSelectorUI {
        private JEWTDialog dlg = null;

        public DataMinerConnectionSelector() {
            super(true);
        }

        public String getMyConnection(String string, String string2, String string3, Hashtable hashtable) {
            ConnectionSelectorUI connectionSelectorUI = new ConnectionSelectorUI(true);
            JComboBox jComboBox = connectionSelectorUI.getConnCombo();
            int n = jComboBox.getItemCount();
            for (int i = n - 1; i >= 0; --i) {
                String string4 = DataMinerConnections.getUnqualifiedName(jComboBox.getModel().getElementAt(i).toString());
                if (hashtable.containsValue(string4)) continue;
                jComboBox.removeItemAt(i);
            }
            this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)connectionSelectorUI, (Component)connectionSelectorUI.getDefaultFocusComponent(), (String)string);
            this.dlg.setOKButtonEnabled(connectionSelectorUI.getConnectionCount() > 0);
            this.dlg.setButtonMask(3);
            connectionSelectorUI.setConnectionPrompt(string2);
            if (string3 != null) {
                connectionSelectorUI.setConnectionName(string3);
            }
            String string5 = null;
            boolean bl = WizardLauncher.runDialog((JDialog)this.dlg);
            if (bl) {
                string5 = connectionSelectorUI.getConnectionName();
            }
            return string5;
        }
    }
}

