/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer;

import java.util.ArrayList;
import javax.swing.JPanel;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.DataMinerViewListener;
import oracle.dmt.dataminer.DataMinerViewStatus;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.ide.Context;
import oracle.ide.editor.Editor;

public abstract class DataMinerViewGUI
extends JPanel
implements DataminerGUIPanel {
    protected ArrayList<DataMinerViewListener> _dataminerViewListeners;
    private DataMinerViewStatus _viewStatus = DataMinerViewStatus.BUSY;
    protected Context _context;
    protected Editor _editor;

    public DataMinerViewGUI() {
        this._dataminerViewListeners = new ArrayList();
    }

    public DataMinerViewGUI(Editor editor, Context context) {
        this._context = context;
        this._editor = editor;
        this._dataminerViewListeners = new ArrayList();
    }

    public Context getContext() {
        return this._context;
    }

    public Editor getEditor() {
        return this._editor;
    }

    public boolean isLoaded() {
        return this._viewStatus == DataMinerViewStatus.READY;
    }

    protected void setLoaded(boolean bl) {
        if (bl) {
            this._viewStatus = DataMinerViewStatus.READY;
            this.fireViewReady(new DataMinerViewEvent(this, "VIEW_READY", null));
        } else {
            this._viewStatus = DataMinerViewStatus.BUSY;
            this.fireViewBusy(new DataMinerViewEvent(this, "VIEW_BUSY", null));
        }
    }

    public DataMinerViewStatus getViewStatus() {
        return this._viewStatus;
    }

    protected void setViewStatus(DataMinerViewStatus dataMinerViewStatus) {
        assert (dataMinerViewStatus != null) : "DataMinerViewStatus can not be set to null";
        if (dataMinerViewStatus == DataMinerViewStatus.BUSY) {
            this.setLoading(true);
        } else {
            this.setLoading(false);
        }
    }

    public boolean isLoading() {
        return this._viewStatus == DataMinerViewStatus.BUSY;
    }

    protected void setLoading(boolean bl) {
        if (bl) {
            this._viewStatus = DataMinerViewStatus.BUSY;
            this.fireViewBusy(new DataMinerViewEvent(this, "VIEW_BUSY", null));
        } else {
            this._viewStatus = DataMinerViewStatus.READY;
            this.fireViewReady(new DataMinerViewEvent(this, "VIEW_READY", null));
        }
    }

    public void addDataMinerViewListener(DataMinerViewListener dataMinerViewListener) {
        if (this._dataminerViewListeners == null) {
            this._dataminerViewListeners = new ArrayList();
        }
        this._dataminerViewListeners.add(dataMinerViewListener);
    }

    public void removeDataMinerViewListener(DataMinerViewListener dataMinerViewListener) {
        this._dataminerViewListeners.remove(dataMinerViewListener);
    }

    public void fireViewReady(DataMinerViewEvent dataMinerViewEvent) {
        this.fireEvent(new DataMinerViewListenerHandler(){

            @Override
            public void handle(DataMinerViewListener dataMinerViewListener, DataMinerViewEvent dataMinerViewEvent) {
                dataMinerViewListener.viewReady(dataMinerViewEvent);
            }
        }, dataMinerViewEvent);
    }

    public void fireViewBusy(DataMinerViewEvent dataMinerViewEvent) {
        this.fireEvent(new DataMinerViewListenerHandler(){

            @Override
            public void handle(DataMinerViewListener dataMinerViewListener, DataMinerViewEvent dataMinerViewEvent) {
                dataMinerViewListener.viewBusy(dataMinerViewEvent);
            }
        }, dataMinerViewEvent);
    }

    public void fireViewPropertySelectionChange(Object object, Object object2) {
        this.fireViewPropertySelectionChange(new DataMinerViewEvent(this, "PROPERTY_SELECTION_EVENT", object2));
    }

    public void fireViewPropertySelectionChange(DataMinerViewEvent dataMinerViewEvent) {
        this.fireEvent(new DataMinerViewListenerHandler(){

            @Override
            public void handle(DataMinerViewListener dataMinerViewListener, DataMinerViewEvent dataMinerViewEvent) {
                dataMinerViewListener.viewPropertySelectionChange(dataMinerViewEvent);
            }
        }, dataMinerViewEvent);
    }

    private void fireEvent(DataMinerViewListenerHandler dataMinerViewListenerHandler, DataMinerViewEvent dataMinerViewEvent) {
        ArrayList<DataMinerViewListener> arrayList = this.cloneToAvoidConcurrentModificationException(this._dataminerViewListeners);
        for (DataMinerViewListener dataMinerViewListener : arrayList) {
            dataMinerViewListenerHandler.handle(dataMinerViewListener, dataMinerViewEvent);
        }
    }

    private ArrayList<DataMinerViewListener> cloneToAvoidConcurrentModificationException(ArrayList<DataMinerViewListener> arrayList) {
        return (ArrayList)arrayList.clone();
    }

    private static interface DataMinerViewListenerHandler {
        public void handle(DataMinerViewListener var1, DataMinerViewEvent var2);
    }
}

