/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.dbtools.common.util.Identifiers;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.web.BaseAndPath;
import oracle.dbtools.rt.web.HttpHeader;

public class SecureSession {
    private final HttpServletRequest req;
    private final boolean verify;
    private final String cookieName;
    public static final String ATTRIBUTE_NAME = "_secure_id_";

    SecureSession(HttpServletRequest req, String cookieName) {
        this.req = req;
        this.cookieName = cookieName;
        this.verify = req.isSecure();
    }

    HttpSession getSession(boolean create) {
        if (this.verify) {
            HttpSession session = this.req.getSession(create);
            if (create) {
                String secureId = Identifiers.randomIdentifier();
                session.setAttribute(ATTRIBUTE_NAME, (Object)secureId);
                return session;
            }
            if (session == null) {
                return null;
            }
            try {
                String secureId = this.secureId();
                String cookieValue = this.cookieValue();
                if (this.matches(secureId, cookieValue)) {
                    return session;
                }
                session.invalidate();
                return null;
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        return this.req.getSession(create);
    }

    void secure(HttpServletResponse response) {
        String secureId = this.secureId();
        URI base = this.base();
        if (this.verify && secureId != null) {
            StringBuilder headerValue = new StringBuilder();
            headerValue.append(this.cookieName);
            headerValue.append('=');
            headerValue.append(secureId);
            headerValue.append("; Domain=");
            headerValue.append(base.getHost());
            headerValue.append("; Path=");
            headerValue.append(base.getPath());
            headerValue.append("; Secure; HttpOnly");
            response.addHeader(HttpHeader.SET_COOKIE.text(), headerValue.toString());
        }
    }

    private URI base() {
        String[] baseAndPath = BaseAndPath.baseAndPath(this.req);
        String base = baseAndPath[0];
        return URI.create(base);
    }

    private boolean matches(String expected, String actual) {
        return expected != null && expected.equals(actual);
    }

    private String secureId() {
        HttpSession session = this.req.getSession(false);
        if (session == null) {
            return null;
        }
        return (String)session.getAttribute(ATTRIBUTE_NAME);
    }

    private String cookieValue() {
        Object[] cookies = this.req.getCookies();
        if (!NullOrEmpty.nullOrEmpty((Object[])cookies)) {
            for (Object cookie : cookies) {
                if (!this.cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

