/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.nio.charset.Charset;
import oracle.dbtools.common.util.CharSequenceMixin;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.web.EncodedValue;
import oracle.dbtools.rt.web.HttpCharacterClasses;
import oracle.dbtools.rt.web.PercentEncoding;

class RFC5987Value
extends CharSequenceMixin
implements EncodedValue {
    private final PercentEncoding codec;
    private final CharSequence language;
    private final CharSequence content;
    private static final char DELIMITER = '\'';
    private static final Log LOG = Log.get(RFC5987Value.class);

    private RFC5987Value(CharSequence encoded) {
        super(encoded);
        int secondDelimiter;
        Charset charset = Text.defaultCharset();
        String language = null;
        String rawText = encoded.toString();
        int firstDelimiter = rawText.indexOf(39);
        if (firstDelimiter != -1 && (secondDelimiter = rawText.indexOf(39, firstDelimiter + 1)) != -1) {
            charset = Charset.forName(rawText.substring(0, firstDelimiter).trim());
            language = rawText.substring(firstDelimiter + 1, secondDelimiter).trim();
            if (language.isEmpty()) {
                language = null;
            }
            rawText = rawText.substring(secondDelimiter + 1);
        }
        this.codec = new PercentEncoding(charset, HttpCharacterClasses.ATTRIBUTE_CHAR);
        this.language = language;
        this.content = this.codec.decode(rawText);
    }

    Charset charset() {
        return this.codec.charset();
    }

    @Override
    public CharSequence content() {
        return this.content;
    }

    CharSequence language() {
        return this.language;
    }

    public static RFC5987Value decode(CharSequence encoded) {
        return new RFC5987Value(encoded);
    }

    public static CharSequence encode(CharSequence content) {
        return RFC5987Value.encode(Text.defaultCharset(), content);
    }

    public static CharSequence encode(Charset charset, CharSequence content) {
        return RFC5987Value.encode(charset, null, content);
    }

    public static CharSequence encode(Charset charset, CharSequence language, CharSequence content) {
        PercentEncoding codec = new PercentEncoding(charset, HttpCharacterClasses.ATTRIBUTE_CHAR);
        StringBuilder encoded = new StringBuilder(content.length() << 1);
        encoded.append(charset.name());
        encoded.append('\'');
        if (!NullOrEmpty.nullOrEmpty((CharSequence)language)) {
            encoded.append(language);
        }
        encoded.append('\'');
        try {
            codec.encode((Appendable)encoded, content);
        }
        catch (IOException e) {
            LOG.finest((Throwable)e);
        }
        return encoded.toString();
    }

    private static boolean isLegal(char ch) {
        return HttpCharacterClasses.ATTRIBUTE_CHAR.matches((int)ch);
    }
}

