/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import oracle.dbtools.common.util.CharSequenceMixin;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.web.EncodedValue;
import oracle.dbtools.rt.web.HttpCharacterClasses;
import oracle.dbtools.rt.web.PercentEncoding;

class QuotedStringValue
extends CharSequenceMixin
implements EncodedValue {
    private final CharSequence content;
    private static final Codec CODEC = new Codec();

    private QuotedStringValue(CharSequence text) {
        super(QuotedStringValue.normalize(text));
        this.content = QuotedStringValue.decodeText(text);
    }

    @Override
    public CharSequence content() {
        return this.content;
    }

    public static QuotedStringValue decode(CharSequence encoded) {
        return new QuotedStringValue(encoded);
    }

    public static CharSequence encode(CharSequence text) {
        StringBuilder b = new StringBuilder();
        b.append('\"');
        try {
            CODEC.encode((Appendable)b, text);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        b.append('\"');
        return b.toString();
    }

    private static CharSequence decodeText(CharSequence text) {
        String content = text.toString();
        if (content.startsWith("\"")) {
            if (!(content = content.substring(1)).endsWith("\"")) {
                throw new IllegalStateException("Missing closing quotes");
            }
        } else {
            throw new IllegalStateException("Missing opening quotes");
        }
        content = content.substring(0, content.length() - 1);
        content = content.replace("\\", "");
        return CODEC.decode(content);
    }

    private static CharSequence normalize(CharSequence text) {
        CharSequence decoded = QuotedStringValue.decodeText(text);
        return QuotedStringValue.encode(decoded);
    }

    private static class Codec
    extends PercentEncoding {
        private Codec() {
            super(Text.defaultCharset(), HttpCharacterClasses.QDTEXT);
        }

        @Override
        protected void encode(Appendable encoded, byte ch) throws IOException {
            if (34 == ch) {
                encoded.append('\\');
                encoded.append('\"');
            } else if (92 == ch) {
                encoded.append("\\\\");
            } else {
                super.encode(encoded, ch);
            }
        }
    }
}

