/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.util.Iterator;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.CharSequenceMixin;
import oracle.dbtools.rt.web.EncodedValue;
import oracle.dbtools.rt.web.QuotedStringValue;

class QuotedStringScanner
extends CharSequenceMixin
implements Iterable<Token> {
    static final char ILLEGAL_CHAR = '?';

    QuotedStringScanner(CharSequence text) {
        super(text);
    }

    @Override
    public Iterator<Token> iterator() {
        return new TokenIterator(this.text());
    }

    private static class TokenIterator
    extends AbstractIterator<Token> {
        private TokenType lastToken = null;
        private int pos = 0;
        private final CharSequence text;

        private TokenIterator(CharSequence text) {
            this.text = text;
        }

        protected Token advance() {
            Token token = null;
            if (this.pos < this.text.length()) {
                token = this.lastToken == null || this.lastToken == TokenType.QUOTED_TEXT ? this.textToken(this.text, this.pos) : this.quotedToken(this.text, this.pos);
                this.lastToken = token.type();
                this.pos += token.length();
            }
            return token;
        }

        private int endOfQuotedString(CharSequence text, int start) {
            for (int end = start + 1; end < text.length(); ++end) {
                if ('\"' != text.charAt(end) || end != 0 && '\\' == text.charAt(end - 1)) continue;
                return end;
            }
            return -1;
        }

        private Token quotedToken(CharSequence text, int start) {
            int end = this.endOfQuotedString(text, start);
            if (end == -1) {
                end = text.length();
                return this.textToken(text, start, end);
            }
            return this.quotedToken(text, start, end);
        }

        private Token quotedToken(CharSequence text, int start, int end) {
            return new Token(TokenType.QUOTED_TEXT, QuotedStringValue.decode(text.subSequence(start, end + 1)));
        }

        private int startOfQuotedString(CharSequence text, int start) {
            for (int end = start; end < text.length(); ++end) {
                if ('\"' != text.charAt(end)) continue;
                return end;
            }
            return -1;
        }

        private Token textToken(CharSequence text, int start) {
            int end = this.startOfQuotedString(text, start);
            if (end == -1) {
                end = text.length();
            } else if (end == 0) {
                return this.quotedToken(text, 0);
            }
            return this.textToken(text, start, end);
        }

        private Token textToken(CharSequence text, int start, int end) {
            return new Token(TokenType.TEXT, new TextValue(text.subSequence(start, end)));
        }
    }

    private static class TextValue
    extends CharSequenceMixin
    implements EncodedValue {
        private TextValue(CharSequence text) {
            super(text);
        }

        @Override
        public CharSequence content() {
            return this.text();
        }
    }

    static enum TokenType {
        QUOTED_TEXT,
        TEXT;

    }

    static class Token
    extends CharSequenceMixin {
        private final TokenType type;
        private final EncodedValue value;

        private Token(TokenType type, EncodedValue value) {
            super((CharSequence)value);
            this.type = type;
            this.value = value;
        }

        public CharSequence content() {
            return this.value.content();
        }

        TokenType type() {
            return this.type;
        }
    }
}

