/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.CharSequenceMixin;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.M2NIterator;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.web.EncodedValue;
import oracle.dbtools.rt.web.HeaderValueScanner;
import oracle.dbtools.rt.web.HttpCharacterClasses;
import oracle.dbtools.rt.web.QuotedStringScanner;
import oracle.dbtools.rt.web.QuotedStringValue;
import oracle.dbtools.rt.web.RFC5987Value;

public class HttpHeaderValue
extends CharSequenceMixin {
    private final Iterable<HeaderParameter> parameters;
    private static final HttpHeaderValue NO_PARAMETERS = new HttpHeaderValue(Iterables.empty());

    private HttpHeaderValue(Iterable<HeaderParameter> parameters) {
        super((CharSequence)Iterables.join(parameters, (String)"; "));
        this.parameters = parameters;
    }

    public Iterable<HeaderParameter> parameters() {
        return this.parameters;
    }

    public AssociativeArray<CharSequence, CharSequence> asAssociatveArray() {
        AssociativeArrays.Builder array = AssociativeArrays.builder();
        for (HeaderParameter parameter : this.parameters) {
            CharSequence name = parameter.name();
            CharSequence actualValue = parameter.value();
            ValueTypeMarker value = actualValue == null ? null : new ValueTypeMarker(parameter);
            ValueTypeMarker existing = (ValueTypeMarker)((Object)array.get((Object)name));
            CharSequence chosen = this.choose(existing, value);
            array.add((Object)name, (Object)chosen);
        }
        for (CharSequence name : array.build()) {
            ValueTypeMarker value = (ValueTypeMarker)((Object)array.get((Object)name));
            if (value == null) continue;
            array.add((Object)name, (Object)value.toString());
        }
        return array.build();
    }

    private CharSequence choose(ValueTypeMarker existing, ValueTypeMarker value) {
        if (value == null) {
            return existing;
        }
        if (existing == null || value.type().precedence >= existing.type().precedence) {
            return value;
        }
        return existing;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HttpHeaderValue parse(CharSequence text) {
        if (NullOrEmpty.nullOrEmpty((CharSequence)text)) {
            return NO_PARAMETERS;
        }
        Builder parameters = HttpHeaderValue.builder();
        HeaderValueScanner segments = new HeaderValueScanner(text);
        for (CharSequence segment : segments) {
            for (HeaderParameter parameter : new SegmentScanner(segment)) {
                parameters.add(parameter);
            }
        }
        return parameters.build();
    }

    private static CharSequence decodeExtendedValue(String value) {
        return RFC5987Value.decode(value);
    }

    private static CharSequence encodeToken(CharSequence text) {
        if (text == null) {
            return null;
        }
        StringBuilder encoded = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (HttpCharacterClasses.TCHAR.matches((int)c)) {
                encoded.append(c);
                continue;
            }
            encoded.append('?');
        }
        return encoded.toString();
    }

    public static enum ParameterType {
        EXTENDED(0),
        QUOTED(1),
        NO_VALUE(3),
        UNQUOTED(2);

        private final int precedence;

        private ParameterType(int precendence) {
            this.precedence = precendence;
        }
    }

    public static class HeaderParameter {
        private final CharSequence name;
        private final ParameterType type;
        private final CharSequence value;

        private HeaderParameter(ParameterType type, CharSequence name, CharSequence value) {
            this.type = type;
            this.name = name;
            this.value = value;
        }

        public CharSequence name() {
            return this.name;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.name);
            if (this.type == ParameterType.EXTENDED) {
                b.append("*");
            }
            if (this.type != ParameterType.NO_VALUE) {
                b.append("=");
            }
            if (this.type == ParameterType.EXTENDED) {
                b.append(RFC5987Value.encode(this.value));
            } else if (this.type == ParameterType.QUOTED) {
                b.append(QuotedStringValue.encode(this.value));
            } else if (this.type == ParameterType.UNQUOTED) {
                b.append(HttpHeaderValue.encodeToken(this.value));
            }
            return b.toString();
        }

        public ParameterType type() {
            return this.type;
        }

        public CharSequence value() {
            if (this.value instanceof EncodedValue) {
                return ((EncodedValue)this.value).content();
            }
            return this.value;
        }
    }

    public static class Builder {
        private final List<HeaderParameter> parameters = new ArrayList<HeaderParameter>();

        private Builder() {
        }

        public HttpHeaderValue build() {
            return new HttpHeaderValue(this.parameters);
        }

        public Builder add(HttpHeaderValue value) {
            return this.add(value.parameters());
        }

        public Builder add(Iterable<HeaderParameter> parameters) {
            for (HeaderParameter parameter : parameters) {
                this.add(parameter);
            }
            return this;
        }

        Builder add(HeaderParameter parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public Builder extendedParameter(CharSequence name, CharSequence value) {
            this.parameters.add(new HeaderParameter(ParameterType.EXTENDED, name, value));
            return this;
        }

        public Builder noValueParameter(CharSequence name) {
            this.parameters.add(new HeaderParameter(ParameterType.NO_VALUE, name, null));
            return this;
        }

        public Builder unquotedParameter(CharSequence name, CharSequence value) {
            this.parameters.add(new HeaderParameter(ParameterType.UNQUOTED, name, value));
            return this;
        }

        public Builder parameter(CharSequence name, CharSequence value) {
            this.parameters.add(new HeaderParameter(ParameterType.QUOTED, name, value));
            return this;
        }

        public Builder parameterType(CharSequence name, ParameterType type) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                HeaderParameter existing = this.parameters.get(i);
                if (!name.equals(existing.name()) || type == existing.type()) continue;
                HeaderParameter replacement = new HeaderParameter(type, existing.name(), existing.value());
                this.parameters.set(i, replacement);
            }
            return this;
        }
    }

    private static class HeaderParameterIterator
    extends M2NIterator<QuotedStringScanner.Token, HeaderParameter> {
        private ParameterType type;
        private CharSequence name;
        private CharSequence value;

        private HeaderParameterIterator(Iterator<QuotedStringScanner.Token> src) {
            super(src);
        }

        protected void process(QuotedStringScanner.Token token) {
            if (QuotedStringScanner.TokenType.TEXT == token.type()) {
                String segment = token.content().toString().trim();
                int equals = segment.indexOf(61);
                if (equals == -1) {
                    this.type = ParameterType.NO_VALUE;
                    this.name = segment;
                    this.pushParameter();
                } else if (equals == segment.length() - 1) {
                    this.type = ParameterType.QUOTED;
                    this.name = segment.substring(0, equals).trim();
                } else {
                    String key = segment.substring(0, equals).trim();
                    String content = segment.substring(equals + 1).trim();
                    if (key.endsWith("*")) {
                        this.type = ParameterType.EXTENDED;
                        this.name = key.substring(0, key.length() - 1);
                        this.value = HttpHeaderValue.decodeExtendedValue(content);
                    } else {
                        this.type = ParameterType.UNQUOTED;
                        this.name = key;
                        this.value = content;
                    }
                    this.pushParameter();
                }
            } else if (ParameterType.QUOTED == this.type) {
                this.value = token.content();
                this.pushParameter();
            } else {
                throw new IllegalStateException("Got a quoted string, but expecting: <<" + (Object)((Object)this.type) + ">>");
            }
        }

        private void pushParameter() {
            this.add(new HeaderParameter(this.type, this.name, this.value));
            this.type = null;
            this.name = null;
            this.value = null;
        }
    }

    private static class SegmentScanner
    extends CharSequenceMixin
    implements Iterable<HeaderParameter> {
        private final QuotedStringScanner scanner;

        @Override
        public Iterator<HeaderParameter> iterator() {
            return new HeaderParameterIterator(this.scanner.iterator());
        }

        private SegmentScanner(CharSequence text) {
            super(text);
            this.scanner = new QuotedStringScanner(text);
        }
    }

    private static class ValueTypeMarker
    extends CharSequenceMixin {
        private final ParameterType type;

        private ValueTypeMarker(HeaderParameter parameter) {
            super(parameter.value);
            this.type = parameter.type;
        }

        ParameterType type() {
            return this.type;
        }
    }
}

