/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.util.Iterator;
import oracle.dbtools.common.util.CharSequenceMixin;
import oracle.dbtools.common.util.M2NIterator;
import oracle.dbtools.rt.web.QuotedStringScanner;

class HeaderValueScanner
extends CharSequenceMixin
implements Iterable<CharSequence> {
    private final QuotedStringScanner scanner;
    private static final String DELIMITER = ";";

    public HeaderValueScanner(CharSequence text) {
        super(text);
        this.scanner = new QuotedStringScanner(text);
    }

    @Override
    public Iterator<CharSequence> iterator() {
        return new SegmentIterator(this.scanner.iterator());
    }

    private class SegmentIterator
    extends M2NIterator<QuotedStringScanner.Token, CharSequence> {
        private StringBuilder segment;

        protected void finished() {
            if (this.segment.length() > 0) {
                this.pushSegment();
            }
        }

        private void pushSegment() {
            this.add(this.segment.toString());
        }

        protected SegmentIterator(Iterator<QuotedStringScanner.Token> src) {
            super(src);
            this.segment = new StringBuilder();
        }

        protected void process(QuotedStringScanner.Token token) {
            if (QuotedStringScanner.TokenType.TEXT == token.type()) {
                int start = 0;
                int end = -1;
                String text = token.content().toString();
                end = text.indexOf(HeaderValueScanner.DELIMITER, start);
                while (end != -1) {
                    this.segment.append(text.subSequence(start, end));
                    this.pushSegment();
                    this.segment = new StringBuilder();
                    start = end + 1;
                    end = text.indexOf(HeaderValueScanner.DELIMITER, start);
                }
                this.segment.append(token.subSequence(start, text.length()));
            } else {
                this.segment.append((CharSequence)((Object)token));
            }
        }
    }
}

