/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import oracle.dbtools.common.config.ConfigurationEventListener;
import oracle.dbtools.common.config.ConfigurationsProvider;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.common.util.URLEncoding;
import oracle.dbtools.plugin.api.conf.Configuration;

class ForceSecure {
    private boolean forceHttps = false;
    private String httpsHeaderName = null;
    private String httpsHeaderValue = null;
    private final ConfigurationEventListener LISTENER = new ConfigurationChanged();
    private static final int HTTPS_PORT = 443;
    private static final String HTTPS_SCHEME = "https";
    private static final ForceSecure INSTANCE = new ForceSecure();
    private static final Log LOG = Log.get(ForceSecure.class);
    private static final Pair<String, String> NO_HTTPS_HEADER_CHECK = Pair.pair(null, null);

    protected ForceSecure() {
    }

    final HttpServletRequest apply(HttpServletRequest req) {
        if (this.requiresHttps(req)) {
            URI httpsRequestUri = ForceSecure.httpsRequestUri(req);
            ForceHttpsRequest httpsRequest = new ForceHttpsRequest(httpsRequestUri, req);
            return httpsRequest;
        }
        return req;
    }

    void setup(ConfigurationsProvider provider) {
        provider.addListener("defaults", this.LISTENER);
    }

    void teardown(ConfigurationsProvider provider) {
        this.forceHttps = false;
        provider.removeListener(this.LISTENER);
    }

    private boolean requiresHttps(HttpServletRequest req) {
        if (this.forceHttps) {
            return true;
        }
        if (!NullOrEmpty.nullOrEmpty((CharSequence)this.httpsHeaderName) && !NullOrEmpty.nullOrEmpty((CharSequence)this.httpsHeaderValue)) {
            String expectedValue = this.httpsHeaderValue;
            String actualValue = req.getHeader(this.httpsHeaderName);
            if (!NullOrEmpty.nullOrEmpty((CharSequence)actualValue)) {
                return expectedValue.equals(actualValue.trim());
            }
        }
        return false;
    }

    static ForceSecure instance() {
        return INSTANCE;
    }

    private static URI httpsRequestUri(HttpServletRequest req) {
        try {
            URI requestUri = new URI(HTTPS_SCHEME, null, req.getServerName(), -1, URLEncoding.decode((String)req.getRequestURI()), null, null);
            return requestUri;
        }
        catch (URISyntaxException e) {
            throw URIs.illegalUri((URISyntaxException)e);
        }
    }

    private static Pair<String, String> parseHttpsHeaderCheck(String text) {
        int colon;
        Pair<String, String> result = NO_HTTPS_HEADER_CHECK;
        if (!NullOrEmpty.nullOrEmpty((CharSequence)text) && (colon = text.indexOf(":")) != -1 && colon < text.length() - 1) {
            String name = text.substring(0, colon).trim();
            String value = text.substring(colon + 1).trim();
            return Pair.pair((Object)name, (Object)value);
        }
        return result;
    }

    private static class ForceHttpsRequest
    extends HttpServletRequestWrapper {
        private final URI requestUri;

        ForceHttpsRequest(URI requestUri, HttpServletRequest request) {
            super(request);
            this.requestUri = requestUri;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ForceHttpsRequest) {
                ForceHttpsRequest other = (ForceHttpsRequest)((Object)obj);
                return this.getRequest().equals(other.getRequest());
            }
            return false;
        }

        public StringBuffer getRequestURL() {
            return new StringBuffer(this.requestUri.toString());
        }

        public String getScheme() {
            return ForceSecure.HTTPS_SCHEME;
        }

        public int getServerPort() {
            return 443;
        }

        public int hashCode() {
            return this.getRequest().hashCode();
        }

        public boolean isSecure() {
            return true;
        }

        public String toString() {
            return this.getRequest().toString();
        }
    }

    private final class ConfigurationChanged
    implements ConfigurationEventListener {
        private ConfigurationChanged() {
        }

        public void configurationChanged(String name, Configuration newConf) {
            ForceSecure.this.forceHttps = (Boolean)PrimitiveTypes.valueOf((CharSequence)newConf.get("security.forceHTTPS", "false"), Boolean.class);
            if (ForceSecure.this.forceHttps) {
                LOG.info("All requests are being treated as HTTPS requests");
            }
            Pair httpsHeaderCheck = ForceSecure.parseHttpsHeaderCheck(newConf.get("security.httpsHeaderCheck"));
            ForceSecure.this.httpsHeaderName = (String)httpsHeaderCheck.first();
            ForceSecure.this.httpsHeaderValue = (String)httpsHeaderCheck.second();
            if (!NullOrEmpty.nullOrEmpty((CharSequence)ForceSecure.this.httpsHeaderName)) {
                if (ForceSecure.this.forceHttps) {
                    LOG.warning("security.forceHTTPS is enabled, and security.httpsHeaderCheck is also enabled, this is not permitted. security.httpsHeaderCheck value will  be ignored, please fix your configuration.");
                } else {
                    LOG.info("Requests containing the header: <" + ForceSecure.this.httpsHeaderName + ": " + ForceSecure.this.httpsHeaderValue + "> will be treated as HTTPS requests");
                }
            }
        }

        public void configurationRemoved(String name) {
        }
    }
}

