/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.dbtools.common.util.Base64;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Digests;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.HttpResources;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.WebException;

public class ETags {
    private static final EntityHeaders GENERATE_ETAG = Entities.headers(HttpHeader.ETAG, "");
    private static final EntityHeaders NO_EXTRA_HEADERS = Entities.headers().build();
    private static final String QUOTE = "\"";

    public HttpResource checkPrecondition(ResourceDispatcher.Score score, RequestEntity request, ResourceDispatcher dispatchers) throws IOException {
        RequestEntity currentVersionRequest;
        boolean isRead = Requests.isRead(request);
        boolean hasCondition = this.hasCondition(request);
        boolean requiresCurrentVersion = isRead || hasCondition;
        String currentVersionIdentifier = null;
        Entity currentResponse = null;
        HttpResource currentVersion = null;
        if (requiresCurrentVersion && (currentVersionIdentifier = (currentVersion = dispatchers.dispatch(isRead ? score : null, currentVersionRequest = this.get(request))).version()) != null && currentVersionIdentifier.isEmpty()) {
            currentResponse = currentVersion.response(currentVersionRequest);
            currentResponse = this.etag(Entities.merge(currentResponse, GENERATE_ETAG));
            currentVersionIdentifier = ETags.version(currentResponse.headers().header(HttpHeader.ETAG));
        }
        if (hasCondition && currentVersionIdentifier != null) {
            try {
                this.checkPrecondition(request, currentVersionIdentifier);
            }
            catch (WebException e) {
                Closeables.close(currentVersion);
                throw e;
            }
        }
        if (isRead) {
            if (currentResponse == null) {
                currentResponse = currentVersion.response(request);
            }
            return HttpResources.maybeVersioned(currentVersionIdentifier, currentResponse);
        }
        return dispatchers.dispatch(score, request);
    }

    private void checkPrecondition(RequestEntity request, String current) {
        if (Requests.isRead(request)) {
            EntityHeader condition = request.headers().header(HttpHeader.IF_NONE_MATCH);
            if (condition != null && !condition.value().equals("*") && ETags.version(condition).equals(current)) {
                throw WebException.notModified();
            }
        } else {
            EntityHeader condition = request.headers().header(HttpHeader.IF_MATCH);
            if (condition != null && !condition.value().equals("*") && !ETags.version(condition).equals(current)) {
                throw WebException.preconditionFailed();
            }
        }
    }

    public Entity etag(Entity existing) throws IOException {
        EntityHeader etag = existing.headers().header(HttpHeader.ETAG);
        if (etag == null || !NullOrEmpty.nullOrEmpty((CharSequence)etag.value())) {
            return existing;
        }
        return new DigestedEntity(existing);
    }

    private RequestEntity get(RequestEntity request) throws IOException {
        if (Requests.isRead(request)) {
            return request;
        }
        return Requests.forward(request, request.path(), true, NO_EXTRA_HEADERS);
    }

    private boolean hasCondition(RequestEntity request) {
        EntityHeader condition;
        return Requests.isRead(request) ? (condition = request.headers().header(HttpHeader.IF_NONE_MATCH)) != null && !condition.value().equals("*") : (condition = request.headers().header(HttpHeader.IF_MATCH)) != null && !condition.value().equals("*");
    }

    static Entity etagHeader(Entity response, String version) {
        return Entities.merge(response, Entities.headers(HttpHeader.ETAG, QUOTE + version + QUOTE));
    }

    static EntityHeaders etagHeader(EntityHeaders response, String version) {
        return Entities.merge(response, Entities.headers(HttpHeader.ETAG, QUOTE + version + QUOTE));
    }

    static String version(EntityHeader condition) {
        if (condition == null) {
            return null;
        }
        String value = condition.value();
        if (value == null) {
            return null;
        }
        return value.replaceAll("\"(.*)\"", "$1");
    }

    private static class DigestedEntity
    implements Entity {
        private final byte[] bytes;
        private final EntityHeaders headers;

        private DigestedEntity(Entity existing) throws IOException {
            Digests.Builder digest = Digests.builder();
            EntityHeaders headers = existing.headers();
            for (String name : headers) {
                digest.digest((CharSequence)name.toLowerCase());
                EntityHeader hdr = headers.header(name);
                for (String value : hdr) {
                    digest.digest((CharSequence)value);
                }
            }
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            StreamCopy.drain((InputStream)digest.stream(existing.body()), (OutputStream)bytes);
            Closeables.close((Object)existing);
            String version = Base64.byteArrayToBase64((byte[])digest.build());
            this.headers = ETags.etagHeader(headers, version);
            this.bytes = bytes.toByteArray();
        }

        @Override
        public InputStream body() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public EntityHeaders headers() {
            return this.headers;
        }

        public String toString() {
            return Entities.toString(this.headers);
        }
    }
}

