/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Reflections;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Selectors;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.validation.Constraint;
import oracle.dbtools.rt.validation.ConstraintDescriptor;
import oracle.dbtools.rt.validation.ConstraintDescriptorImpl;
import oracle.dbtools.rt.validation.ConstraintValidator;
import oracle.dbtools.rt.validation.ConstraintViolation;
import oracle.dbtools.rt.validation.ViolationsBuilder;

@Service
public class Validator {
    public static final String SUPPORTED_CONSTRAINT = "oracle.dbtools.rt.validator.supportedConstraint";

    public <T> Set<ConstraintViolation<T>> validate(Iterable<T> objects) {
        LinkedHashSet<ConstraintViolation<T>> allViolations = new LinkedHashSet<ConstraintViolation<T>>();
        this.validate((Set<ConstraintViolation<T>>)allViolations, objects);
        return allViolations;
    }

    public <T> Set<ConstraintViolation<T>> validate(T ... objects) {
        return this.validate((Iterable<T>)Arrays.asList(objects));
    }

    private <T> void validate(Set<ConstraintViolation<T>> allViolations, Iterable<T> objects) {
        for (T object : objects) {
            if (object == null) continue;
            ViolationsBuilder<T> violations = new ViolationsBuilder<T>(object);
            Class<?> clazz = object.getClass();
            for (Field field : Validator.constrainedFields(clazz)) {
                Validator.validateField(violations, field, object);
            }
            allViolations.addAll(violations.violations());
        }
    }

    static <A extends Annotation> ConstraintDescriptor<A> constraintDescriptor(A annotation) {
        return (ConstraintDescriptor)Validator.constraintDescriptor().apply(annotation);
    }

    static Selector<Annotation> isConstraint() {
        return new Selector<Annotation>(){

            public Boolean apply(Annotation x) {
                return x.annotationType().getAnnotation(Constraint.class) != null;
            }
        };
    }

    private static Iterable<Field> constrainedFields(Class<?> clazz) {
        return Iterables.select((Iterable)Reflections.fields(clazz), (Selector)Selectors.and((Selector)Reflections.hasAnnotations(), Validator.hasConstraints()));
    }

    private static <T extends Annotation> Transform<T, ConstraintDescriptor<T>> constraintDescriptor() {
        return new Transform<T, ConstraintDescriptor<T>>(){

            public ConstraintDescriptor<T> apply(T x) {
                return new ConstraintDescriptorImpl(x);
            }
        };
    }

    private static <A extends Annotation, V> void defaultValidators(A annotation, List<ConstraintValidator<A, V>> validators) {
        for (ConstraintValidator validator : ServiceLocator.acquireAll(ConstraintValidator.class, (String[])new String[]{SUPPORTED_CONSTRAINT, annotation.annotationType().getName()})) {
            validators.add(validator);
        }
    }

    private static Selector<Field> hasConstraints() {
        return new Selector<Field>(){

            public Boolean apply(Field x) {
                return Iterables.contains((Iterable)Reflections.annotations((Field)x), Validator.isConstraint());
            }
        };
    }

    private static <V, T> void validate(ViolationsBuilder<T> violations, Iterable<ConstraintDescriptor<Annotation>> constraints, V value) {
        for (ConstraintDescriptor<Annotation> constraint : constraints) {
            Validator.validate(violations, value, constraint);
        }
    }

    private static <T, A extends Annotation, V> void validate(ViolationsBuilder<T> violations, V value, ConstraintDescriptor<A> descriptor) {
        List<ConstraintValidator<A, V>> validators = Validator.validators(value, descriptor);
        for (ConstraintValidator<A, V> constraintValidator : validators) {
            constraintValidator.initialize(descriptor.getAnnotation());
            if (constraintValidator.isValid(value)) continue;
            violations.violation(value, descriptor);
        }
        for (ConstraintDescriptor constraintDescriptor : descriptor.getComposingConstraints()) {
            Validator.validate(violations, value, constraintDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T, V> void validateField(ViolationsBuilder<T> violations, Field field, T object) {
        Iterable constraints = Iterables.transform((Iterable)Iterables.select((Iterable)Reflections.annotations((Field)field), Validator.isConstraint()), Validator.constraintDescriptor());
        Object fieldValue = Reflections.fieldValue(object, (Field)field);
        boolean indexed = field.getType().isArray();
        violations.enter(field.getName(), indexed);
        try {
            if (fieldValue != null && indexed) {
                int length = Array.getLength(fieldValue);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(fieldValue, i);
                    Validator.validate(violations, constraints, value);
                    violations.next();
                }
            } else {
                Object value = fieldValue;
                Validator.validate(violations, constraints, value);
            }
        }
        finally {
            violations.exit();
        }
    }

    private static <A extends Annotation, V> ConstraintValidator<A, V> validator(Class<? extends ConstraintValidator<A, ?>> validatorClass, V value) {
        return (ConstraintValidator)Reflections.newInstance(validatorClass);
    }

    private static <A extends Annotation, V> List<ConstraintValidator<A, V>> validators(V value, ConstraintDescriptor<A> descriptor) {
        ArrayList<ConstraintValidator<A, V>> validators = new ArrayList<ConstraintValidator<A, V>>();
        for (Class<ConstraintValidator<A, ?>> validatorClass : descriptor.getConstraintValidatorClasses()) {
            ConstraintValidator<A, V> validator = Validator.validator(validatorClass, value);
            validators.add(validator);
        }
        if (validators.isEmpty()) {
            Validator.defaultValidators(descriptor.getAnnotation(), validators);
        }
        return validators;
    }
}

