/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.statistics;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import oracle.dbtools.apex.statistics.Statistics;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Timestamps;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.json.JSONBuilder;
import oracle.dbtools.json.JSONNode;
import oracle.dbtools.json.JSONOptions;
import oracle.dbtools.json.JSONValue;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class StatisticsService
extends RequestHandler {
    static final String PATH = "_/statistics/";
    public static final RequestHandlerMetaData META_DATA = StatisticsService.secureService("_/statistics/", HttpMethod.GET);
    static final String ERRORS_PATH = "_/statistics/errors";
    static final String LOG_PATH = "_/statistics/log";

    public StatisticsService() {
        super(META_DATA);
    }

    @Override
    protected Entity get(RequestEntity request) throws IOException {
        Statistics.Report report = Statistics.getInstance().getReport();
        URI base = URIs.create((String)request.base());
        JSONBuilder json = this.reportAsJson(base, report);
        String content = JSONBuilder.render((JSONNode)json.build());
        return StatisticsService.entity(StreamCopy.toInputStream((CharSequence)content), StatisticsService.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, ContentTypes.JSON}), new Object[0]);
    }

    private JSONBuilder reportAsJson(URI base, Statistics.Report report) {
        JSONBuilder json = JSONBuilder.o((JSONOptions)JSONOptions.DEFAULT_JSON_OPTIONS);
        json.p("report_time", (CharSequence)Timestamps.toString((long)report.getReportTime()));
        json.p("uptime", (Number)report.getUptime());
        json.p("pages_served", (Number)report.getPagesServed());
        json.p("bytes_sent", (Number)report.getBytesSent());
        json.p("total_errors", (Number)report.getTotalErrors());
        json.p("total_files", (Number)report.getTotalFiles());
        json.p("security_cache_size", (Number)report.getSecurityCacheSize());
        json.p("security_cache_max_entries", (Number)report.getSecurityCacheMaxEntries());
        if (report.getCacheSize() != -1L) {
            json.p("cache_size", (Number)report.getCacheSize());
            json.p("cache_max_entries", (Number)report.getCacheMaxEntries());
        }
        json.p("active_requests", (Number)report.getActiveRequests());
        json.p("total_times", this.timingsAsJson(report.getTotalTimes()));
        json.p("db_times", this.timingsAsJson(report.getDbTimes()));
        URI errors = URIs.resolve((URI)base, (String)ERRORS_PATH);
        URI logs = URIs.resolve((URI)base, (String)LOG_PATH);
        json.p("errors", errors);
        json.p("log", logs);
        return json;
    }

    private JSONValue<?> timingsAsJson(Statistics.Timings timings) {
        JSONBuilder json = JSONBuilder.o((JSONOptions)JSONOptions.DEFAULT_JSON_OPTIONS);
        json.p("total", (Number)new BigDecimal(timings.getTotal()).longValue());
        json.p("minimum", (Number)new BigDecimal(timings.getMinimum()).doubleValue());
        json.p("average", (Number)timings.getAverage().doubleValue());
        json.p("median", (Number)timings.getMedian().doubleValue());
        json.p("maximum", (Number)new BigDecimal(timings.getMaximum()).doubleValue());
        return JSONBuilder.v((JSONBuilder)json);
    }
}

