/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.security.Principal;
import oracle.dbtools.common.config.db.DatabaseConfig;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCMetricsPrincipal;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.jdbc.JDBCProxyPrincipal;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

public class ResourceTemplatesJDBCPrincipal {
    private static final String RESOURCE_TEMPLATES_POOL_SUFFIX = "_rt";

    public static RequestEntity request(RequestEntity request, String parsingSchema, String module, String action) {
        TenantPrincipal tenant;
        JDBCCallProvider jdbc = (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
        CompoundPrincipal existingPrincipal = request.principal();
        JDBCPrincipal existing = (JDBCPrincipal)existingPrincipal.principal(JDBCPrincipal.class);
        if (existing == null) {
            existing = jdbc.principal(null);
        }
        if (existing == null) {
            throw WebException.serviceUnavailable();
        }
        String poolIdentifier = ResourceTemplatesJDBCPrincipal.restUserPoolIdentifier(existing);
        JDBCPrincipal resourceTemplates = jdbc.principal(poolIdentifier);
        if (resourceTemplates == null) {
            throw WebException.serviceUnavailable();
        }
        RequestEntity addedJDBCPrincipal = Requests.replacePrincipal(request, (Principal)resourceTemplates, JDBCPrincipal.class);
        if (parsingSchema == null && (tenant = (TenantPrincipal)existingPrincipal.principal(TenantPrincipal.class)) != null) {
            parsingSchema = tenant.getName();
        }
        RequestEntity addedMetrics = Requests.replacePrincipal(addedJDBCPrincipal, (Principal)JDBCMetricsPrincipal.metrics((CompoundPrincipal)addedJDBCPrincipal.principal(), (String)module, (String)action), JDBCMetricsPrincipal.class);
        if (parsingSchema == null) {
            return addedMetrics;
        }
        JDBCProxyPrincipal proxy = new JDBCProxyPrincipal(parsingSchema);
        return Requests.replacePrincipal(addedMetrics, (Principal)proxy, JDBCProxyPrincipal.class);
    }

    private static String restUserPoolIdentifier(JDBCPrincipal existing) {
        String poolIdentifier = existing.getName();
        String poolName = DatabaseConfig.poolName((String)poolIdentifier);
        String serviceName = DatabaseConfig.serviceName((String)poolIdentifier);
        String restPoolName = poolName + RESOURCE_TEMPLATES_POOL_SUFFIX;
        return DatabaseConfig.poolIdentifier((String)restPoolName, (String)serviceName);
    }
}

