/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.uri.HasURITemplate;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.uri.URITemplates;

class JDBCURITemplate
implements HasURITemplate {
    private final TenantIdentifier scopeId;
    private final TenantIdentifier templateId;
    private final URITemplate uriTemplate;
    private final Iterable<String> originsAllowed;

    public JDBCURITemplate(ResultRow row) {
        String prefix = (String)row.get(1, String.class);
        String pattern = (String)row.get(2, String.class);
        Integer priority = (Integer)row.get(3, Integer.class);
        if (prefix != null && prefix.trim().length() > 0) {
            pattern = prefix + pattern;
        }
        int p = 0;
        if (priority != null) {
            p = priority;
        }
        this.uriTemplate = URITemplates.uriTemplate(pattern, p);
        this.templateId = JDBCIdentifiers.valueOf(row, 5, 4);
        this.scopeId = JDBCIdentifiers.valueOf(row, 5, 6);
        this.originsAllowed = Iterables.iterable((Object[])Text.commaDelimited((String)((String)row.get(7, String.class))));
    }

    public Iterable<String> originsAllowed() {
        return this.originsAllowed;
    }

    public TenantIdentifier scopeId() {
        return this.scopeId;
    }

    public TenantIdentifier templateId() {
        return this.templateId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JDBCURITemplate [scopeId=");
        builder.append(this.scopeId);
        builder.append(", templateId=");
        builder.append(this.templateId);
        builder.append(", uriTemplate=");
        builder.append(this.uriTemplate);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public URITemplate uriTemplate() {
        return this.uriTemplate;
    }
}

