/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import java.io.IOException;
import java.security.Principal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.UsesQuery;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.authentication.SecurityConfigs;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.oauth.OAuthScopeProvider;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.resource.templates.jdbc.AsTemplate;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCResourceTemplates;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCURITemplate;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesDispatcher;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.uri.URITemplates;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.WebException;

@Service(priority=1)
public class JDBCResourceTemplateDispatcher
extends UsesQuery
implements ResourceDispatcher,
OAuthScopeProvider {
    @Reference
    private JDBCCallProvider jdbc;
    @Reference
    private ResourceTemplatesDispatcher dispatcher;
    private JDBCResourceTemplates resourceTemplates;
    private static final AsTemplate AS_URI_TEMPLATE = new AsTemplate();
    private static final String CAN_DISPATCH = "select\n  s.module_uri_prefix,\n  s.template_uri_template,\n  s.template_priority,\n  s.template_id,\n  s.security_group_id,\n  s.privilege_id,\n  s.module_origins_allowed\nfrom wwv_flow_rt$services s\nwhere (  s.security_group_id = :tenant_id \n     OR (s.security_group_id = 10 and s.module_parsing_schema = 'APEX_PUBLIC_USER')      OR (s.security_group_id = 10 and s.module_parsing_schema = '!USER_SCHEMA')          )  AND  (:path LIKE (case when s.module_uri_prefix is null \n        then ''\n        else s.module_uri_prefix\n       end) || '%')\norder by s.template_priority desc";
    private static final Statement CAN_DISPATCH_STMT = JDBCIdentifiers.tenantKeyParameter(StatementBuilder.query().append((CharSequence)"select\n  s.module_uri_prefix,\n  s.template_uri_template,\n  s.template_priority,\n  s.template_id,\n  s.security_group_id,\n  s.privilege_id,\n  s.module_origins_allowed\nfrom wwv_flow_rt$services s\nwhere (  s.security_group_id = :tenant_id \n     OR (s.security_group_id = 10 and s.module_parsing_schema = 'APEX_PUBLIC_USER')      OR (s.security_group_id = 10 and s.module_parsing_schema = '!USER_SCHEMA')          )  AND  (:path LIKE (case when s.module_uri_prefix is null \n        then ''\n        else s.module_uri_prefix\n       end) || '%')\norder by s.template_priority desc")).parameter("path").build();

    @Override
    public ResourceDispatcher.Score canDispatch(RequestEntity request) {
        try {
            String path = request.path();
            JDBCURITemplate match = this.matches(request.principal(), path);
            if (match == null) {
                return ResourceDispatcher.NO_MATCH;
            }
            Requests.log(request, match.uriTemplate() + " matches: " + request.path() + " score: " + match.uriTemplate().priority());
            return new ResourceDispatcher.Score(match.uriTemplate().priority(), this.securityRealm(match), (Object)match, match.originsAllowed(), true);
        }
        catch (ConnectionPoolException e) {
            return ResourceDispatcher.NO_MATCH;
        }
    }

    @Override
    public HttpResource dispatch(ResourceDispatcher.Score score, RequestEntity request) throws IOException {
        try {
            JDBCURITemplate match = (JDBCURITemplate)score.handle();
            score = new ResourceDispatcher.Score(match.uriTemplate().priority(), this.securityRealm(match), (Object)match.templateId(), new String[0]);
            return this.dispatcher.dispatch(this.resourceTemplates, score, request);
        }
        catch (ConnectionPoolException e) {
            throw WebException.serviceUnavailable().cause(e);
        }
    }

    @Override
    public TenantIdentifier scopeForPath(CompoundPrincipal principal, String path) {
        try {
            JDBCURITemplate match;
            String tenantName;
            TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
            if (tenant != null && (tenantName = tenant.getName()) != null && (match = this.matches(principal, path)) != null) {
                return match.scopeId();
            }
            return null;
        }
        catch (ConnectionPoolException e) {
            return null;
        }
    }

    private Iterator<ResultRow> candidates(CompoundPrincipal principal, String path) {
        TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
        CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
        JDBCTransaction txn = null;
        try {
            if (TenantPrincipal.hasTenant(tenant)) {
                txn = this.jdbc.transaction((Principal)apexListener);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                JDBCIdentifiers.bind(parameters, principal);
                parameters.put("path", path);
                return Iterators.alsoClose((Iterator)this.query.query((Transaction)txn, CAN_DISPATCH_STMT, parameters, false), (Object[])new Object[]{txn});
            }
            return Iterators.empty();
        }
        catch (SQLException e) {
            Closeables.close(txn);
            throw JDBCException.wrap((SQLException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JDBCURITemplate matches(CompoundPrincipal principal, String path) {
        Iterator<ResultRow> candidates = null;
        try {
            candidates = this.candidates(principal, path);
            Iterator candidateTemplates = Iterators.transform(candidates, (Transform)AS_URI_TEMPLATE);
            Set matches = URITemplates.choose(candidateTemplates, path);
            if (matches.isEmpty()) {
                JDBCURITemplate jDBCURITemplate = null;
                return jDBCURITemplate;
            }
            JDBCURITemplate jDBCURITemplate = (JDBCURITemplate)Iterables.first(matches);
            return jDBCURITemplate;
        }
        finally {
            Closeables.close(candidates);
        }
    }

    private SecurityConfig securityRealm(JDBCURITemplate match) {
        return match.scopeId() == null ? SecurityConfigs.NONE : SecurityConfigs.SECURE_REST_SERVICE;
    }

    protected void activate(ServiceProperties properties) {
        this.resourceTemplates = new JDBCResourceTemplates(this.query);
    }
}

