/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.generator;

import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.resource.generator.ResourceRequest;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;

public abstract class ResourceRequests {
    private ResourceRequests() {
    }

    public static Pair<EntityHeaders, Map<String, Object>> outboundValues(ResourceRequest request, Map<String, Object> results) {
        EntityHeadersBuilder b = Entities.headers();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        for (ResourceParameter p : ResourceRequests.outbound(request)) {
            Object value = results.get(p.bindName());
            if (value == null) continue;
            if (p.kind() == ResourceParameter.Kind.HEADER) {
                b.header((CharSequence)p.originalName(), value.toString());
                continue;
            }
            params.put(p.originalName(), value);
        }
        return Pair.pair((Object)b.build(), params);
    }

    private static Iterable<ResourceParameter> outbound(ResourceRequest request) {
        return Iterables.select(request.explicitParameters(), (Selector)new Selector<ResourceParameter>(){

            public Boolean apply(ResourceParameter x) {
                return x.access() == ParameterAccess.OUT || x.access() == ParameterAccess.INOUT;
            }
        });
    }
}

