/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.role;

import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.oauth.OAuthProfile;
import oracle.dbtools.rt.oauth.role.Role;
import oracle.dbtools.rt.oauth.role.Roles;
import oracle.dbtools.rt.resource.collection.FeedItem;
import oracle.dbtools.rt.resource.collection.tenants.TenantEntityCollectionRequestHandler;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.WebException;

@Service(provides={ResourceDispatcher.class})
public class RolesRequestHandler
extends TenantEntityCollectionRequestHandler {
    @Reference
    private Roles roles;
    private static final String NAME = "name";

    public RolesRequestHandler() {
        super(OAuthProfile.ROLE_URI_TEMPLATES, OAuthProfile.OAUTH_ROLE_JSON);
    }

    @Override
    protected TreeReader<TenantEntity> entityGraphReader() {
        throw RolesRequestHandler.notSupported();
    }

    @Override
    protected Iterator<FeedItem> items(Transaction txn, RequestEntity request) {
        Iterable<Role> roles = this.roles.entities(txn, request.principal());
        Iterable items = Iterables.transform(roles, (Transform)new Transform<Role, FeedItem>(){

            public FeedItem apply(final Role role) {
                return new FeedItem(){

                    @Override
                    public String id() {
                        return null;
                    }

                    @Override
                    public ResultRow item() {
                        return ResultRows.row((String[])new String[]{RolesRequestHandler.NAME}, (Object[])new Object[]{role.name()});
                    }
                };
            }
        });
        return Iterators.alsoClose(items.iterator(), (Object[])new Object[]{roles});
    }

    @Override
    protected Transaction transaction(CompoundPrincipal principal) {
        return this.roles.newTransaction(principal);
    }

    private static WebException notSupported() {
        throw WebException.methodNotAllowed(Iterables.iterable((Object[])new String[]{HttpMethod.GET.method()}));
    }
}

