/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Tree;
import oracle.dbtools.json.JSONProperty;
import oracle.dbtools.rt.home.EntityReaderBase;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.validation.ConstraintViolation;
import oracle.dbtools.rt.validation.Validator;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public class ClientReader
extends EntityReaderBase<TenantEntity, Client> {
    private final Validator validator;

    ClientReader(Validator validator) {
        this.validator = validator;
    }

    @Override
    public Tree<TenantEntity> read(CompoundPrincipal principal, InputStream content) throws IOException {
        Tree tree = super.read(principal, content);
        this.validate(tree);
        return tree;
    }

    @Override
    protected Client newEntity() {
        return new Client();
    }

    @Override
    protected void processProperty(CompoundPrincipal principal, Client client, String name, JSONProperty prop) {
        if ("name".equals(name)) {
            client.name(ClientReader.string(prop));
        } else if ("description".equals(name)) {
            client.description(ClientReader.string(prop));
        } else if ("redirectUri".equals(name)) {
            client.redirectUri(ClientReader.string(prop));
        } else if ("responseType".equals(name)) {
            client.responseType(ApprovalRequest.ResponseType.valueOf(ClientReader.string(prop).toUpperCase()));
        } else if ("supportEmail".equals(name)) {
            client.supportEmail(ClientReader.string(prop));
        } else if ("scopes".equals(name)) {
            Iterable<String> scopes = ClientReader.array(prop, String.class);
            for (String scope : scopes) {
                client.scope(scope);
            }
        }
    }

    private String target(ConstraintViolation<?> violation) {
        return violation.getPropertyPath().toString();
    }

    private void validate(Tree<TenantEntity> tree) {
        ArrayList<Reason> reasons = new ArrayList<Reason>();
        tree.node();
        for (ConstraintViolation<TenantEntity> violation : this.validator.validate((TenantEntity)tree.node())) {
            reasons.add(Reason.reason(this.target(violation), violation));
        }
        if (!reasons.isEmpty()) {
            throw WebException.badRequest(reasons);
        }
    }
}

