/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.client;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.json.JSONOptions;
import oracle.dbtools.rt.home.EntityMetaData;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityBase;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.json.query.JSONQueryStream;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.uri.ValidURI;
import oracle.dbtools.rt.validation.NotNull;
import oracle.dbtools.rt.validation.Size;
import oracle.dbtools.rt.validation.ValidEmail;

public class Client
extends TenantEntityBase
implements TenantEntity,
EntityMetaData.UpdateListener {
    @NotNull
    private ApprovalRequest.AuthFlow authFlow = ApprovalRequest.AuthFlow.IMPLICIT;
    @Size(min=32, max=32)
    private String clientId;
    @Size(min=32, max=32)
    private String clientSecret;
    @Size(max=255)
    private String createdBy = "unknown";
    @Size(max=4000)
    private String description;
    @NotNull
    @Size(max=255)
    private String name;
    @Size(max=2000)
    @ValidURI
    private String redirectUri;
    @NotNull
    private ApprovalRequest.ResponseType responseType = ApprovalRequest.ResponseType.TOKEN;
    private final List<String> scopes = new ArrayList<String>();
    @NotNull
    @ValidEmail
    @Size(max=255)
    private String supportEmail;
    private static String[] FIELDS = new String[]{"clientId", "clientSecret", "description", "name", "redirectUri", "responseType", "supportEmail", "scopes"};

    public Client() {
        this.listener(this);
    }

    public ApprovalRequest.AuthFlow authFlow() {
        return this.authFlow;
    }

    public Client authFlow(ApprovalRequest.AuthFlow authFlow) {
        this.authFlow = authFlow;
        return this;
    }

    public String clientId() {
        return this.clientId;
    }

    public Client clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public Client clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public InputStream content() {
        ResultRow row = ResultRows.row((String[])FIELDS, (Object[])new Object[]{this.clientId, this.clientSecret, this.description, this.name, this.redirectUri, this.responseType.toString().toLowerCase(), this.supportEmail, this.scopes.toArray(new String[this.scopes.size()])});
        return new JSONQueryStream(ResultRows.rows((ResultRow[])new ResultRow[]{row}), JSONOptions.DEFAULT_JSON_OPTIONS, true, null);
    }

    public String createdBy() {
        return this.createdBy;
    }

    public Client createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Client description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Client other = (Client)obj;
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.clientSecret == null ? other.clientSecret != null : !this.clientSecret.equals(other.clientSecret)) {
            return false;
        }
        if (this.createdBy == null ? other.createdBy != null : !this.createdBy.equals(other.createdBy)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.redirectUri == null ? other.redirectUri != null : !this.redirectUri.equals(other.redirectUri)) {
            return false;
        }
        if (this.responseType == null ? other.responseType != null : !this.responseType.equals((Object)other.responseType)) {
            return false;
        }
        return !(this.supportEmail == null ? other.supportEmail != null : !this.supportEmail.equals(other.supportEmail));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = 31 * result + (this.createdBy == null ? 0 : this.createdBy.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.redirectUri == null ? 0 : this.redirectUri.hashCode());
        result = 31 * result + (this.responseType == null ? 0 : this.responseType.hashCode());
        result = 31 * result + (this.supportEmail == null ? 0 : this.supportEmail.hashCode());
        return result;
    }

    public String name() {
        return this.name;
    }

    public Client name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public TenantIdentifier parentId() {
        return null;
    }

    @Override
    public void parentId(TenantIdentifier parentId) {
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public Client redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public ApprovalRequest.ResponseType responseType() {
        return this.responseType;
    }

    public Client responseType(ApprovalRequest.ResponseType responseType) {
        this.responseType = responseType;
        return this;
    }

    public List<String> scopes() {
        return Collections.unmodifiableList(this.scopes);
    }

    public String supportEmail() {
        return this.supportEmail;
    }

    public Client supportEmail(String supportEmail) {
        this.supportEmail = supportEmail;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Client [clientId=");
        builder.append(this.clientId);
        builder.append(", clientSecret=");
        builder.append(this.clientSecret);
        builder.append(", createdBy=");
        builder.append(this.createdBy);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", redirectUri=");
        builder.append(this.redirectUri);
        builder.append(", responseType=");
        builder.append((Object)this.responseType);
        builder.append(", supportEmail=");
        builder.append(this.supportEmail);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void updated(EntityMetaData.UpdateType type, String user, long when) {
        if (EntityMetaData.UpdateType.CREATED == type) {
            this.createdBy = user;
        }
    }

    public Client scope(String scope) {
        this.scopes.add(scope);
        return this;
    }
}

